/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationSwitchPipeline
extends BreedingPipeline {
    public static final String P_SWITCHAT = "switch-at";
    public static final String P_MULTIBREED = "generation-switch";
    public static final String P_GEN_MAX = "generate-max";
    public static final int NUM_SOURCES = 2;
    public int maxGeneratable;
    public boolean generateMax;
    public int generationSwitch;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_MULTIBREED);
    }

    @Override
    public int numSources() {
        return 2;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        state.output.exitIfErrors();
        this.generationSwitch = state.parameters.getInt(base.push(P_SWITCHAT), def.push(P_SWITCHAT), 0);
        if (this.generationSwitch < 0) {
            state.output.fatal("GenerationSwitchPipeline must have a switch-at >= 0", base.push(P_SWITCHAT), def.push(P_SWITCHAT));
        }
        this.generateMax = state.parameters.getBoolean(base.push(P_GEN_MAX), def.push(P_GEN_MAX), true);
        this.maxGeneratable = 0;
        if (this.likelihood < 1.0) {
            state.output.warning("GenerationSwitchPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public int typicalIndsProduced() {
        if (this.maxGeneratable == 0) {
            this.maxGeneratable = this.maxChildProduction();
        }
        return this.maxGeneratable;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int total;
        BreedingSource s;
        int start = inds.size();
        BreedingSource breedingSource = s = state.generation < this.generationSwitch ? this.sources[0] : this.sources[1];
        if (this.generateMax) {
            int n;
            if (this.maxGeneratable == 0) {
                this.maxGeneratable = this.maxChildProduction();
            }
            if ((n = this.maxGeneratable) < min) {
                n = min;
            }
            if (n > max) {
                n = max;
            }
            total = s.produce(n, n, subpopulation, inds, state, thread, misc);
        } else {
            total = s.produce(min, max, subpopulation, inds, state, thread, misc);
        }
        return total;
    }
}

