/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Species;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationPipeline
extends BreedingPipeline {
    public static final String P_INIT = "init";
    public static final int NUM_SOURCES = 0;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_INIT);
    }

    @Override
    public int numSources() {
        return 0;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.likelihood != 1.0) {
            state.output.warning("InitializationPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        Species s = state.population.subpops.get((int)subpopulation).species;
        for (int q = 0; q < max; ++q) {
            inds.add(s.newIndividual(state, thread));
        }
        return max;
    }
}

