/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.amalgam;

import ec.Breeder;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.eda.amalgam.AMALGAMSpecies;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.util.ArrayList;

public class AMALGAMBreeder
extends Breeder {
    public void setup(EvolutionState state, Parameter base) {
    }

    public Population breedPopulation(EvolutionState state) {
        Population pop = state.population;
        for (int i = 0; i < pop.subpops.size(); ++i) {
            Subpopulation subpop = pop.subpops.get(i);
            if (!(subpop.species instanceof AMALGAMSpecies)) {
                state.output.fatal("To use AMALGAMBreeder, subpopulation " + i + " must contain a AMALGAMSpecies.  But it contains a " + subpop.species);
            }
            AMALGAMSpecies species = (AMALGAMSpecies)subpop.species;
            species.updateDistribution(state, subpop);
            ArrayList<Individual> inds = subpop.individuals;
            for (int j = 1; j < inds.size(); ++j) {
                inds.set(j, species.newIndividual(state, 0));
            }
            int nAMS = (int)(species.alphaAMS * (double)inds.size());
            for (int j = 0; j < nAMS; ++j) {
                species.shiftIndividual(state, (DoubleVectorIndividual)inds.get(j + 1));
            }
            species.firstGeneration = false;
        }
        return pop;
    }
}

