/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.dovs;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.Subpopulation;
import ec.eda.dovs.DOVSFitness;
import ec.eda.dovs.DOVSSpecies;
import ec.simple.SimpleEvaluator;
import ec.simple.SimpleProblemForm;
import java.util.ArrayList;

public class DOVSEvaluator
extends SimpleEvaluator {
    protected void evalPopChunk(EvolutionState state, int[] numinds, int[] from, int threadnum, SimpleProblemForm p) {
        ((Problem)((Object)p)).prepareToEvaluate(state, threadnum);
        ArrayList<Subpopulation> subpops = state.population.subpops;
        int len = subpops.size();
        for (int pop = 0; pop < len; ++pop) {
            int fp = from[pop];
            int upperbound = fp + numinds[pop];
            ArrayList<Individual> inds = subpops.get((int)pop).individuals;
            if (subpops.get((int)pop).species instanceof DOVSSpecies) {
                DOVSSpecies species = (DOVSSpecies)subpops.get((int)pop).species;
                for (int i = 0; i < inds.size(); ++i) {
                    DOVSFitness fit = (DOVSFitness)inds.get((int)i).fitness;
                    int addrep = 2 - fit.numOfObservations();
                    for (int rep = 0; rep < addrep; ++rep) {
                        p.evaluate(state, inds.get(i), pop, threadnum);
                        ++species.numOfTotalSamples;
                    }
                }
                if (species.stochastic) {
                    int deltan = species.activeSolutions.size();
                    for (int i = 0; i < 2; ++i) {
                        p.evaluate(state, species.visited.get(species.optimalIndex), pop, threadnum);
                    }
                    species.numOfTotalSamples += 2L;
                    if ((deltan -= 2) > 0) {
                        DOVSFitness bestFit;
                        Individual bestInd;
                        DOVSFitness fit;
                        Individual ind;
                        int i;
                        double R = 0.0;
                        for (i = 0; i < species.activeSolutions.size(); ++i) {
                            ind = species.activeSolutions.get(i);
                            fit = (DOVSFitness)ind.fitness;
                            bestInd = species.visited.get(species.optimalIndex);
                            bestFit = (DOVSFitness)bestInd.fitness;
                            R += fit.variance / Math.max(1.0E-10, Math.abs(fit.mean - bestFit.mean));
                        }
                        for (i = 0; i < species.activeSolutions.size(); ++i) {
                            ind = species.activeSolutions.get(i);
                            fit = (DOVSFitness)ind.fitness;
                            bestInd = species.visited.get(species.optimalIndex);
                            bestFit = (DOVSFitness)bestInd.fitness;
                            double fraction = fit.variance / Math.max(1.0E-10, Math.abs(fit.mean - bestFit.mean)) / R;
                            double tempDeltan = fraction * (double)deltan;
                            if (!(tempDeltan > 1.0)) continue;
                            long roundedDeltan = (long)tempDeltan;
                            int j = 0;
                            while ((long)j < roundedDeltan) {
                                p.evaluate(state, ind, pop, threadnum);
                                ++j;
                            }
                            species.numOfTotalSamples += roundedDeltan;
                        }
                    }
                }
                int base = state.generation + 1;
                int newReps = (int)Math.ceil((double)species.initialReps * Math.max(1.0, Math.pow(Math.log((double)base / 2.0), 1.01)));
                species.repetition = species.stochastic ? (species.repetition >= newReps ? species.repetition : newReps) : 1;
                for (int count = 0; count < species.activeSolutions.size(); ++count) {
                    Individual individual = species.activeSolutions.get(count);
                    DOVSFitness fit = (DOVSFitness)individual.fitness;
                    if (fit.numOfObservations() >= species.repetition) continue;
                    int newrep = species.repetition - fit.numOfObservations();
                    for (int rep = 0; rep < newrep; ++rep) {
                        p.evaluate(state, individual, pop, threadnum);
                    }
                    species.numOfTotalSamples += (long)newrep;
                }
                Individual bestIndividual = species.visited.get(species.optimalIndex);
                DOVSFitness fit = (DOVSFitness)bestIndividual.fitness;
                if (fit.numOfObservations() < species.repetition) {
                    int newrep = species.repetition - fit.numOfObservations();
                    for (int rep = 0; rep < newrep; ++rep) {
                        p.evaluate(state, bestIndividual, pop, threadnum);
                    }
                    species.numOfTotalSamples += (long)newrep;
                }
                for (int i = 0; i < inds.size(); ++i) {
                    fit = (DOVSFitness)inds.get((int)i).fitness;
                    if (fit.numOfObservations() >= species.repetition) continue;
                    int newRep = species.repetition - fit.numOfObservations();
                    for (int rep = 0; rep < newRep; ++rep) {
                        p.evaluate(state, inds.get(i), pop, threadnum);
                    }
                    species.numOfTotalSamples += (long)newRep;
                }
                continue;
            }
            for (int x = fp; x < upperbound; ++x) {
                p.evaluate(state, inds.get(x), pop, threadnum);
            }
        }
        ((Problem)((Object)p)).finishEvaluating(state, threadnum);
    }
}

