/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.dovs;

import ec.EvolutionState;
import ec.simple.SimpleFitness;
import ec.util.Parameter;

public class DOVSFitness
extends SimpleFitness {
    public double sumSquared;
    public double sum;
    public double mean;
    public int numOfObservations;
    public double variance;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.sumSquared = 0.0;
        this.sum = 0.0;
        this.mean = 0.0;
        this.numOfObservations = 0;
        this.variance = 0.0;
    }

    public void reset() {
        this.sumSquared = 0.0;
        this.sum = 0.0;
        this.mean = 0.0;
        this.numOfObservations = 0;
        this.variance = 0.0;
    }

    public int numOfObservations() {
        return this.numOfObservations;
    }

    public double recordObservation(EvolutionState state, double result) {
        this.sum += result;
        this.sumSquared += result * result;
        ++this.numOfObservations;
        this.mean = this.sum / (double)this.numOfObservations;
        this.variance = this.numOfObservations == 1 ? 0.0 : (this.sumSquared - (double)this.numOfObservations * this.mean * this.mean) / (double)(this.numOfObservations - 1);
        this.setFitness(state, this.mean, false);
        return this.mean;
    }
}

