/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.dovs;

import ec.EvolutionState;
import ec.Individual;
import ec.eda.dovs.CornerMap;
import ec.eda.dovs.DOVSFitness;
import ec.eda.dovs.DOVSSpecies;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperboxSpecies
extends DOVSSpecies {
    public ArrayList<double[]> boxA;
    public ArrayList<Double> boxB;
    public static double UPPER_BOUND = 1.0E31;
    public static double EPSILON_STABILITY = 1.0E-20;
    public static double LARGE_NUMBER = 1.0E32;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.boxA = new ArrayList();
        this.boxB = new ArrayList();
    }

    @Override
    public void updateMostPromisingArea(EvolutionState state) {
        int i;
        int dimension = this.genomeSize;
        this.boxA = new ArrayList();
        this.boxB = new ArrayList();
        this.activeSolutions.clear();
        this.boxA.addAll(this.A);
        for (i = 0; i < this.b.length; ++i) {
            this.boxB.add(this.b[i]);
        }
        for (i = 0; i < dimension; ++i) {
            double btemp;
            double[] Atemp;
            int key = ((IntegerVectorIndividual)this.visited.get((int)this.optimalIndex)).genome[i];
            CornerMap.Pair pair = ((CornerMap)this.corners.get(i)).lowerBound(key);
            if (pair == null) {
                state.output.fatal("Error. Cannot find coordnation in coordinate position map.");
            }
            if (pair.key == key) {
                if (((CornerMap)this.corners.get(i)).hasSmaller(pair)) {
                    pair = ((CornerMap)this.corners.get(i)).smaller(pair);
                    this.activeSolutions.add(pair.value);
                    Atemp = new double[dimension];
                    Arrays.fill(Atemp, 0.0);
                    Atemp[i] = 1.0;
                    btemp = pair.getKey();
                    this.boxA.add(Atemp);
                    this.boxB.add(btemp);
                }
            } else {
                state.output.fatal("Problem in constructing hyperbox");
            }
            if ((pair = ((CornerMap)this.corners.get(i)).upperBound(key)) == null) continue;
            this.activeSolutions.add(pair.value);
            Atemp = new double[dimension];
            Arrays.fill(Atemp, 0.0);
            Atemp[i] = -1.0;
            btemp = pair.getKey();
            this.boxA.add(Atemp);
            this.boxB.add(btemp);
        }
    }

    @Override
    public ArrayList<Individual> mostPromisingAreaSamples(EvolutionState state, int popSize) {
        IntegerVectorIndividual bestIndividual = (IntegerVectorIndividual)this.visited.get(this.optimalIndex);
        int dimension = bestIndividual.genomeLength();
        int numOfConstraints = this.boxA.size();
        ArrayList<IntegerVectorIndividual> newSolutions = new ArrayList<IntegerVectorIndividual>();
        ArrayList<Individual> candidates = new ArrayList<Individual>();
        IntegerVectorIndividual newInd = (IntegerVectorIndividual)bestIndividual.clone();
        ((DOVSFitness)newInd.fitness).reset();
        newSolutions.add(newInd);
        for (int i = 0; i < popSize; ++i) {
            if (i > 0) {
                newInd = (IntegerVectorIndividual)((IntegerVectorIndividual)newSolutions.get(i - 1)).clone();
                ((DOVSFitness)newInd.fitness).reset();
                newSolutions.add(newInd);
            }
            for (int j = 0; j < this.warmUp; ++j) {
                newInd = (IntegerVectorIndividual)newSolutions.get(i);
                int directionToMove = state.random[0].nextInt(dimension);
                double[] b1 = new double[numOfConstraints];
                for (int k = 0; k < numOfConstraints; ++k) {
                    double sum = 0.0;
                    for (int l = 0; l < dimension; ++l) {
                        if (l == directionToMove) continue;
                        sum += this.boxA.get(k)[l] * (double)newInd.genome[l];
                    }
                    b1[k] = this.boxB.get(k) - sum;
                }
                double upper = UPPER_BOUND;
                double lower = UPPER_BOUND;
                for (int k = 0; k < numOfConstraints; ++k) {
                    double temp = 0.0;
                    temp = Math.abs(this.boxA.get(k)[directionToMove]) > EPSILON_STABILITY ? b1[k] / this.boxA.get(k)[directionToMove] : LARGE_NUMBER;
                    if (temp > (double)newInd.genome[directionToMove] + EPSILON_STABILITY) {
                        if (!(temp - (double)newInd.genome[directionToMove] < upper)) continue;
                        upper = temp - (double)newInd.genome[directionToMove];
                        continue;
                    }
                    if (temp < (double)newInd.genome[directionToMove] - EPSILON_STABILITY) {
                        if (!((double)newInd.genome[directionToMove] - temp < lower)) continue;
                        lower = (double)newInd.genome[directionToMove] - temp;
                        continue;
                    }
                    if (this.boxA.get(k)[directionToMove] > 0.0) {
                        lower = 0.0;
                        continue;
                    }
                    upper = 0.0;
                }
                int maxXDirectionToMove = (int)Math.floor(upper) + newInd.genome[directionToMove];
                int minXDirectionToMove = newInd.genome[directionToMove] - (int)Math.floor(lower);
                int length = maxXDirectionToMove - minXDirectionToMove;
                int step = state.random[0].nextInt(length + 1);
                newInd.genome[directionToMove] = minXDirectionToMove + step;
            }
            candidates.add((Individual)newSolutions.get(i));
        }
        return candidates;
    }
}

