/*
 * Decompiled with CFR 0.152.
 */
package ec.evolve;

import ec.EvolutionState;
import ec.Statistics;
import ec.Subpopulation;
import ec.util.Parameter;

public class RandomRestarts
extends Statistics {
    public static final String P_RESTART_TYPE = "restart-type";
    public static final String P_RESTART_UPPERBOUND = "restart-upper-bound";
    public static final String P_START = "start";
    public int countdown;
    public int upperbound;
    public int start;
    String restartType;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.restartType = state.parameters.getString(base.push(P_RESTART_TYPE), null);
        if (this.restartType == null) {
            this.restartType = "random";
        }
        this.upperbound = state.parameters.getInt(base.push(P_RESTART_UPPERBOUND), null, 1);
        if (state.parameters.exists(base.push(P_START), null)) {
            this.start = state.parameters.getInt(base.push(P_START), null, 0);
            if (this.start < 0) {
                state.output.fatal("Start value must be >= 0", base.push(P_START));
            }
        } else {
            this.start = 1;
        }
        if (this.upperbound < 1) {
            state.output.fatal("Parameter either not found or invalid (<1).", base.push(P_RESTART_UPPERBOUND));
        }
        if (!this.restartType.equals("random") && !this.restartType.equals("fixed")) {
            state.output.fatal("Parameter must be either 'fixed' or 'random'.", base.push(P_RESTART_TYPE));
        }
    }

    public void preEvaluationStatistics(EvolutionState state) {
        super.preEvaluationStatistics(state);
        if (state.generation == this.start) {
            this.resetClock(state);
        }
        if (state.generation >= this.start) {
            this.possiblyRestart(state);
        }
    }

    void possiblyRestart(EvolutionState state) {
        --this.countdown;
        if (this.countdown == 0) {
            state.output.message("Restarting the population prior to evaluating generation " + state.generation);
            for (int subp = 0; subp < state.population.subpops.size(); ++subp) {
                Subpopulation currentSubp = state.population.subpops.get(subp);
                boolean temp = currentSubp.loadInds;
                currentSubp.loadInds = false;
                currentSubp.populate(state, 0);
                currentSubp.loadInds = temp;
            }
            this.resetClock(state);
        }
    }

    void resetClock(EvolutionState state) {
        this.countdown = this.restartType.equals("fixed") ? this.upperbound : state.random[0].nextInt(this.upperbound) + 1;
    }
}

