/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.GPType;
import ec.gp.breed.GPBreedDefaults;
import ec.util.IntBag;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutateAllNodesPipeline
extends GPBreedingPipeline {
    private static final long serialVersionUID = 1L;
    public static final String P_MUTATEALLNODES = "mutate-all-nodes";
    public static final int NUM_SOURCES = 1;
    public static final String KEY_PARENTS = "parents";
    public GPNodeSelector nodeselect;
    int tree;

    @Override
    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATEALLNODES);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public Object clone() {
        MutateAllNodesPipeline c = (MutateAllNodesPipeline)super.clone();
        c.nodeselect = (GPNodeSelector)this.nodeselect.clone();
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter p = base.push("ns").push("0");
        this.nodeselect = (GPNodeSelector)state.parameters.getInstanceForParameter(p, def.push("ns").push("0"), GPNodeSelector.class);
        this.nodeselect.setup(state, p);
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private GPNode pickCompatibleNode(GPNode original, GPFunctionSet set, EvolutionState state, GPType returntype, int thread) {
        boolean failed;
        int numValidNodes = 0;
        int type = returntype.type;
        GPInitializer initializer = (GPInitializer)state.initializer;
        int len = original.constraints((GPInitializer)initializer).childtypes.length;
        if (initializer.numAtomicTypes + initializer.numSetTypes == 1) {
            numValidNodes = set.nodesByArity[type][len].length;
        } else {
            for (int x = 0; x < set.nodesByArity[type][len].length; ++x) {
                failed = false;
                for (int y = 0; y < set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                    if (set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, original.children[y].constraints((GPInitializer)initializer).returntype)) continue;
                    failed = true;
                    break;
                }
                if (failed) continue;
                ++numValidNodes;
            }
        }
        int nodenum = state.random[thread].nextInt(numValidNodes);
        int prosnode = 0;
        if (numValidNodes == set.nodesByArity[type][len].length) {
            return set.nodesByArity[type][len][nodenum];
        }
        for (int x = 0; x < set.nodesByArity[type][len].length; ++x) {
            failed = false;
            for (int y = 0; y < set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, original.children[y].constraints((GPInitializer)initializer).returntype)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            if (prosnode == nodenum) {
                return set.nodesByArity[type][len][x];
            }
            ++prosnode;
        }
        throw new InternalError();
    }

    private GPNode generateCompatibleTree(GPNode original, GPFunctionSet set, EvolutionState state, GPType returntype, int thread) {
        GPNode node = this.pickCompatibleNode(original, set, state, returntype, thread).lightClone();
        node.resetNode(state, thread);
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < node.children.length; ++x) {
            node.children[x] = this.generateCompatibleTree(original.children[x], set, state, original.constraints((GPInitializer)initializer).childtypes[x], thread);
            node.children[x].parent = node;
            node.children[x].argposition = (byte)x;
        }
        return node;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        IntBag[] parentparents = null;
        IntBag[] preserveParents = null;
        if (misc != null && misc.get(KEY_PARENTS) != null) {
            preserveParents = (IntBag[])misc.get(KEY_PARENTS);
            parentparents = new IntBag[2];
            misc.put(KEY_PARENTS, parentparents);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            GPIndividual i = (GPIndividual)inds.get(q);
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutateAllNodesPipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
            this.nodeselect.reset();
            GPNode p1 = null;
            GPNode p2 = null;
            p1 = this.nodeselect.pickNode(state, subpopulation, thread, i, i.trees[t]);
            GPType type = p1.parentType(initializer);
            p2 = this.generateCompatibleTree(p1, i.trees[t].constraints((GPInitializer)initializer).functionset, state, type, thread);
            p2.parent = p1.parent;
            p2.argposition = p1.argposition;
            if (p2.parent instanceof GPNode) {
                ((GPNode)p2.parent).children[p2.argposition] = p2;
            } else {
                ((GPTree)p2.parent).child = p2;
            }
            i.evaluated = false;
            inds.set(q, i);
            if (preserveParents == null) continue;
            parentparents[0].addAll(parentparents[1]);
            preserveParents[q] = new IntBag(parentparents[0]);
        }
        return n;
    }
}

