/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPTree;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RehangPipeline
extends GPBreedingPipeline {
    public static final String P_REHANG = "rehang";
    public static final String P_NUM_TRIES = "tries";
    public static final int NUM_SOURCES = 1;
    int numTries;
    int tree;
    private GPNode rehangableNode;

    @Override
    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_REHANG);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("RehangPipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        if (((GPInitializer)state.initializer).numAtomicTypes + ((GPInitializer)state.initializer).numSetTypes > 1) {
            state.output.fatal("RehangPipeline only works when there is only one type (the system is typeless", base, def);
        }
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private int numRehangableNodes(GPNode root, int soFar) {
        for (int x = 0; x < root.children.length; ++x) {
            soFar = this._numRehangableNodes(root.children[x], soFar);
        }
        return soFar;
    }

    private int _numRehangableNodes(GPNode root, int soFar) {
        if (root.children.length > 0) {
            ++soFar;
        }
        for (int x = 0; x < root.children.length; ++x) {
            soFar = this._numRehangableNodes(root.children[x], soFar);
        }
        return soFar;
    }

    private int pickRehangableNode(GPNode root, int num) {
        for (int x = 0; x < root.children.length && (num = this._pickRehangableNode(root.children[x], num)) != -1; ++x) {
        }
        return num;
    }

    private int _pickRehangableNode(GPNode root, int num) {
        if (root.children.length > 0 && --num == -1) {
            this.rehangableNode = root;
            return num;
        }
        for (int x = 0; x < root.children.length && (num = this._pickRehangableNode(root.children[x], num)) != -1; ++x) {
        }
        return num;
    }

    private void rehang(EvolutionState state, int thread, GPNode pivot, GPNode root) {
        if (pivot == root) {
            throw new InternalError("Oops, pivot==root in ec.gp.breed.Rehang.rehang(...)");
        }
        byte spot = (byte)state.random[thread].nextInt(pivot.children.length);
        GPNode cut = pivot.children[spot];
        GPNode newPivot = (GPNode)pivot.parent;
        ((GPTree)root.parent).child = pivot;
        pivot.parent = root.parent;
        byte newSpot = pivot.argposition;
        pivot.argposition = 0;
        GPNode oldPivot = pivot;
        pivot = newPivot;
        while (pivot != root) {
            newPivot = (GPNode)pivot.parent;
            pivot.parent = oldPivot;
            oldPivot.children[spot] = pivot;
            byte tmpSpot = pivot.argposition;
            pivot.argposition = spot;
            spot = newSpot;
            newSpot = tmpSpot;
            oldPivot = pivot;
            pivot = newPivot;
        }
        pivot.parent = oldPivot;
        oldPivot.children[spot] = pivot;
        pivot.argposition = spot;
        cut.parent = pivot;
        cut.argposition = newSpot;
        pivot.children[newSpot] = cut;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        for (int q = start; q < n + start; ++q) {
            GPIndividual i = (GPIndividual)inds.get(q);
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("RehangPipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            for (int x = 0; x < this.numTries; ++x) {
                int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
                if (i.trees[t].child.children.length == 0) continue;
                boolean rehangable = false;
                for (int y = 0; y < i.trees[t].child.children.length; ++y) {
                    if (i.trees[t].child.children[y].children.length <= 0) continue;
                    rehangable = true;
                    break;
                }
                if (!rehangable) continue;
                int numrehang = this.numRehangableNodes(i.trees[t].child, 0);
                this.pickRehangableNode(i.trees[t].child, state.random[thread].nextInt(numrehang));
                this.rehang(state, thread, this.rehangableNode, i.trees[t].child);
                i.evaluated = false;
            }
            inds.set(q, i);
        }
        return n;
    }
}

