/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.koza.GPKozaDefaults;
import ec.util.IntBag;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossoverPipeline
extends GPBreedingPipeline {
    private static final long serialVersionUID = 1L;
    public static final String P_NUM_TRIES = "tries";
    public static final String P_MAXDEPTH = "maxdepth";
    public static final String P_MAXSIZE = "maxsize";
    public static final String P_CROSSOVER = "xover";
    public static final String P_TOSS = "toss";
    public static final int INDS_PRODUCED = 2;
    public static final int NUM_SOURCES = 2;
    public static final int NO_SIZE_LIMIT = -1;
    public static final String KEY_PARENTS = "parents";
    public GPNodeSelector nodeselect1;
    public GPNodeSelector nodeselect2;
    public int tree1;
    public int tree2;
    public int numTries;
    public int maxDepth;
    public int maxSize;
    public boolean tossSecondParent;
    public ArrayList<Individual> parents = new ArrayList();

    @Override
    public Parameter defaultBase() {
        return GPKozaDefaults.base().push(P_CROSSOVER);
    }

    @Override
    public int numSources() {
        return 2;
    }

    @Override
    public Object clone() {
        CrossoverPipeline c = (CrossoverPipeline)super.clone();
        c.nodeselect1 = (GPNodeSelector)this.nodeselect1.clone();
        c.nodeselect2 = (GPNodeSelector)this.nodeselect2.clone();
        c.parents = new ArrayList<Individual>(this.parents);
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter p = base.push("ns").push("0");
        Parameter d = def.push("ns").push("0");
        this.nodeselect1 = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
        this.nodeselect1.setup(state, p);
        p = base.push("ns").push("1");
        d = def.push("ns").push("1");
        if (state.parameters.exists(p, d) && state.parameters.getString(p, d).equals("same")) {
            this.nodeselect2 = (GPNodeSelector)this.nodeselect1.clone();
        } else {
            this.nodeselect2 = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
            this.nodeselect2.setup(state, p);
        }
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("GPCrossover Pipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth == 0) {
            state.output.fatal("GPCrossover Pipeline has an invalid maximum depth (it must be >= 1).", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
        this.maxSize = -1;
        if (state.parameters.exists(base.push(P_MAXSIZE), def.push(P_MAXSIZE))) {
            this.maxSize = state.parameters.getInt(base.push(P_MAXSIZE), def.push(P_MAXSIZE), 1);
            if (this.maxSize < 1) {
                state.output.fatal("Maximum tree size, if defined, must be >= 1");
            }
        }
        this.tree1 = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree1 = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree1 == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
        this.tree2 = -1;
        if (state.parameters.exists(base.push("tree").push("1"), def.push("tree").push("1"))) {
            this.tree2 = state.parameters.getInt(base.push("tree").push("1"), def.push("tree").push("1"), 0);
            if (this.tree2 == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
    }

    @Override
    public int typicalIndsProduced() {
        return this.tossSecondParent ? this.minChildProduction() : this.minChildProduction() * 2;
    }

    public boolean verifyPoints(GPInitializer initializer, GPNode inner1, GPNode inner2) {
        GPNode root2;
        int root2size;
        int inner2size;
        int inner1size;
        if (!inner1.swapCompatibleWith(initializer, inner2)) {
            return false;
        }
        if (inner1.depth() + inner2.atDepth() > this.maxDepth) {
            return false;
        }
        return this.maxSize == -1 || (inner1size = inner1.numNodes(0)) <= (inner2size = inner2.numNodes(0)) || (root2size = (root2 = ((GPTree)inner2.rootParent()).child).numNodes(0)) - inner2size + inner1size <= this.maxSize;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            this.sources[0].produce(n, n, subpopulation, inds, state, thread, misc);
            return n;
        }
        IntBag[] parentparents = null;
        IntBag[] preserveParents = null;
        if (misc != null && misc.get(KEY_PARENTS) != null) {
            preserveParents = (IntBag[])misc.get(KEY_PARENTS);
            parentparents = new IntBag[2];
            misc.put(KEY_PARENTS, parentparents);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        int q = start;
        while (q < n + start) {
            int x;
            this.parents.clear();
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, subpopulation, this.parents, state, thread, misc);
            } else {
                this.sources[0].produce(1, 1, subpopulation, this.parents, state, thread, misc);
                this.sources[1].produce(1, 1, subpopulation, this.parents, state, thread, misc);
            }
            if (this.tree1 != -1 && (this.tree1 < 0 || this.tree1 >= ((GPIndividual)this.parents.get((int)0)).trees.length)) {
                state.output.fatal("GP Crossover Pipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            if (this.tree2 != -1 && (this.tree2 < 0 || this.tree2 >= ((GPIndividual)this.parents.get((int)1)).trees.length)) {
                state.output.fatal("GP Crossover Pipeline attempted to fix tree.1 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            int t1 = 0;
            int t2 = 0;
            if (this.tree1 == -1 || this.tree2 == -1) {
                do {
                    t1 = this.tree1 == -1 ? (((GPIndividual)this.parents.get((int)0)).trees.length > 1 ? state.random[thread].nextInt(((GPIndividual)this.parents.get((int)0)).trees.length) : 0) : this.tree1;
                    if (this.tree2 == -1) {
                        if (((GPIndividual)this.parents.get((int)1)).trees.length > 1) {
                            t2 = state.random[thread].nextInt(((GPIndividual)this.parents.get((int)1)).trees.length);
                            continue;
                        }
                        t2 = 0;
                        continue;
                    }
                    t2 = this.tree2;
                } while (((GPIndividual)this.parents.get((int)0)).trees[t1].constraints(initializer) != ((GPIndividual)this.parents.get((int)1)).trees[t2].constraints(initializer));
            } else {
                t1 = this.tree1;
                t2 = this.tree2;
                if (((GPIndividual)this.parents.get((int)0)).trees[t1].constraints(initializer) != ((GPIndividual)this.parents.get((int)1)).trees[t2].constraints(initializer)) {
                    state.output.fatal("GP Crossover Pipeline's two tree choices are both specified by the user -- but their GPTreeConstraints are not the same");
                }
            }
            boolean res1 = false;
            boolean res2 = false;
            this.nodeselect1.reset();
            this.nodeselect2.reset();
            GPNode p1 = null;
            GPNode p2 = null;
            for (int x2 = 0; x2 < this.numTries; ++x2) {
                p1 = this.nodeselect1.pickNode(state, subpopulation, thread, (GPIndividual)this.parents.get(0), ((GPIndividual)this.parents.get((int)0)).trees[t1]);
                p2 = this.nodeselect2.pickNode(state, subpopulation, thread, (GPIndividual)this.parents.get(1), ((GPIndividual)this.parents.get((int)1)).trees[t2]);
                res1 = this.verifyPoints(initializer, p2, p1);
                res2 = n - (q - start) < 2 || this.tossSecondParent ? true : this.verifyPoints(initializer, p1, p2);
                if (res1 && res2) break;
            }
            GPIndividual j1 = ((GPIndividual)this.parents.get(0)).lightClone();
            GPIndividual j2 = null;
            if (n - (q - start) >= 2 && !this.tossSecondParent) {
                j2 = ((GPIndividual)this.parents.get(1)).lightClone();
            }
            j1.trees = new GPTree[((GPIndividual)this.parents.get((int)0)).trees.length];
            if (n - (q - start) >= 2 && !this.tossSecondParent) {
                j2.trees = new GPTree[((GPIndividual)this.parents.get((int)1)).trees.length];
            }
            for (x = 0; x < j1.trees.length; ++x) {
                if (x == t1 && res1) {
                    j1.trees[x] = ((GPIndividual)this.parents.get((int)0)).trees[x].lightClone();
                    j1.trees[x].owner = j1;
                    j1.trees[x].child = ((GPIndividual)this.parents.get((int)0)).trees[x].child.cloneReplacing(p2, p1);
                    j1.trees[x].child.parent = j1.trees[x];
                    j1.trees[x].child.argposition = 0;
                    j1.evaluated = false;
                    continue;
                }
                j1.trees[x] = ((GPIndividual)this.parents.get((int)0)).trees[x].lightClone();
                j1.trees[x].owner = j1;
                j1.trees[x].child = (GPNode)((GPIndividual)this.parents.get((int)0)).trees[x].child.clone();
                j1.trees[x].child.parent = j1.trees[x];
                j1.trees[x].child.argposition = 0;
            }
            if (n - (q - start) >= 2 && !this.tossSecondParent) {
                for (x = 0; x < j2.trees.length; ++x) {
                    if (x == t2 && res2) {
                        j2.trees[x] = ((GPIndividual)this.parents.get((int)1)).trees[x].lightClone();
                        j2.trees[x].owner = j2;
                        j2.trees[x].child = ((GPIndividual)this.parents.get((int)1)).trees[x].child.cloneReplacing(p1, p2);
                        j2.trees[x].child.parent = j2.trees[x];
                        j2.trees[x].child.argposition = 0;
                        j2.evaluated = false;
                        continue;
                    }
                    j2.trees[x] = ((GPIndividual)this.parents.get((int)1)).trees[x].lightClone();
                    j2.trees[x].owner = j2;
                    j2.trees[x].child = (GPNode)((GPIndividual)this.parents.get((int)1)).trees[x].child.clone();
                    j2.trees[x].child.parent = j2.trees[x];
                    j2.trees[x].child.argposition = 0;
                }
            }
            inds.add(j1);
            if (preserveParents != null) {
                parentparents[0].addAll(parentparents[1]);
                preserveParents[q] = parentparents[0];
            }
            if (++q >= n + start || this.tossSecondParent) continue;
            inds.add(j2);
            if (preserveParents != null) {
                parentparents[0].addAll(parentparents[1]);
                preserveParents[q] = parentparents[0];
            }
            ++q;
        }
        return n;
    }
}

