/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.push;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.gp.push.PushDefaults;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import java.util.ArrayList;

public class PushBuilder
extends GPNodeBuilder {
    public static final String P_PUSHBUILDER = "builder";
    GPNode[] dummy = new GPNode[0];

    public Parameter defaultBase() {
        return PushDefaults.base().push(P_PUSHBUILDER);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!this.canPick()) {
            state.output.fatal("PushBuilder needs a distribution of tree sizes to pick from.  You can do this by either setting a distribution (with num-sizes) or with min-size and max-size.", base, def);
        }
    }

    public GPNode[] shuffle(GPNode[] objs, EvolutionState state, int thread) {
        int numObjs = objs.length;
        MersenneTwisterFast random = state.random[thread];
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            GPNode obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
        return objs;
    }

    public GPNode newRootedTree(EvolutionState state, GPType type, int thread, GPNodeParent parent, GPFunctionSet set, int argposition, int requestedSize) {
        int t = type.type;
        GPNode[] terminals = set.terminals[t];
        GPNode[] nonterminals = set.nonterminals[t];
        if (requestedSize == -1) {
            requestedSize = this.pickSize(state, thread);
        }
        GPNode n = null;
        if (requestedSize == 1) {
            n = terminals[state.random[thread].nextInt(terminals.length)].lightClone();
        } else {
            n = nonterminals[state.random[thread].nextInt(nonterminals.length)].lightClone();
            int pos = 0;
            ArrayList<GPNode> list = new ArrayList<GPNode>();
            while (requestedSize >= 1) {
                int amount = state.random[thread].nextInt(requestedSize) + 1;
                requestedSize -= amount;
                GPNode f = this.newRootedTree(state, type, thread, parent, set, pos, amount);
                list.add(f);
            }
            n.children = list.toArray(this.dummy);
            n.children = this.shuffle(n.children, state, thread);
            for (int i = 0; i < n.children.length; ++i) {
                n.children[i].argposition = (byte)i;
            }
        }
        n.resetNode(state, thread);
        n.argposition = (byte)argposition;
        n.parent = parent;
        return n;
    }
}

