/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.push;

import ec.EvolutionState;
import ec.Problem;
import ec.gp.ADFStack;
import ec.gp.ERC;
import ec.gp.GPData;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.push.PushDefaults;
import ec.gp.push.PushInstruction;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;

public class Terminal
extends ERC {
    public static final String P_INSTRUCTION = "in";
    public static final String P_NUM_INSTRUCTIONS = "size";
    public static final String P_FUNC = "func";
    public static final String P_FLOAT = "erc.float";
    public static final String P_INTEGER = "erc.int";
    public static final String P_MIN = "min";
    public static final String P_MAX = "max";
    public static final int FLOAT_ERC = 0;
    public static final int INTEGER_ERC = 1;
    public static final String[] ERC_NAMES = new String[]{"float.erc", "integer.erc"};
    public static double minFloatERC = -10.0;
    public static double maxFloatERC = 10.0;
    public static int minIntegerERC = -10;
    public static int maxIntegerERC = 10;
    public String[] instructions;
    public PushInstruction[] customInstructions;
    public int[] indices;
    String value;

    public String name() {
        return "IN";
    }

    public int expectedChildren() {
        return 0;
    }

    public String toStringForHumans() {
        return this.value;
    }

    public Parameter defaultBase() {
        return PushDefaults.base().push(P_INSTRUCTION);
    }

    public void setup(EvolutionState state, Parameter base) {
        double max;
        double min;
        Parameter d;
        int i;
        super.setup(state, base);
        Parameter def = this.defaultBase();
        int len = state.parameters.getInt(base.push(P_INSTRUCTION).push(P_NUM_INSTRUCTIONS), def.push(P_NUM_INSTRUCTIONS), 1);
        if (len < 1) {
            state.output.fatal("Number of instructions must be >= 1", base.push(P_INSTRUCTION).push(P_NUM_INSTRUCTIONS), def.push(P_NUM_INSTRUCTIONS));
        }
        this.instructions = new String[len];
        PushInstruction[] insts = new PushInstruction[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Parameter dd;
            Parameter bb;
            this.instructions[i2] = state.parameters.getString(base.push(P_INSTRUCTION).push("" + i2), def.push("" + i2));
            if (this.instructions[i2] == null) {
                state.output.fatal("Terminal number " + i2 + " is missing.", base.push(P_INSTRUCTION).push("" + i2), def.push("" + i2));
            }
            if (!state.parameters.exists(bb = base.push(P_INSTRUCTION).push("" + i2).push(P_FUNC), dd = def.push("" + i2).push(P_FUNC))) continue;
            String s = state.parameters.getString(bb, dd);
            state.output.message("Adding Instruction " + this.instructions[i2] + " --> " + s);
            PushInstruction inst = (PushInstruction)state.parameters.getInstanceForParameter(bb, dd, PushInstruction.class);
            if (inst == null) {
                state.output.fatal("Terminal number " + i2 + ", named " + this.instructions[i2] + ", has an invalid function class: " + s);
            }
            insts[i2] = inst;
        }
        int count = 0;
        for (i = 0; i < len; ++i) {
            if (insts[i] == null) continue;
            ++count;
        }
        this.customInstructions = new PushInstruction[count];
        this.indices = new int[count];
        count = 0;
        for (i = 0; i < len; ++i) {
            if (insts[i] == null) continue;
            this.customInstructions[count] = insts[i];
            this.indices[count] = i;
            ++count;
        }
        double NaN = Double.NaN;
        Parameter b = base.push(P_FLOAT).push(P_MIN);
        if (!state.parameters.exists(b, d = PushDefaults.base().push(P_FLOAT).push(P_MIN))) {
            state.output.warning("No " + ERC_NAMES[0] + " min value provided, using " + minFloatERC, b, d);
        } else {
            min = state.parameters.getDoubleWithDefault(b, d, Double.NaN);
            if (min != min) {
                state.output.fatal("Malformed " + ERC_NAMES[0] + " min value", b, d);
            } else {
                minFloatERC = min;
            }
        }
        b = base.push(P_FLOAT).push(P_MAX);
        d = PushDefaults.base().push(P_FLOAT).push(P_MAX);
        if (!state.parameters.exists(b, d)) {
            state.output.warning("No " + ERC_NAMES[0] + " max value provided, using " + maxFloatERC, b, d);
        } else {
            max = state.parameters.getDoubleWithDefault(b, d, Double.NaN);
            if (max != max) {
                state.output.fatal("Malformed " + ERC_NAMES[0] + " max value", b, d);
            } else {
                maxFloatERC = max;
            }
        }
        if (minFloatERC > maxFloatERC) {
            state.output.fatal("" + ERC_NAMES[0] + " min value is greater than max value.\nMin: " + minFloatERC + "\nMax: " + maxFloatERC);
        }
        if (!state.parameters.exists(b = base.push(P_INTEGER).push(P_MIN), d = PushDefaults.base().push(P_INTEGER).push(P_MIN))) {
            state.output.warning("No " + ERC_NAMES[1] + " min value provided, using " + minIntegerERC, b, d);
        } else {
            min = state.parameters.getDoubleWithDefault(b, d, Double.NaN);
            if (min != min || min != (double)((int)min)) {
                state.output.fatal("Malformed " + ERC_NAMES[1] + " min value", b, d);
            }
            minIntegerERC = (int)min;
        }
        b = base.push(P_INTEGER).push(P_MAX);
        d = PushDefaults.base().push(P_INTEGER).push(P_MAX);
        if (!state.parameters.exists(b, d)) {
            state.output.warning("No " + ERC_NAMES[1] + " max value provided, using " + maxIntegerERC, b, d);
        } else {
            max = state.parameters.getDoubleWithDefault(b, d, Double.NaN);
            if (max != max || max != (double)((int)max)) {
                state.output.fatal("Malformed " + ERC_NAMES[1] + " max value", b, d);
            } else {
                maxIntegerERC = (int)max;
            }
        }
        if (minIntegerERC > maxIntegerERC) {
            state.output.fatal("" + ERC_NAMES[1] + " min value is greater than max value.\nMin: " + minIntegerERC + "\nMax: " + maxIntegerERC);
        }
    }

    public boolean nodeEquals(GPNode other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Terminal)) {
            return false;
        }
        Terminal o = (Terminal)other;
        return o.value == this.value;
    }

    public String encode() {
        return Code.encode(this.value);
    }

    public boolean decode(DecodeReturn dret) {
        Code.decode(dret);
        if (dret.type == 8) {
            this.value = dret.s;
            for (int i = 0; i < this.instructions.length; ++i) {
                if (!this.instructions[i].equals(this.value)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetNode(EvolutionState state, int thread) {
        int i = state.random[thread].nextInt(this.instructions.length);
        if (this.instructions[i].endsWith("erc")) {
            for (int j = 0; j < ERC_NAMES.length; ++j) {
                if (!this.instructions[i].equals(ERC_NAMES[j])) continue;
                switch (j) {
                    case 0: {
                        this.value = "" + (state.random[thread].nextDouble(true, true) * (maxFloatERC - minFloatERC) + minFloatERC);
                        break;
                    }
                    case 1: {
                        this.value = "" + (state.random[thread].nextInt(maxIntegerERC - minIntegerERC + 1) + minIntegerERC);
                        break;
                    }
                    default: {
                        state.output.fatal("The following PUSH ERC is unknown: " + this.instructions[i]);
                        break;
                    }
                }
                break;
            }
        } else {
            this.value = this.instructions[i];
        }
    }

    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
    }
}

