/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective;

import ec.EvolutionState;
import ec.Individual;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleStatistics;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HypervolumeStatistics
extends SimpleStatistics {
    public static final String P_REFERENCE_POINT = "reference-point";
    private double[] referencePoint;

    public double[] getReferencePoint() {
        return Arrays.copyOf(this.referencePoint, this.referencePoint.length);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (state.parameters.exists(base.push("do-message"), null)) {
            state.output.warning("Messages are not printed out by " + this.getClass().getSimpleName(), base.push("do-message"));
        }
        if (state.parameters.exists(base.push("do-description"), null)) {
            state.output.warning("Descriptions are not printed out by " + this.getClass().getSimpleName(), base.push("do-description"));
        }
        if (state.parameters.exists(base.push("do-per-generation-description"), null)) {
            state.output.warning("Descriptions are not printed out by " + this.getClass().getSimpleName(), base.push("do-per-generation-description"));
        }
        this.referencePoint = state.parameters.getDoubles(base.push(P_REFERENCE_POINT), null, Double.NEGATIVE_INFINITY);
        if (this.referencePoint == null) {
            state.output.fatal("Missing required parameter.", base.push(P_REFERENCE_POINT));
        }
        if (this.doGeneration && this.referencePoint.length > 3) {
            state.output.warnOnce(String.format("You calculating hypervolume on %d objectives at every generation.  Note that hypervolume calculation can very costly for more than a few objectives.", this.referencePoint.length), base.push(P_REFERENCE_POINT));
        }
    }

    @Override
    public void postEvaluationStatistics(EvolutionState state) {
        super.bypassPostEvaluationStatistics(state);
        state.output.print("" + state.generation, this.statisticslog);
        for (int s = 0; s < state.population.subpops.size(); ++s) {
            if (!this.doGeneration) continue;
            ArrayList<Individual> paretoFront = MultiObjectiveFitness.partitionIntoParetoFront(state.population.subpops.get((int)s).individuals, null, null);
            try {
                double hv = this.hypervolume(paretoFront);
                state.output.print(", " + hv, this.statisticslog);
                continue;
            }
            catch (Exception e) {
                state.output.fatal(e.getMessage());
            }
        }
        state.output.print("\n", this.statisticslog);
    }

    public double hypervolume(ArrayList<Individual> paretoFront) {
        assert (paretoFront != null);
        double exclusiveSum = 0.0;
        for (int i = 0; i < paretoFront.size(); ++i) {
            exclusiveSum += this.exclusiveHypervolume(paretoFront, i);
        }
        return exclusiveSum;
    }

    private double exclusiveHypervolume(ArrayList<Individual> paretoFront, int indID) {
        double result;
        assert (paretoFront != null);
        assert (indID >= 0);
        assert (indID < paretoFront.size());
        Individual ind = paretoFront.get(indID);
        if (!(ind.fitness instanceof MultiObjectiveFitness)) {
            throw new IllegalStateException(String.format("%s: found an individual with a %s.  Hypervolume can only be computed for %s.", this.getClass().getSimpleName(), ind.fitness.getClass().getSimpleName(), MultiObjectiveFitness.class.getSimpleName()));
        }
        MultiObjectiveFitness indFitness = (MultiObjectiveFitness)ind.fitness;
        MultiObjectiveFitness refFitness = (MultiObjectiveFitness)ind.fitness.clone();
        refFitness.objectives = this.referencePoint;
        if (!indFitness.paretoDominates(refFitness)) {
            throw new IllegalStateException(String.format("%s: found an individual (fitness: %s) that does not dominate the reference point (%s).  Cowardly refusing to compute a negative hypervolume contribution for this individual.  You probably need to choosing a different reference pointor check the maximization/minimization setting for the objectives.", this.getClass().getSimpleName(), Arrays.toString(indFitness.objectives), Arrays.toString(this.referencePoint)));
        }
        ArrayList<Individual> limitSet = this.limitSet(paretoFront, indID);
        double ihv = this.inclusiveHypervolume(ind);
        assert (ihv >= 0.0);
        double d = result = limitSet.isEmpty() ? ihv : ihv - this.hypervolume(MultiObjectiveFitness.partitionIntoParetoFront(limitSet, null, null));
        assert (result >= 0.0);
        return result;
    }

    public double inclusiveHypervolume(Individual ind) {
        assert (ind != null);
        assert (ind.fitness instanceof MultiObjectiveFitness);
        MultiObjectiveFitness fitness = (MultiObjectiveFitness)ind.fitness;
        if (fitness.objectives.length != this.referencePoint.length) {
            throw new IllegalStateException(String.format("%s: %s has %d dimensions, but we encountered an individual with an %d-dimensional fitness.", this.getClass().getSimpleName(), P_REFERENCE_POINT, this.referencePoint.length, fitness.objectives.length));
        }
        double product = 1.0;
        for (int i = 0; i < fitness.objectives.length; ++i) {
            product *= Math.abs(fitness.objectives[i] - this.referencePoint[i]);
        }
        return product;
    }

    private ArrayList<Individual> limitSet(ArrayList<Individual> paretoFront, int indID) {
        assert (paretoFront != null);
        assert (indID >= 0);
        assert (indID < paretoFront.size());
        Individual contributingPoint = paretoFront.get(indID);
        assert (contributingPoint != null);
        assert (contributingPoint.fitness instanceof MultiObjectiveFitness);
        MultiObjectiveFitness contributingFitness = (MultiObjectiveFitness)contributingPoint.fitness;
        if (contributingFitness.objectives.length != this.referencePoint.length) {
            throw new IllegalStateException(String.format("%s: %s has %d dimensions, but we encountered an individual with an %d-dimensional fitness.", this.getClass().getSimpleName(), P_REFERENCE_POINT, this.referencePoint.length, contributingFitness.objectives.length));
        }
        ArrayList<Individual> set = new ArrayList<Individual>(paretoFront.size());
        for (int i = indID + 1; i < paretoFront.size(); ++i) {
            MultiObjectiveFitness refFitness = (MultiObjectiveFitness)paretoFront.get((int)i).fitness;
            double[] newPoint = new double[this.referencePoint.length];
            for (int j = 0; j < newPoint.length; ++j) {
                newPoint[j] = contributingFitness.isMaximizing(j) ? Math.min(contributingFitness.getObjective(j), refFitness.getObjective(j)) : Math.max(contributingFitness.getObjective(j), refFitness.getObjective(j));
            }
            Individual newPointInd = (Individual)contributingPoint.clone();
            newPointInd.fitness = (MultiObjectiveFitness)contributingFitness.clone();
            ((MultiObjectiveFitness)newPointInd.fitness).objectives = newPoint;
            set.add(newPointInd);
        }
        return set;
    }

    @Override
    public void finalStatistics(EvolutionState state, int result) {
        this.bypassFinalStatistics(state, result);
        if (!this.doFinal) {
            return;
        }
        state.output.print("" + state.generation, this.statisticslog);
        for (int s = 0; s < state.population.subpops.size(); ++s) {
            ArrayList<Individual> paretoFront = MultiObjectiveFitness.partitionIntoParetoFront(state.population.subpops.get((int)s).individuals, null, null);
            double hv = this.hypervolume(paretoFront);
            state.output.println(", " + hv, this.statisticslog);
        }
        state.output.print("\n", this.statisticslog);
    }
}

