/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga3;

import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.nsga2.NSGA2Breeder;
import ec.multiobjective.nsga3.NSGA3MultiObjectiveFitness;
import ec.multiobjective.nsga3.SelectorTools;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSGA3Breeder
extends NSGA2Breeder {
    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
    }

    public ArrayList<Individual> buildArchive(EvolutionState state, int subpop) {
        ArrayList<ArrayList<Individual>> ranks = this.assignFrontRanks(state.population.subpops.get(subpop));
        ArrayList<Individual> newSubpopulation = new ArrayList<Individual>();
        int size = ranks.size();
        int originalPopSize = state.population.subpops.get((int)subpop).individuals.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<Individual> rank = ranks.get(i);
            if (rank.size() + newSubpopulation.size() >= originalPopSize) {
                int numObjectives = ((NSGA3MultiObjectiveFitness)rank.get((int)0).fitness).getObjectives().length;
                List<Individual> frontL = new SelectorTools(ranks.subList(0, i + 1), numObjectives).selectFrontLIndividuals(originalPopSize - newSubpopulation.size());
                newSubpopulation.addAll(frontL);
                break;
            }
            newSubpopulation.addAll(rank);
        }
        ArrayList<Individual> archive = new ArrayList<Individual>(newSubpopulation);
        if (this.reevaluateElites[subpop]) {
            for (int i = 0; i < archive.size(); ++i) {
                archive.get((int)i).evaluated = false;
            }
        }
        return archive;
    }

    @Override
    public ArrayList<ArrayList<Individual>> assignFrontRanks(Subpopulation subpop) {
        ArrayList<Individual> inds = subpop.individuals;
        ArrayList<ArrayList<Individual>> frontsByRank = MultiObjectiveFitness.partitionIntoRanks(inds);
        int numRanks = frontsByRank.size();
        for (int rank = 0; rank < numRanks; ++rank) {
            ArrayList<Individual> front = frontsByRank.get(rank);
            int numInds = front.size();
            for (int ind = 0; ind < numInds; ++ind) {
                ((NSGA3MultiObjectiveFitness)front.get((int)ind).fitness).rank = rank;
            }
        }
        return frontsByRank;
    }
}

