/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga3;

import ec.Individual;
import ec.multiobjective.nsga3.NSGA3MultiObjectiveFitness;
import ec.multiobjective.nsga3.ReferencePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorTools {
    List<ArrayList<Individual>> fronts;
    List<ReferencePoint> referencePoints;
    int numberOfObjectives;
    static final int NUMBER_OF_DIVISIONS = 6;

    public SelectorTools(List<ArrayList<Individual>> fronts, int numberOfObjectives) {
        this.fronts = fronts;
        this.referencePoints = this.generateReferencePoints(numberOfObjectives, 6);
        this.numberOfObjectives = numberOfObjectives;
    }

    private List<ReferencePoint> generateReferencePoints(int numberOfObjectives, int NUMBER_OF_DIVISIONS) {
        ArrayList<Double> location = new ArrayList<Double>(numberOfObjectives);
        for (int i = 0; i < numberOfObjectives; ++i) {
            location.add(0.0);
        }
        ArrayList<ReferencePoint> referencePoints = new ArrayList<ReferencePoint>();
        this.generateRecursive(referencePoints, location, numberOfObjectives, NUMBER_OF_DIVISIONS, NUMBER_OF_DIVISIONS, 0);
        return referencePoints;
    }

    private void generateRecursive(List<ReferencePoint> referencePoints, List<Double> location, int numberOfObjectives, int left, int total, int element) {
        if (element == numberOfObjectives - 1) {
            location.set(element, (double)left / (double)total);
            referencePoints.add(new ReferencePoint(location));
        } else {
            for (int i = 0; i <= left; ++i) {
                location.set(element, (double)i / (double)total);
                this.generateRecursive(referencePoints, location, numberOfObjectives, left - i, total, element + 1);
            }
        }
    }

    public List<Double> translateObjectives() {
        ArrayList<Double> ideal_point = new ArrayList<Double>(this.numberOfObjectives);
        for (int f = 0; f < this.numberOfObjectives; ++f) {
            double minf = Double.MAX_VALUE;
            for (int i = 0; i < this.fronts.get(0).size(); ++i) {
                Individual temp = this.fronts.get(0).get(i);
                minf = Math.min(minf, ((NSGA3MultiObjectiveFitness)temp.fitness).getObjective(f));
            }
            ideal_point.add(minf);
            for (List list : this.fronts) {
                for (Individual ind : list) {
                    if (f == 0) {
                        ((NSGA3MultiObjectiveFitness)ind.fitness).initNorm(this.numberOfObjectives);
                    }
                    ((NSGA3MultiObjectiveFitness)ind.fitness).setNormValue(f, ((NSGA3MultiObjectiveFitness)ind.fitness).getObjective(f) - minf);
                }
            }
        }
        return ideal_point;
    }

    private double ASF(Individual ind, int index) {
        double max_ratio = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            double weight = index == i ? 1.0 : 1.0E-6;
            max_ratio = Math.max(max_ratio, ((NSGA3MultiObjectiveFitness)ind.fitness).getObjective(i) / weight);
        }
        return max_ratio;
    }

    private List<Individual> findExtremePoints() {
        ArrayList<Individual> extremePoints = new ArrayList<Individual>();
        Individual min_indv = null;
        for (int f = 0; f < this.numberOfObjectives; ++f) {
            double min_ASF = Double.MAX_VALUE;
            for (Individual ind : this.fronts.get(0)) {
                double asf = this.ASF(ind, f);
                if (!(asf < min_ASF)) continue;
                min_ASF = asf;
                min_indv = ind;
            }
            extremePoints.add(min_indv);
        }
        return extremePoints;
    }

    public List<Double> guassianElimination(List<List<Double>> A, List<Double> b) {
        int i;
        ArrayList<Double> x = new ArrayList<Double>();
        int N = A.size();
        for (i = 0; i < N; ++i) {
            A.get(i).add(b.get(i));
        }
        for (int base = 0; base < N - 1; ++base) {
            for (int target = base + 1; target < N; ++target) {
                double ratio = A.get(target).get(base) / A.get(base).get(base);
                for (int term = 0; term < A.get(base).size(); ++term) {
                    A.get(target).set(term, A.get(target).get(term) - A.get(base).get(term) * ratio);
                }
            }
        }
        for (i = 0; i < N; ++i) {
            x.add(0.0);
        }
        for (i = N - 1; i >= 0; --i) {
            for (int known = i + 1; known < N; ++known) {
                A.get(i).set(N, A.get(i).get(N) - A.get(i).get(known) * (Double)x.get(known));
            }
            x.set(i, A.get(i).get(N) / A.get(i).get(i));
        }
        return x;
    }

    public List<Double> constructHyperplane(List<Individual> extreme_points) {
        boolean duplicate = false;
        for (int i = 0; !duplicate && i < extreme_points.size(); ++i) {
            for (int j = i + 1; !duplicate && j < extreme_points.size(); ++j) {
                duplicate = extreme_points.get(i).equals(extreme_points.get(j));
            }
        }
        ArrayList<Double> intercepts = new ArrayList<Double>();
        if (duplicate) {
            for (int f = 0; f < this.numberOfObjectives; ++f) {
                intercepts.add(((NSGA3MultiObjectiveFitness)extreme_points.get((int)f).fitness).getObjective(f));
            }
        } else {
            ArrayList<Double> b = new ArrayList<Double>();
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                b.add(1.0);
            }
            ArrayList<List<Double>> A = new ArrayList<List<Double>>();
            for (Individual ind : extreme_points) {
                ArrayList<Double> aux = new ArrayList<Double>();
                for (int i = 0; i < this.numberOfObjectives; ++i) {
                    aux.add(((NSGA3MultiObjectiveFitness)ind.fitness).getObjective(i));
                }
                A.add(aux);
            }
            List<Double> x = this.guassianElimination(A, b);
            for (int f = 0; f < this.numberOfObjectives; ++f) {
                intercepts.add(1.0 / x.get(f));
            }
        }
        return intercepts;
    }

    public void normalizeObjectives() {
        List<Double> ideal_point = this.translateObjectives();
        List<Individual> extreme_points = this.findExtremePoints();
        List<Double> intercepts = this.constructHyperplane(extreme_points);
        for (int t = 0; t < this.fronts.size(); ++t) {
            for (Individual ind : this.fronts.get(t)) {
                ArrayList<Double> conv_obj = ((NSGA3MultiObjectiveFitness)ind.fitness).getNormFit();
                for (int f = 0; f < this.numberOfObjectives; ++f) {
                    if (Math.abs(intercepts.get(f) - ideal_point.get(f)) > 1.0E-9) {
                        conv_obj.set(f, conv_obj.get(f) / (intercepts.get(f) - ideal_point.get(f)));
                        continue;
                    }
                    conv_obj.set(f, conv_obj.get(f) / 1.0E-9);
                }
                ((NSGA3MultiObjectiveFitness)ind.fitness).setNormFit(conv_obj);
            }
        }
    }

    public double perpendicularDistance(List<Double> direction, List<Double> point) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < direction.size(); ++i) {
            numerator += direction.get(i) * point.get(i);
            denominator += Math.pow(direction.get(i), 2.0);
        }
        double k = numerator / denominator;
        double d = 0.0;
        for (int i = 0; i < direction.size(); ++i) {
            d += Math.pow(k * direction.get(i) - point.get(i), 2.0);
        }
        return Math.sqrt(d);
    }

    public void associate() {
        for (int t = 0; t < this.fronts.size(); ++t) {
            for (Individual ind : this.fronts.get(t)) {
                int min_rp = -1;
                double min_dist = Double.MAX_VALUE;
                for (int r = 0; r < this.referencePoints.size(); ++r) {
                    double d = this.perpendicularDistance(this.referencePoints.get(r).pos(), ((NSGA3MultiObjectiveFitness)ind.fitness).getNormFit());
                    if (!(d < min_dist)) continue;
                    min_dist = d;
                    min_rp = r;
                }
                if (t + 1 != this.fronts.size()) {
                    this.referencePoints.get(min_rp).addAssociation();
                    continue;
                }
                this.referencePoints.get(min_rp).addAssociate(ind, min_dist);
            }
        }
    }

    private ReferencePoint findNicheReferencePoint() {
        int min_size = Integer.MAX_VALUE;
        ArrayList<ReferencePoint> minReferencePoints = new ArrayList<ReferencePoint>();
        for (int r = 0; r < this.referencePoints.size(); ++r) {
            if (this.referencePoints.get(r).numAssociations() < min_size) {
                minReferencePoints = new ArrayList();
                min_size = this.referencePoints.get(r).numAssociations();
            }
            if (this.referencePoints.get(r).numAssociations() != min_size) continue;
            minReferencePoints.add(this.referencePoints.get(r));
        }
        if (minReferencePoints.size() > 0) {
            return (ReferencePoint)minReferencePoints.get(new Random().nextInt(minReferencePoints.size()));
        }
        return (ReferencePoint)minReferencePoints.get(0);
    }

    public Individual SelectClusterMember(ReferencePoint rp) {
        Individual chosen = null;
        if (rp.hasAssociates()) {
            chosen = rp.numAssociations() == 0 ? rp.FindClosestAssociate() : rp.RandomAssociate();
        }
        return chosen;
    }

    public List<Individual> selectFrontLIndividuals(int numToSelect) {
        this.normalizeObjectives();
        this.associate();
        ArrayList<Individual> frontL = new ArrayList<Individual>();
        while (frontL.size() < numToSelect) {
            ReferencePoint min_rp = this.findNicheReferencePoint();
            Individual chosen = this.SelectClusterMember(min_rp);
            if (chosen == null) {
                this.referencePoints.remove(min_rp);
                continue;
            }
            min_rp.addAssociation();
            min_rp.RemoveAssociate(chosen);
            frontL.add(chosen);
        }
        return frontL;
    }
}

