/*
 * Decompiled with CFR 0.152.
 */
package ec.neat;

import ec.EvolutionState;
import ec.neat.NEATDefaults;
import ec.neat.NEATGene;
import ec.neat.NEATInnovation;
import ec.neat.NEATNetwork;
import ec.neat.NEATNode;
import ec.neat.NEATSpecies;
import ec.neat.NEATSubspecies;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.Gene;
import ec.vector.GeneVectorIndividual;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEATIndividual
extends GeneVectorIndividual {
    public double adjustedFitness;
    public NEATSubspecies subspecies;
    public double expectedOffspring;
    public int generation;
    public boolean eliminate;
    public boolean champion;
    public int superChampionOffspring;
    public boolean popChampion;
    public boolean popChampionChild;
    public double highFit;
    public int timeAlive;
    public ArrayList<NEATNode> nodes;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.eliminate = false;
        this.expectedOffspring = 0.0;
        this.generation = 0;
        this.subspecies = null;
        this.champion = false;
        this.superChampionOffspring = 0;
        this.nodes = new ArrayList();
    }

    @Override
    public Parameter defaultBase() {
        return NEATDefaults.base().push("individual");
    }

    @Override
    public void reset(EvolutionState state, int thread) {
        super.reset(state, thread);
    }

    public void reset(ArrayList<NEATNode> nodeList, ArrayList<Gene> genes) {
        this.genome = new Gene[genes.size()];
        this.genome = genes.toArray(this.genome);
        this.nodes = nodeList;
        for (int i = 0; i < this.genome.length; ++i) {
            NEATGene gene = (NEATGene)this.genome[i];
            for (int j = 0; j < this.nodes.size(); ++j) {
                if (this.nodes.get((int)j).nodeId == gene.inNodeId) {
                    gene.inNode = this.nodes.get(j);
                }
                if (this.nodes.get((int)j).nodeId != gene.outNodeId) continue;
                gene.outNode = this.nodes.get(j);
            }
        }
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        for (int i = 0; i < this.nodes.size(); ++i) {
            hash = hash * 31 + 17 + this.nodes.get(i).hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        int len2;
        if (!super.equals(obj)) {
            return false;
        }
        NEATIndividual ind = (NEATIndividual)obj;
        int len1 = this.nodes.size();
        if (len1 != (len2 = ind.nodes.size())) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (this.nodes.get(i).equals(ind.nodes.get(i))) continue;
            return false;
        }
        return true;
    }

    public void setGeneration(EvolutionState state) {
        this.generation = state.generation;
    }

    public int getNodeIdSup() {
        return this.nodes.get((int)(this.nodes.size() - 1)).nodeId + 1;
    }

    public int getGeneInnovationNumberSup() {
        return ((NEATGene)this.genome[this.genome.length - 1]).innovationNumber + 1;
    }

    @Override
    public Object clone() {
        int i;
        NEATIndividual myobj = (NEATIndividual)super.clone();
        myobj.nodes = new ArrayList();
        for (i = 0; i < this.nodes.size(); ++i) {
            NEATNode newNode = (NEATNode)this.nodes.get(i).emptyClone();
            myobj.nodes.add(newNode);
        }
        for (i = 0; i < myobj.genome.length; ++i) {
            NEATGene gene = (NEATGene)myobj.genome[i];
            for (int j = 0; j < myobj.nodes.size(); ++j) {
                if (myobj.nodes.get((int)j).nodeId == gene.inNodeId) {
                    gene.inNode = myobj.nodes.get(j);
                }
                if (myobj.nodes.get((int)j).nodeId != gene.outNodeId) continue;
                gene.outNode = myobj.nodes.get(j);
            }
        }
        return myobj;
    }

    @Override
    public String genotypeToString() {
        int i;
        StringBuilder s = new StringBuilder();
        int size = this.genome.length;
        s.append(Code.encode(size));
        for (i = 0; i < this.genome.length; ++i) {
            s.append("\n");
            s.append(this.genome[i].printGeneToString());
        }
        s.append("\n" + Code.encode(this.nodes.size()));
        for (i = 0; i < this.nodes.size(); ++i) {
            s.append("\n");
            s.append(this.nodes.get(i).printNodeToString());
        }
        return s.toString();
    }

    @Override
    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        super.parseGenotype(state, reader);
        this.parseNodes(state, reader);
        for (int i = 0; i < this.genome.length; ++i) {
            NEATGene neatGene = (NEATGene)this.genome[i];
            for (int j = 0; j < this.nodes.size(); ++j) {
                if (this.nodes.get((int)j).nodeId == neatGene.inNodeId) {
                    neatGene.inNode = this.nodes.get(j);
                    continue;
                }
                if (this.nodes.get((int)j).nodeId != neatGene.outNodeId) continue;
                neatGene.outNode = this.nodes.get(j);
            }
        }
    }

    public void parseNodes(EvolutionState state, LineNumberReader reader) throws IOException {
        String string = reader.readLine();
        DecodeReturn d = new DecodeReturn(string);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with nodes:\n" + string + "\n... does not have an integer at the beginning indicating the node count.");
        }
        int lll = (int)d.l;
        NEATSpecies s = (NEATSpecies)this.species;
        for (int i = 0; i < lll; ++i) {
            NEATNode node = (NEATNode)s.nodePrototype.emptyClone();
            node.readNode(state, reader);
            this.nodes.add(node);
        }
    }

    public void addGene(NEATGene[] appendGenes) {
        Gene[] newGenome = new Gene[this.genome.length + appendGenes.length];
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length);
        System.arraycopy(appendGenes, 0, newGenome, this.genome.length, appendGenes.length);
        this.setGenome(newGenome);
    }

    public void mutateLinkWeights(EvolutionState state, int thread, NEATSpecies species, double power, double rate, NEATSpecies.MutationType mutationType) {
        double endPart = (double)this.genome.length * 0.8;
        double powerMod = 1.0;
        boolean severe = state.random[thread].nextBoolean();
        for (int i = 0; i < this.genome.length; ++i) {
            double coldGaussPoint;
            double gaussPoint;
            NEATGene gene = (NEATGene)this.genome[i];
            if (severe) {
                gaussPoint = 0.3;
                coldGaussPoint = 0.1;
            } else if (this.genome.length >= 10 && (double)i > endPart) {
                gaussPoint = 0.5;
                coldGaussPoint = 0.3;
            } else if (state.random[thread].nextBoolean()) {
                gaussPoint = 1.0 - rate;
                coldGaussPoint = 1.0 - rate - 0.1;
            } else {
                gaussPoint = 1.0 - rate;
                coldGaussPoint = 1.0 - rate;
            }
            double value = (double)(state.random[thread].nextBoolean() ? 1 : -1) * state.random[thread].nextDouble() * power * powerMod;
            if (mutationType == NEATSpecies.MutationType.GAUSSIAN) {
                double randomChoice = state.random[thread].nextDouble();
                if (randomChoice > gaussPoint) {
                    gene.weight += value;
                } else if (randomChoice > coldGaussPoint) {
                    gene.weight = value;
                }
            } else if (mutationType == NEATSpecies.MutationType.COLDGAUSSIAN) {
                gene.weight = value;
            }
            gene.mutationNumber = gene.weight;
        }
    }

    public void mutateAddLink(EvolutionState state, int thread) {
        int tryCount = 0;
        NEATSpecies neatSpecies = (NEATSpecies)this.species;
        int newLinkTries = neatSpecies.newLinkTries;
        boolean doRecur = state.random[thread].nextBoolean(neatSpecies.recurOnlyProb);
        NEATNode firstNode = null;
        NEATNode secondNode = null;
        int firstNonSensor = -1;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get((int)i).type != NEATNode.NodeType.SENSOR) continue;
            firstNonSensor = i;
            break;
        }
        boolean loopRecur = false;
        int firstNodeIndex = -1;
        int secondNodeIndex = -1;
        boolean found = false;
        while (tryCount < newLinkTries) {
            if (doRecur) {
                loopRecur = state.random[thread].nextBoolean();
                if (loopRecur) {
                    secondNodeIndex = firstNodeIndex = firstNonSensor + state.random[thread].nextInt(this.nodes.size() - firstNonSensor);
                } else {
                    firstNodeIndex = state.random[thread].nextInt(this.nodes.size());
                    secondNodeIndex = firstNonSensor + state.random[thread].nextInt(this.nodes.size() - firstNonSensor);
                }
            } else {
                firstNodeIndex = state.random[thread].nextInt(this.nodes.size());
                secondNodeIndex = firstNonSensor + state.random[thread].nextInt(this.nodes.size() - firstNonSensor);
            }
            firstNode = this.nodes.get(firstNodeIndex);
            secondNode = this.nodes.get(secondNodeIndex);
            boolean bypass = false;
            for (int i = 0; i < this.genome.length; ++i) {
                NEATGene gene = (NEATGene)this.genome[i];
                if (secondNode.type == NEATNode.NodeType.SENSOR) {
                    bypass = true;
                    break;
                }
                if (gene.inNodeId == firstNode.nodeId && gene.outNodeId == secondNode.nodeId && gene.isRecurrent && doRecur) {
                    bypass = true;
                    break;
                }
                if (gene.inNodeId != firstNode.nodeId || gene.outNodeId != secondNode.nodeId || gene.isRecurrent || doRecur) continue;
                bypass = true;
                break;
            }
            if (!bypass) {
                int threshold = this.nodes.size() * this.nodes.size();
                boolean[] result = NEATNetwork.hasPath(state, firstNode, secondNode, threshold);
                if (!result[0]) {
                    state.output.error("network has infinite loop");
                    return;
                }
                if (!result[1] && doRecur || result[1] && !doRecur) {
                    ++tryCount;
                    continue;
                }
                found = true;
                break;
            }
            ++tryCount;
        }
        if (!found) {
            return;
        }
        NEATInnovation testInno = (NEATInnovation)neatSpecies.innovationPrototype.clone();
        testInno.reset(firstNode.nodeId, secondNode.nodeId, doRecur);
        NEATGene[] newGenes = new NEATGene[1];
        if (neatSpecies.hasInnovation(testInno)) {
            NEATInnovation innovation = neatSpecies.getInnovation(testInno);
            newGenes[0] = (NEATGene)neatSpecies.genePrototype.clone();
            newGenes[0].reset(innovation.newWeight, firstNode.nodeId, secondNode.nodeId, doRecur, innovation.innovationNum1, 0.0);
            newGenes[0].inNode = firstNode;
            newGenes[0].outNode = secondNode;
        } else {
            double weight = state.random[thread].nextBoolean() ? 1.0 : -1.0;
            newGenes[0] = (NEATGene)neatSpecies.genePrototype.clone();
            int currInnovNum = neatSpecies.nextInnovationNumber();
            newGenes[0].reset(weight *= state.random[thread].nextDouble(), firstNode.nodeId, secondNode.nodeId, doRecur, currInnovNum, weight);
            newGenes[0].inNode = firstNode;
            newGenes[0].outNode = secondNode;
            NEATInnovation newInno = (NEATInnovation)neatSpecies.innovationPrototype.clone();
            newInno.reset(firstNode.nodeId, secondNode.nodeId, currInnovNum, weight, doRecur);
            neatSpecies.addInnovation(newInno);
        }
        this.addGene(newGenes);
    }

    public void mutateAddNode(EvolutionState state, int thread) {
        NEATSpecies neatSpecies = (NEATSpecies)this.species;
        NEATGene gene = null;
        int newNodeTries = neatSpecies.newNodeTries;
        boolean found = false;
        int i = 0;
        if (this.genomeLength() < neatSpecies.addNodeMaxGenomeLength) {
            boolean step2 = false;
            for (i = 0; i < this.genome.length; ++i) {
                gene = (NEATGene)this.genome[i];
                if (gene.enable && gene.inNode.geneticNodeLabel != NEATNode.NodePlace.BIAS) break;
            }
            while (i < this.genome.length) {
                gene = (NEATGene)this.genome[i];
                if (state.random[thread].nextBoolean(0.7) && gene.inNode.geneticNodeLabel != NEATNode.NodePlace.BIAS) {
                    step2 = true;
                    break;
                }
                ++i;
            }
            if (step2 && gene.enable) {
                found = true;
            }
        } else {
            for (int tryCount = 0; tryCount < newNodeTries && !found; ++tryCount) {
                int index = state.random[thread].nextInt(this.genomeLength());
                gene = (NEATGene)this.genome[index];
                if (!gene.enable || gene.inNode.geneticNodeLabel == NEATNode.NodePlace.BIAS) continue;
                found = true;
            }
        }
        if (!found) {
            return;
        }
        gene.enable = false;
        double oldWeight = gene.weight;
        NEATNode inNode = gene.inNode;
        NEATNode outNode = gene.outNode;
        NEATInnovation testInno = (NEATInnovation)neatSpecies.innovationPrototype.clone();
        testInno.reset(inNode.nodeId, outNode.nodeId, gene.innovationNumber);
        NEATNode newNode = null;
        NEATGene[] newGenes = new NEATGene[2];
        if (neatSpecies.hasInnovation(testInno)) {
            NEATInnovation innovation = neatSpecies.getInnovation(testInno);
            newNode = (NEATNode)neatSpecies.nodePrototype.emptyClone();
            newNode.reset(NEATNode.NodeType.NEURON, innovation.newNodeId, NEATNode.NodePlace.HIDDEN);
            newGenes[0] = (NEATGene)neatSpecies.genePrototype.clone();
            newGenes[0].reset(1.0, inNode.nodeId, newNode.nodeId, gene.isRecurrent, innovation.innovationNum1, 0.0);
            newGenes[0].inNode = inNode;
            newGenes[0].outNode = newNode;
            newGenes[1] = (NEATGene)neatSpecies.genePrototype.clone();
            newGenes[1].reset(oldWeight, newNode.nodeId, outNode.nodeId, false, innovation.innovationNum2, 0.0);
            newGenes[1].inNode = newNode;
            newGenes[1].outNode = outNode;
        } else {
            newNode = (NEATNode)neatSpecies.nodePrototype.emptyClone();
            newNode.reset(NEATNode.NodeType.NEURON, neatSpecies.currNodeId++, NEATNode.NodePlace.HIDDEN);
            newGenes[0] = (NEATGene)neatSpecies.genePrototype.clone();
            int currInnovNum = neatSpecies.nextInnovationNumber();
            int currInnovNum2 = neatSpecies.nextInnovationNumber();
            newGenes[0].reset(1.0, inNode.nodeId, newNode.nodeId, gene.isRecurrent, currInnovNum, 0.0);
            newGenes[0].inNode = inNode;
            newGenes[0].outNode = newNode;
            newGenes[1] = (NEATGene)neatSpecies.genePrototype.clone();
            newGenes[1].reset(oldWeight, newNode.nodeId, outNode.nodeId, false, currInnovNum2, 0.0);
            newGenes[1].inNode = newNode;
            newGenes[1].outNode = outNode;
            NEATInnovation newInno = (NEATInnovation)neatSpecies.innovationPrototype.clone();
            newInno.reset(inNode.nodeId, outNode.nodeId, currInnovNum, currInnovNum2, newNode.nodeId, gene.innovationNumber);
            neatSpecies.addInnovation(newInno);
        }
        this.nodes.add(newNode);
        this.addGene(newGenes);
    }

    public void mutateToggleEnable(EvolutionState state, int thread, int times) {
        for (int i = 0; i < times; ++i) {
            int index = state.random[thread].nextInt(this.genome.length);
            NEATGene gene = (NEATGene)this.genome[index];
            if (gene.enable) {
                boolean found = false;
                for (int j = 0; j < this.genome.length; ++j) {
                    NEATGene anotherGene = (NEATGene)this.genome[j];
                    if (anotherGene.inNodeId != gene.inNodeId || !anotherGene.enable || anotherGene.innovationNumber == gene.innovationNumber) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                gene.enable = false;
                continue;
            }
            gene.enable = true;
        }
    }

    public void mutateGeneReenable() {
        for (int i = 0; i < this.genome.length; ++i) {
            NEATGene gene = (NEATGene)this.genome[i];
            if (gene.enable) continue;
            gene.enable = true;
            break;
        }
    }

    @Override
    public void defaultMutate(EvolutionState state, int thread) {
        NEATSpecies neatSpecies = (NEATSpecies)this.species;
        if (state.random[thread].nextBoolean(neatSpecies.mutateAddNodeProb)) {
            this.mutateAddNode(state, thread);
        } else if (state.random[thread].nextBoolean(neatSpecies.mutateAddLinkProb)) {
            this.createNetwork();
            this.mutateAddLink(state, thread);
        } else {
            if (state.random[thread].nextBoolean(neatSpecies.mutateLinkWeightsProb)) {
                this.mutateLinkWeights(state, thread, neatSpecies, neatSpecies.weightMutationPower, 1.0, NEATSpecies.MutationType.GAUSSIAN);
            }
            if (state.random[thread].nextBoolean(neatSpecies.mutateToggleEnableProb)) {
                this.mutateToggleEnable(state, thread, 1);
            }
            if (state.random[thread].nextBoolean(neatSpecies.mutateGeneReenableProb)) {
                this.mutateGeneReenable();
            }
        }
    }

    public NEATIndividual crossover(EvolutionState state, int thread, NEATIndividual secondParent) {
        NEATSpecies neatSpecies = (NEATSpecies)this.species;
        NEATIndividual newInd = null;
        newInd = state.random[thread].nextBoolean(neatSpecies.mateMultipointProb) ? this.mateMultipoint(state, thread, secondParent, false) : (state.random[thread].nextBoolean(neatSpecies.mateMultipointAvgProb / (neatSpecies.mateMultipointAvgProb + neatSpecies.mateSinglepointProb)) ? this.mateMultipoint(state, thread, secondParent, true) : this.mateSinglepoint(state, thread, secondParent));
        return newInd;
    }

    @Deprecated
    public NEATIndividual mateSinglepoint(EvolutionState state, int thread, NEATIndividual secondParent) {
        int sizeB;
        NEATSpecies neatSpecies = (NEATSpecies)this.species;
        ArrayList<NEATNode> newNodes = new ArrayList<NEATNode>();
        ArrayList<Gene> newGenes = new ArrayList<Gene>();
        int sizeA = this.genomeLength();
        Gene[] genomeA = sizeA < (sizeB = secondParent.genomeLength()) ? this.genome : secondParent.genome;
        Gene[] genomeB = sizeA < sizeB ? secondParent.genome : this.genome;
        int lengthA = genomeA.length;
        int lengthB = genomeB.length;
        int crossPoint = state.random[thread].nextInt(lengthA);
        NEATGene geneA = null;
        NEATGene geneB = null;
        int indexA = 0;
        int indexB = 0;
        boolean skip = false;
        int geneCounter = 0;
        NEATGene chosenGene = null;
        while (indexA < lengthA || indexB < lengthB) {
            if (indexA == lengthA) {
                chosenGene = (NEATGene)genomeB[indexB];
                ++indexB;
            } else if (indexB == lengthB) {
                chosenGene = (NEATGene)genomeA[indexA];
                ++indexA;
            } else {
                int innovA = ((NEATGene)genomeA[indexA]).innovationNumber;
                int innovB = ((NEATGene)genomeB[indexB]).innovationNumber;
                if (innovA == innovB) {
                    if (geneCounter < crossPoint) {
                        chosenGene = (NEATGene)genomeA[indexA];
                    } else if (geneCounter > crossPoint) {
                        chosenGene = (NEATGene)genomeB[indexB];
                    } else {
                        geneA = (NEATGene)genomeA[indexA];
                        geneB = (NEATGene)genomeB[indexB];
                        NEATGene avgGene = (NEATGene)neatSpecies.genePrototype.clone();
                        double weight = (geneA.weight + geneB.weight) / 2.0;
                        int inNodeId = state.random[thread].nextBoolean() ? geneA.inNodeId : geneB.inNodeId;
                        int outNodeId = state.random[thread].nextBoolean() ? geneA.outNodeId : geneB.outNodeId;
                        boolean isRecurrent = state.random[thread].nextBoolean() ? geneA.isRecurrent : geneB.isRecurrent;
                        int innovationNumber = geneA.innovationNumber;
                        double mutationNumber = (geneA.mutationNumber + geneB.mutationNumber) / 2.0;
                        avgGene.enable = geneA.enable && geneB.enable;
                        avgGene.reset(weight, inNodeId, outNodeId, isRecurrent, innovationNumber, mutationNumber);
                        chosenGene = avgGene;
                    }
                    ++indexA;
                    ++indexB;
                    ++geneCounter;
                } else if (innovA < innovB) {
                    if (geneCounter < crossPoint) {
                        chosenGene = (NEATGene)genomeA[indexA];
                        ++indexA;
                        ++geneCounter;
                    } else {
                        chosenGene = (NEATGene)genomeB[indexB];
                        ++indexB;
                    }
                } else if (innovA > innovB) {
                    ++indexB;
                    skip = true;
                }
            }
            if (this.hasGene(newGenes, chosenGene)) {
                skip = true;
            }
            if (!skip) {
                this.createNodeCopyIfMissing(newNodes, chosenGene.inNode);
                this.createNodeCopyIfMissing(newNodes, chosenGene.outNode);
                NEATGene newGene = (NEATGene)chosenGene.clone();
                newGenes.add(newGene);
            }
            skip = false;
        }
        return null;
    }

    public boolean hasGene(ArrayList<Gene> genome, Gene gene) {
        NEATGene neatGene = (NEATGene)gene;
        for (int i = 0; i < genome.size(); ++i) {
            NEATGene g = (NEATGene)genome.get(i);
            if (g.inNodeId != neatGene.inNodeId || g.outNodeId != neatGene.outNodeId || g.isRecurrent != neatGene.isRecurrent) continue;
            return true;
        }
        return false;
    }

    public void createNodeCopyIfMissing(ArrayList<NEATNode> nodeList, NEATNode node) {
        for (int i = 0; i < nodeList.size(); ++i) {
            NEATNode n = nodeList.get(i);
            if (node.nodeId == n.nodeId) {
                return;
            }
            if (node.nodeId >= n.nodeId) continue;
            NEATNode newNode = (NEATNode)node.emptyClone();
            nodeList.add(i, newNode);
            return;
        }
        NEATNode newNode = (NEATNode)node.emptyClone();
        nodeList.add(newNode);
    }

    public NEATIndividual mateMultipoint(EvolutionState state, int thread, NEATIndividual secondParent, boolean averageFlag) {
        NEATSpecies neatSpecies = (NEATSpecies)this.species;
        ArrayList<NEATNode> newNodes = new ArrayList<NEATNode>();
        ArrayList<Gene> newGenes = new ArrayList<Gene>();
        int indexA = 0;
        int indexB = 0;
        Gene[] genomeA = this.genome;
        Gene[] genomeB = secondParent.genome;
        int lengthA = genomeA.length;
        int lengthB = genomeB.length;
        boolean firstFitter = this.isSuperiorTo(this, secondParent);
        for (int i = 0; i < secondParent.nodes.size(); ++i) {
            NEATNode node = secondParent.nodes.get(i);
            if (node.geneticNodeLabel != NEATNode.NodePlace.INPUT && node.geneticNodeLabel != NEATNode.NodePlace.BIAS && node.geneticNodeLabel != NEATNode.NodePlace.OUTPUT) continue;
            this.createNodeCopyIfMissing(newNodes, node);
        }
        NEATGene chosenGene = null;
        while (indexA < lengthA || indexB < lengthB) {
            boolean skip = false;
            if (indexA >= lengthA) {
                chosenGene = (NEATGene)genomeB[indexB];
                ++indexB;
                if (firstFitter) {
                    skip = true;
                }
            } else if (indexB >= lengthB) {
                chosenGene = (NEATGene)genomeA[indexA];
                ++indexA;
                if (!firstFitter) {
                    skip = true;
                }
            } else {
                NEATGene geneA = (NEATGene)genomeA[indexA];
                NEATGene geneB = (NEATGene)genomeB[indexB];
                int innovA = geneA.innovationNumber;
                int innovB = geneB.innovationNumber;
                if (innovA == innovB) {
                    if (!averageFlag) {
                        NEATGene nEATGene = chosenGene = state.random[thread].nextBoolean() ? geneA : geneB;
                        if (!(geneA.enable && geneB.enable || !state.random[thread].nextBoolean(0.75))) {
                            chosenGene.enable = false;
                        }
                    } else {
                        double weight = (geneA.weight + geneB.weight) / 2.0;
                        int inNodeId = -1;
                        int outNodeId = -1;
                        NEATNode inNode = null;
                        NEATNode outNode = null;
                        if (state.random[thread].nextBoolean()) {
                            inNodeId = geneA.inNodeId;
                            inNode = geneA.inNode;
                        } else {
                            inNodeId = geneB.inNodeId;
                            inNode = geneB.inNode;
                        }
                        if (state.random[thread].nextBoolean()) {
                            outNodeId = geneA.outNodeId;
                            outNode = geneA.outNode;
                        } else {
                            outNodeId = geneB.outNodeId;
                            outNode = geneB.outNode;
                        }
                        boolean isRecurrent = state.random[thread].nextBoolean() ? geneA.isRecurrent : geneB.isRecurrent;
                        int innovationNumber = geneA.innovationNumber;
                        double mutationNumber = (geneA.mutationNumber + geneB.mutationNumber) / 2.0;
                        boolean enable = true;
                        if (!(geneA.enable && geneB.enable || !state.random[thread].nextBoolean(0.75))) {
                            enable = false;
                        }
                        chosenGene = (NEATGene)neatSpecies.genePrototype.clone();
                        chosenGene.reset(weight, inNodeId, outNodeId, isRecurrent, innovationNumber, mutationNumber);
                        chosenGene.enable = enable;
                        chosenGene.inNode = inNode;
                        chosenGene.outNode = outNode;
                    }
                    ++indexA;
                    ++indexB;
                } else if (innovA < innovB) {
                    chosenGene = (NEATGene)genomeA[indexA];
                    ++indexA;
                    if (!firstFitter) {
                        skip = true;
                    }
                } else if (innovA > innovB) {
                    chosenGene = (NEATGene)genomeB[indexB];
                    ++indexB;
                    if (firstFitter) {
                        skip = true;
                    }
                }
            }
            if (!skip && this.hasGene(newGenes, chosenGene)) {
                skip = true;
            }
            if (skip) continue;
            this.createNodeCopyIfMissing(newNodes, chosenGene.inNode);
            this.createNodeCopyIfMissing(newNodes, chosenGene.outNode);
            NEATGene newGene = (NEATGene)chosenGene.clone();
            newGenes.add(newGene);
        }
        return (NEATIndividual)neatSpecies.newIndividual(state, thread, newNodes, newGenes);
    }

    private boolean isSuperiorTo(NEATIndividual first, NEATIndividual second) {
        boolean firstIsBetter = false;
        firstIsBetter = first.fitness.betterThan(second.fitness) ? true : (second.fitness.betterThan(first.fitness) ? false : first.genome.length < second.genome.length);
        return firstIsBetter;
    }

    public NEATNetwork createNetwork() {
        NEATNetwork net = (NEATNetwork)((NEATSpecies)this.species).networkPrototype.clone();
        net.buildNetwork(this);
        return net;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n GENOME START  ");
        stringBuffer.append("\n  genes are :" + this.genome.length);
        stringBuffer.append("\n  nodes are :" + this.nodes.size());
        for (i = 0; i < this.nodes.size(); ++i) {
            NEATNode node = this.nodes.get(i);
            if (node.geneticNodeLabel == NEATNode.NodePlace.INPUT) {
                stringBuffer.append("\n Input ");
            }
            if (node.geneticNodeLabel == NEATNode.NodePlace.OUTPUT) {
                stringBuffer.append("\n Output");
            }
            if (node.geneticNodeLabel == NEATNode.NodePlace.HIDDEN) {
                stringBuffer.append("\n Hidden");
            }
            if (node.geneticNodeLabel == NEATNode.NodePlace.BIAS) {
                stringBuffer.append("\n Bias  ");
            }
            stringBuffer.append(node.toString());
        }
        for (i = 0; i < this.genome.length; ++i) {
            NEATGene gene = (NEATGene)this.genome[i];
            stringBuffer.append(gene.toString());
        }
        stringBuffer.append("\n");
        stringBuffer.append(" GENOME END");
        return stringBuffer.toString();
    }
}

