/*
 * Decompiled with CFR 0.152.
 */
package ec.neat;

import ec.EvolutionState;
import ec.Prototype;
import ec.neat.NEATDefaults;
import ec.neat.NEATGene;
import ec.neat.NEATIndividual;
import ec.neat.NEATNode;
import ec.neat.NEATSpecies;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEATNetwork
implements Prototype {
    public static final String P_NETWORK = "network";
    public static final double SIGMOID_SLOPE = 4.924273;
    public NEATIndividual individual;
    public ArrayList<NEATNode> nodes;
    public ArrayList<NEATNode> inputs;
    public ArrayList<NEATNode> outputs;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.nodes = new ArrayList();
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
    }

    @Override
    public Parameter defaultBase() {
        return NEATDefaults.base().push(P_NETWORK);
    }

    @Override
    public Object clone() {
        NEATNetwork myobj = null;
        try {
            int i;
            myobj = (NEATNetwork)super.clone();
            myobj.nodes = new ArrayList();
            for (i = 0; i < this.nodes.size(); ++i) {
                myobj.nodes.add((NEATNode)this.nodes.get(i).clone());
            }
            myobj.inputs = new ArrayList();
            for (i = 0; i < this.inputs.size(); ++i) {
                myobj.inputs.add((NEATNode)this.inputs.get(i).clone());
            }
            myobj.outputs = new ArrayList();
            for (i = 0; i < this.outputs.size(); ++i) {
                myobj.outputs.add((NEATNode)this.outputs.get(i).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return myobj;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        NEATNetwork ind = (NEATNetwork)obj;
        if (ind.nodes.size() != this.nodes.size() || ind.inputs.size() != this.inputs.size() || ind.outputs.size() != this.outputs.size()) {
            return false;
        }
        for (i = 0; i < ind.nodes.size(); ++i) {
            if (ind.nodes.get(i).equals(this.nodes.get(i))) continue;
            return false;
        }
        for (i = 0; i < ind.inputs.size(); ++i) {
            if (ind.inputs.get(i).equals(this.inputs.get(i))) continue;
            return false;
        }
        for (i = 0; i < ind.outputs.size(); ++i) {
            if (ind.outputs.get(i).equals(this.outputs.get(i))) continue;
            return false;
        }
        return true;
    }

    public void flush() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            NEATNode node = this.nodes.get(i);
            node.flush();
        }
    }

    public void activate(EvolutionState state) {
        boolean oneTime = false;
        int abortCounter = 0;
        while (this.outputOff() || !oneTime) {
            NEATNode node;
            int i;
            if (++abortCounter >= ((NEATSpecies)this.individual.species).maxNetworkDepth) {
                state.output.fatal("Inputs disconnected from output!");
            }
            for (i = 0; i < this.nodes.size(); ++i) {
                node = this.nodes.get(i);
                if (node.type == NEATNode.NodeType.SENSOR) continue;
                node.activeSum = 0.0;
                node.activeFlag = false;
                ArrayList<NEATGene> incomingLinks = node.incomingGenes;
                for (int j = 0; j < incomingLinks.size(); ++j) {
                    double amount;
                    NEATGene link = incomingLinks.get(j);
                    if (!link.timeDelay) {
                        amount = link.weight * link.inNode.getActivation();
                        if (link.inNode.activeFlag || link.inNode.type == NEATNode.NodeType.SENSOR) {
                            node.activeFlag = true;
                        }
                        node.activeSum += amount;
                        continue;
                    }
                    amount = link.weight * link.inNode.getTimeDelayActivation();
                    node.activeSum += amount;
                }
            }
            for (i = 0; i < this.nodes.size(); ++i) {
                node = this.nodes.get(i);
                if (node.type == NEATNode.NodeType.SENSOR || !node.activeFlag) continue;
                node.previousLastActivation = node.lastActivation;
                node.lastActivation = node.activation;
                if (node.functionType == NEATNode.FunctionType.SIGMOID) {
                    node.sigmoid(4.924273);
                }
                ++node.activationCount;
            }
            oneTime = true;
        }
    }

    public void addInput(NEATNode node) {
        this.inputs.add(node);
    }

    public void addOutput(NEATNode node) {
        this.outputs.add(node);
    }

    public void loadSensors(double[] vals) {
        int counter = 0;
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (this.inputs.get((int)i).type != NEATNode.NodeType.SENSOR) continue;
            this.inputs.get(i).sensorLoad(vals[counter++]);
        }
    }

    public double[] getOutputResults() {
        double[] results = new double[this.outputs.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.outputs.get((int)i).activation;
        }
        return results;
    }

    public static boolean[] hasPath(EvolutionState state, NEATNode toNode, NEATNode fromNode, int threshold) {
        boolean[] results = new boolean[2];
        int level = 0;
        HashSet<NEATNode> set = new HashSet<NEATNode>();
        NEATNetwork.hasPath(state, toNode, fromNode, set, level, threshold, results);
        return results;
    }

    public static void hasPath(EvolutionState state, NEATNode toNode, NEATNode fromNode, HashSet<NEATNode> set, int level, int threshold, boolean[] results) {
        if (level > threshold) {
            results[0] = false;
            results[1] = false;
            return;
        }
        if (toNode.nodeId == fromNode.nodeId) {
            results[0] = true;
            results[1] = true;
        } else {
            for (int i = 0; i < toNode.incomingGenes.size(); ++i) {
                NEATGene link = toNode.incomingGenes.get(i);
                if (link.isRecurrent || set.contains(link.inNode)) continue;
                set.add(link.inNode);
                NEATNetwork.hasPath(state, link.inNode, fromNode, set, level + 1, threshold, results);
                if (!results[0] || !results[1]) continue;
                return;
            }
            set.add(toNode);
            results[0] = true;
            results[1] = false;
        }
    }

    public boolean outputOff() {
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (this.outputs.get((int)i).activationCount != 0) continue;
            return true;
        }
        return false;
    }

    public int maxDepth() {
        int i;
        int maxDepth = 0;
        for (i = 0; i < this.nodes.size(); ++i) {
            NEATNode node = this.nodes.get(i);
            node.innerLevel = 0;
            node.isTraversed = false;
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            int curDepth = this.outputs.get(i).depth(0, this, maxDepth);
            if (curDepth <= maxDepth) continue;
            maxDepth = curDepth;
        }
        return maxDepth;
    }

    public void buildNetwork(NEATIndividual individual) {
        int i;
        this.individual = individual;
        this.nodes.addAll(individual.nodes);
        ArrayList<NEATNode> inputList = new ArrayList<NEATNode>();
        ArrayList<NEATNode> outputList = new ArrayList<NEATNode>();
        for (i = 0; i < individual.nodes.size(); ++i) {
            individual.nodes.get(i).clearIncoming();
            if (individual.nodes.get((int)i).geneticNodeLabel == NEATNode.NodePlace.INPUT) {
                inputList.add(individual.nodes.get(i));
                continue;
            }
            if (individual.nodes.get((int)i).geneticNodeLabel == NEATNode.NodePlace.BIAS) {
                inputList.add(individual.nodes.get(i));
                continue;
            }
            if (individual.nodes.get((int)i).geneticNodeLabel != NEATNode.NodePlace.OUTPUT) continue;
            outputList.add(individual.nodes.get(i));
        }
        this.inputs.addAll(inputList);
        this.outputs.addAll(outputList);
        for (i = 0; i < individual.genome.length; ++i) {
            NEATGene link = (NEATGene)individual.genome[i];
            if (!link.enable) continue;
            NEATNode outNode = link.outNode;
            outNode.incomingGenes.add(link);
        }
    }
}

