/*
 * Decompiled with CFR 0.152.
 */
package ec.parsimony;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BucketTournamentSelection
extends SelectionMethod
implements SteadyStateBSourceForm {
    public static final String P_TOURNAMENT = "bucket-tournament";
    public static final String P_PICKWORST = "pick-worst";
    public static final String P_SIZE = "size";
    public static final String P_BUCKETS = "num-buckets";
    public static final int N_BUCKETS_DEFAULT = 10;
    public int size;
    public boolean pickWorst;
    int nBuckets;
    int[] bucketValues;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_TOURNAMENT);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.size = state.parameters.getInt(base.push(P_SIZE), def.push(P_SIZE), 1);
        if (this.size < 1) {
            state.output.fatal("Tournament size must be >= 1.", base.push(P_SIZE), def.push(P_SIZE));
        }
        if (state.parameters.exists(base.push(P_BUCKETS), def.push(P_BUCKETS))) {
            this.nBuckets = state.parameters.getInt(base.push(P_BUCKETS), def.push(P_BUCKETS), 1);
            if (this.nBuckets < 1) {
                state.output.fatal("The number of buckets size must be >= 1.", base.push(P_BUCKETS), def.push(P_BUCKETS));
            }
        } else {
            this.nBuckets = 10;
        }
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
    }

    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        this.bucketValues = new int[state.population.subpops.get((int)subpopulation).individuals.size()];
        Collections.sort(state.population.subpops.get((int)subpopulation).individuals, new Comparator<Individual>(){

            @Override
            public int compare(Individual a, Individual b) {
                if (a.fitness.betterThan(b.fitness)) {
                    return 1;
                }
                if (b.fitness.betterThan(a.fitness)) {
                    return -1;
                }
                return 0;
            }
        });
        double averageBuck = (double)state.population.subpops.get((int)subpopulation).individuals.size() / (double)this.nBuckets;
        this.bucketValues[0] = 0;
        int nInd = 1;
        for (int i = 1; i < state.population.subpops.get((int)subpopulation).individuals.size(); ++i) {
            if ((double)nInd < averageBuck) {
                this.bucketValues[i] = this.bucketValues[i - 1];
                ++nInd;
                continue;
            }
            if (state.population.subpops.get((int)subpopulation).individuals.get((int)i).fitness.equivalentTo(state.population.subpops.get((int)subpopulation).individuals.get((int)(i - 1)).fitness)) {
                this.bucketValues[i] = this.bucketValues[i - 1];
                ++nInd;
                continue;
            }
            if (this.bucketValues[i - 1] + 1 < this.nBuckets) {
                this.bucketValues[i] = this.bucketValues[i - 1] - 1;
                nInd = 1;
                continue;
            }
            this.bucketValues[i] = this.bucketValues[i - 1];
            ++nInd;
        }
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        ArrayList<Individual> oldinds = state.population.subpops.get((int)subpopulation).individuals;
        int i = state.random[thread].nextInt(oldinds.size());
        long si = 0L;
        for (int x = 1; x < this.size; ++x) {
            long sj;
            int j = state.random[thread].nextInt(oldinds.size());
            if (this.pickWorst) {
                if (this.bucketValues[j] > this.bucketValues[i]) {
                    i = j;
                    si = 0L;
                    continue;
                }
                if (this.bucketValues[i] > this.bucketValues[j]) continue;
                if (si == 0L) {
                    si = oldinds.get(i).size();
                }
                if ((sj = oldinds.get(j).size()) < si) continue;
                i = j;
                si = sj;
                continue;
            }
            if (this.bucketValues[j] < this.bucketValues[i]) {
                i = j;
                si = 0L;
                continue;
            }
            if (this.bucketValues[i] < this.bucketValues[j]) continue;
            if (si == 0L) {
                si = oldinds.get(i).size();
            }
            if ((sj = oldinds.get(j).size()) >= si) continue;
            i = j;
            si = sj;
        }
        return i;
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
    }
}

