/*
 * Decompiled with CFR 0.152.
 */
package ec.parsimony;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.Statistics;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleFitness;
import ec.util.Parameter;

public class TarpeianStatistics
extends Statistics {
    public static final String P_KILL_PROPORTION = "kill-proportion";
    double killProportion;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.killProportion = state.parameters.getDouble(base.push(P_KILL_PROPORTION), null, 0.0);
        if (this.killProportion < 0.0 || this.killProportion > 1.0) {
            state.output.fatal("Parameter not found, or it has an invalid value (<0 or >1).", base.push(P_KILL_PROPORTION));
        }
    }

    public void preEvaluationStatistics(EvolutionState state) {
        for (int subpopulation = 0; subpopulation < state.population.subpops.size(); ++subpopulation) {
            int i;
            double averageSize = 0.0;
            for (i = 0; i < state.population.subpops.get((int)subpopulation).individuals.size(); ++i) {
                averageSize += (double)state.population.subpops.get((int)subpopulation).individuals.get(i).size();
            }
            averageSize /= (double)state.population.subpops.get((int)subpopulation).individuals.size();
            for (i = 0; i < state.population.subpops.get((int)subpopulation).individuals.size(); ++i) {
                if (!((double)state.population.subpops.get((int)subpopulation).individuals.get(i).size() > averageSize) || !(state.random[0].nextDouble() < this.killProportion)) continue;
                Individual ind = state.population.subpops.get((int)subpopulation).individuals.get(i);
                this.setMinimumFitness(state, subpopulation, ind);
                ind.evaluated = true;
            }
        }
    }

    public void setMinimumFitness(EvolutionState state, int subpopulation, Individual ind) {
        Fitness fitness = ind.fitness;
        if (fitness instanceof KozaFitness) {
            ((KozaFitness)fitness).setStandardizedFitness(state, Double.MAX_VALUE);
        } else if (fitness instanceof SimpleFitness) {
            ((SimpleFitness)fitness).setFitness(state, -1.7976931348623157E308, false);
        } else {
            state.output.fatal("TarpeianStatistics only accepts individuals with fitness of type ec.simple.SimpleFitness or ec.gp.koza.KozaFitness.");
        }
    }
}

