/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.simple.SimpleProblemForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class SimpleStatistics
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_STATISTICS_FILE = "file";
    public static final String P_COMPRESS = "gzip";
    public static final String P_DO_FINAL = "do-final";
    public static final String P_DO_GENERATION = "do-generation";
    public static final String P_DO_MESSAGE = "do-message";
    public static final String P_DO_DESCRIPTION = "do-description";
    public static final String P_DO_PER_GENERATION_DESCRIPTION = "do-per-generation-description";
    public int statisticslog = 0;
    public Individual[] best_of_run = null;
    public boolean compress;
    public boolean doFinal;
    public boolean doGeneration;
    public boolean doMessage;
    public boolean doDescription;
    public boolean doPerGenerationDescription;
    boolean warned = false;

    public Individual[] getBestSoFar() {
        return this.best_of_run;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.compress = state.parameters.getBoolean(base.push(P_COMPRESS), null, false);
        File statisticsFile = state.parameters.getFile(base.push(P_STATISTICS_FILE), null);
        this.doFinal = state.parameters.getBoolean(base.push(P_DO_FINAL), null, true);
        this.doGeneration = state.parameters.getBoolean(base.push(P_DO_GENERATION), null, true);
        this.doMessage = state.parameters.getBoolean(base.push(P_DO_MESSAGE), null, true);
        this.doDescription = state.parameters.getBoolean(base.push(P_DO_DESCRIPTION), null, true);
        this.doPerGenerationDescription = state.parameters.getBoolean(base.push(P_DO_PER_GENERATION_DESCRIPTION), null, false);
        if (this.silentFile) {
            this.statisticslog = -2;
        } else if (statisticsFile != null) {
            try {
                this.statisticslog = state.output.addLog(statisticsFile, !this.compress, this.compress);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + statisticsFile + ":\n" + i);
            }
        } else {
            state.output.warning("No statistics file specified, printing to stdout at end.", base.push(P_STATISTICS_FILE));
        }
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        this.best_of_run = new Individual[state.population.subpops.size()];
    }

    protected void bypassPostEvaluationStatistics(EvolutionState state) {
        super.postEvaluationStatistics(state);
    }

    public void postEvaluationStatistics(EvolutionState state) {
        int x;
        super.postEvaluationStatistics(state);
        Individual[] best_i = new Individual[state.population.subpops.size()];
        for (x = 0; x < state.population.subpops.size(); ++x) {
            best_i[x] = state.population.subpops.get((int)x).individuals.get(0);
            for (int y = 1; y < state.population.subpops.get((int)x).individuals.size(); ++y) {
                if (state.population.subpops.get((int)x).individuals.get(y) == null) {
                    if (!this.warned) {
                        state.output.warnOnce("Null individuals found in subpopulation");
                        this.warned = true;
                    }
                } else if (best_i[x] == null || state.population.subpops.get((int)x).individuals.get((int)y).fitness.betterThan(best_i[x].fitness)) {
                    best_i[x] = state.population.subpops.get((int)x).individuals.get(y);
                }
                if (best_i[x] != null || this.warned) continue;
                state.output.warnOnce("Null individuals found in subpopulation");
                this.warned = true;
            }
            if (this.best_of_run[x] != null && !best_i[x].fitness.betterThan(this.best_of_run[x].fitness)) continue;
            this.best_of_run[x] = (Individual)best_i[x].clone();
        }
        if (this.doGeneration) {
            state.output.println("\nGeneration: " + state.generation, this.statisticslog);
        }
        if (this.doGeneration) {
            state.output.println("Best Individual:", this.statisticslog);
        }
        for (x = 0; x < state.population.subpops.size(); ++x) {
            if (this.doGeneration) {
                state.output.println("Subpopulation " + x + ":", this.statisticslog);
            }
            if (this.doGeneration) {
                best_i[x].printIndividualForHumans(state, this.statisticslog);
            }
            if (this.doMessage && !this.silentPrint) {
                state.output.message("Subpop " + x + " best fitness of generation" + (best_i[x].evaluated ? " " : " (evaluated flag not set): ") + best_i[x].fitness.fitnessToStringForHumans());
            }
            if (!this.doGeneration || !this.doPerGenerationDescription || !(state.evaluator.p_problem instanceof SimpleProblemForm)) continue;
            ((SimpleProblemForm)state.evaluator.p_problem.clone()).describe(state, best_i[x], x, 0, this.statisticslog);
        }
    }

    protected void bypassFinalStatistics(EvolutionState state, int result) {
        super.finalStatistics(state, result);
    }

    public void finalStatistics(EvolutionState state, int result) {
        super.finalStatistics(state, result);
        if (this.doFinal) {
            state.output.println("\nBest Individual of Run:", this.statisticslog);
        }
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            if (this.doFinal) {
                state.output.println("Subpopulation " + x + ":", this.statisticslog);
            }
            if (this.doFinal) {
                this.best_of_run[x].printIndividualForHumans(state, this.statisticslog);
            }
            if (this.doMessage && !this.silentPrint) {
                state.output.message("Subpop " + x + " best fitness of run: " + this.best_of_run[x].fitness.fitnessToStringForHumans());
            }
            if (!this.doFinal || !this.doDescription || !(state.evaluator.p_problem instanceof SimpleProblemForm)) continue;
            ((SimpleProblemForm)state.evaluator.p_problem.clone()).describe(state, this.best_of_run[x], x, 0, this.statisticslog);
        }
    }
}

