/*
 * Decompiled with CFR 0.152.
 */
package ec.spatial;

import ec.BreedingSource;
import ec.EvolutionState;
import ec.Population;
import ec.simple.SimpleBreeder;
import ec.spatial.Space;
import ec.util.Parameter;
import java.util.ArrayList;

public class SpatialBreeder
extends SimpleBreeder {
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        for (int i = 0; i < this.elite.length; ++i) {
            if (!this.usingElitism(i)) continue;
            state.output.warning("You're using elitism with SpatialBreeder.  This is unwise as elitism is done by moving individuals around in the population, thus messing up the spatial nature of breeding.", base.push("elite").push("" + i));
            break;
        }
        if (this.sequentialBreeding) {
            state.output.warning("SpationBreeder hasn't been well tested with sequential evaluation, though it should probably work fine.  You're on your own.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for SpatialBreeder.");
        }
    }

    protected void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.size(); ++subpop) {
            ArrayList putHere = this.newIndividuals[subpop][threadnum];
            BreedingSource bp = null;
            bp = this.clonePipelineAndPopulation ? (BreedingSource)newpop.subpops.get((int)subpop).species.pipe_prototype.clone() : newpop.subpops.get((int)subpop).species.pipe_prototype;
            bp.fillStubs(state, null);
            if (!(state.population.subpops.get(subpop) instanceof Space)) {
                state.output.fatal("Subpopulation " + subpop + " does not implement the Space interface.");
            }
            Space space = (Space)((Object)state.population.subpops.get(subpop));
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Source of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops.get((int)subpop).species.getClass().getName() + " or fitness " + newpop.subpops.get((int)subpop).species.f_prototype);
            }
            bp.prepareToProduce(state, subpop, threadnum);
            for (int x = from[subpop]; x < from[subpop] + numinds[subpop]; ++x) {
                space.setIndex(threadnum, x);
                if (bp.produce(1, 1, subpop, putHere, state, threadnum, newpop.subpops.get((int)subpop).species.buildMisc(state, subpop, threadnum)) == 1) continue;
                state.output.fatal("The sources should produce one individual at a time!");
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }
}

