/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Parameter;
import ec.vector.ByteVectorIndividual;
import ec.vector.IntegerVectorIndividual;
import ec.vector.LongVectorIndividual;
import ec.vector.ShortVectorIndividual;
import ec.vector.VectorSpecies;

public class IntegerVectorSpecies
extends VectorSpecies {
    public static final String P_MINGENE = "min-gene";
    public static final String P_MAXGENE = "max-gene";
    public static final String P_NUM_SEGMENTS = "num-segments";
    public static final String P_SEGMENT_TYPE = "segment-type";
    public static final String P_SEGMENT_START = "start";
    public static final String P_SEGMENT_END = "end";
    public static final String P_SEGMENT = "segment";
    public static final String P_MUTATIONTYPE = "mutation-type";
    public static final String P_RANDOM_WALK_PROBABILITY = "random-walk-probability";
    public static final String P_MUTATION_BOUNDED = "mutation-bounded";
    public static final String V_RESET_MUTATION = "reset";
    public static final String V_RANDOM_WALK_MUTATION = "random-walk";
    public static final int C_RESET_MUTATION = 0;
    public static final int C_RANDOM_WALK_MUTATION = 1;
    protected long[] minGene;
    protected long[] maxGene;
    protected int[] mutationType;
    protected double[] randomWalkProbability;
    protected boolean[] mutationIsBounded;
    boolean mutationIsBoundedDefined;

    public long maxGene(int gene) {
        long[] m = this.maxGene;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public long minGene(int gene) {
        long[] m = this.minGene;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public int mutationType(int gene) {
        int[] m = this.mutationType;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public double randomWalkProbability(int gene) {
        double[] m = this.randomWalkProbability;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean mutationIsBounded(int gene) {
        boolean[] m = this.mutationIsBounded;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean inNumericalTypeRange(double geneVal) {
        if (this.i_prototype instanceof ByteVectorIndividual) {
            return geneVal <= 127.0 && geneVal >= -128.0;
        }
        if (this.i_prototype instanceof ShortVectorIndividual) {
            return geneVal <= 32767.0 && geneVal >= -32768.0;
        }
        if (this.i_prototype instanceof IntegerVectorIndividual) {
            return geneVal <= 2.147483647E9 && geneVal >= -2.147483648E9;
        }
        return this.i_prototype instanceof LongVectorIndividual;
    }

    public boolean inNumericalTypeRange(long geneVal) {
        if (this.i_prototype instanceof ByteVectorIndividual) {
            return geneVal <= 127L && geneVal >= -128L;
        }
        if (this.i_prototype instanceof ShortVectorIndividual) {
            return geneVal <= 32767L && geneVal >= -32768L;
        }
        if (this.i_prototype instanceof IntegerVectorIndividual) {
            return geneVal <= Integer.MAX_VALUE && geneVal >= Integer.MIN_VALUE;
        }
        return this.i_prototype instanceof LongVectorIndividual;
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.setupGenome(state, base);
        this.minGene = new long[this.genomeSize + 1];
        this.maxGene = new long[this.genomeSize + 1];
        this.mutationType = this.fill(new int[this.genomeSize + 1], -1);
        this.mutationIsBounded = new boolean[this.genomeSize + 1];
        this.randomWalkProbability = new double[this.genomeSize + 1];
        long _minGene = state.parameters.getLongWithDefault(base.push(P_MINGENE), def.push(P_MINGENE), 0L);
        long _maxGene = state.parameters.getLong(base.push(P_MAXGENE), def.push(P_MAXGENE), _minGene);
        if (_maxGene < _minGene) {
            state.output.fatal("IntegerVectorSpecies must have a default min-gene which is <= the default max-gene", base.push(P_MAXGENE), def.push(P_MAXGENE));
        }
        this.fill(this.minGene, _minGene);
        this.fill(this.maxGene, _maxGene);
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE), null);
        int _mutationType = 0;
        if (mtype == null) {
            state.output.warning("No global mutation type given for IntegerVectorSpecies, assuming 'reset' mutation", base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        } else if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
            _mutationType = 0;
        } else if (mtype.equalsIgnoreCase(V_RANDOM_WALK_MUTATION)) {
            _mutationType = 1;
        } else {
            state.output.fatal("IntegerVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        }
        this.fill(this.mutationType, _mutationType);
        if (_mutationType == 1) {
            double _randomWalkProbability = state.parameters.getDoubleWithMax(base.push(P_RANDOM_WALK_PROBABILITY), def.push(P_RANDOM_WALK_PROBABILITY), 0.0, 1.0);
            if (_randomWalkProbability <= 0.0) {
                state.output.fatal("If it's going to use random walk mutation as its global mutation type, IntegerVectorSpecies must a random walk mutation probability between 0.0 and 1.0.", base.push(P_RANDOM_WALK_PROBABILITY), def.push(P_RANDOM_WALK_PROBABILITY));
            }
            this.fill(this.randomWalkProbability, _randomWalkProbability);
            if (!state.parameters.exists(base.push(P_MUTATION_BOUNDED), def.push(P_MUTATION_BOUNDED))) {
                state.output.warning("IntegerVectorSpecies is using gaussian, polynomial, or integer randomwalk mutation as its global mutation type, but mutation-bounded is not defined.  Assuming 'true'");
            }
            boolean _mutationIsBounded = state.parameters.getBoolean(base.push(P_MUTATION_BOUNDED), def.push(P_MUTATION_BOUNDED), true);
            this.fill(this.mutationIsBounded, _mutationIsBounded);
            this.mutationIsBoundedDefined = true;
        }
        super.setup(state, base);
        for (int x = 0; x < this.genomeSize + 1; ++x) {
            if (this.maxGene[x] < this.minGene[x]) {
                state.output.fatal("IntegerVectorSpecies must have a min-gene[" + x + "] which is <= the max-gene[" + x + "]");
            }
            if (!this.inNumericalTypeRange(this.minGene[x])) {
                state.output.fatal("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a min-gene[" + x + "] value within the range of this prototype's genome's data types");
            }
            if (this.inNumericalTypeRange(this.maxGene[x])) continue;
            state.output.fatal("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a max-gene[" + x + "] value within the range of this prototype's genome's data types");
        }
    }

    protected void loadParametersForGene(EvolutionState state, int index, Parameter base, Parameter def, String postfix) {
        super.loadParametersForGene(state, index, base, def, postfix);
        boolean minValExists = state.parameters.exists(base.push(P_MINGENE).push(postfix), def.push(P_MINGENE).push(postfix));
        boolean maxValExists = state.parameters.exists(base.push(P_MAXGENE).push(postfix), def.push(P_MAXGENE).push(postfix));
        if (maxValExists && !minValExists) {
            state.output.warning("Max Gene specified but not Min Gene", base.push(P_MINGENE).push(postfix), def.push(P_MINGENE).push(postfix));
        }
        if (minValExists && !maxValExists) {
            state.output.warning("Min Gene specified but not Max Gene", base.push(P_MAXGENE).push(postfix), def.push(P_MINGENE).push(postfix));
        }
        if (minValExists) {
            long minVal = state.parameters.getLongWithDefault(base.push(P_MINGENE).push(postfix), def.push(P_MINGENE).push(postfix), 0L);
            if (!this.inNumericalTypeRange(minVal)) {
                state.output.error("Min Gene Value out of range for data type " + this.i_prototype.getClass().getName(), base.push(P_MINGENE).push(postfix), base.push(P_MINGENE).push(postfix));
            } else {
                this.minGene[index] = minVal;
            }
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-gene or per-segment min-gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MINGENE).push(postfix), base.push(P_MINGENE).push(postfix));
            }
        }
        if (maxValExists) {
            long maxVal = state.parameters.getLongWithDefault(base.push(P_MAXGENE).push(postfix), def.push(P_MAXGENE).push(postfix), 0L);
            if (!this.inNumericalTypeRange(maxVal)) {
                state.output.error("Max Gene Value out of range for data type " + this.i_prototype.getClass().getName(), base.push(P_MAXGENE).push(postfix), base.push(P_MAXGENE).push(postfix));
            } else {
                this.maxGene[index] = maxVal;
            }
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-gene or per-segment max-gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MAXGENE).push(postfix), base.push(P_MAXGENE).push(postfix));
            }
        }
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE).push(postfix), def.push(P_MUTATIONTYPE).push(postfix), null);
        int mutType = -1;
        if (mtype != null) {
            if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
                this.mutationType[index] = 0;
                mutType = 0;
            } else if (mtype.equalsIgnoreCase(V_RANDOM_WALK_MUTATION)) {
                this.mutationType[index] = 1;
                mutType = 1;
                state.output.warnOnce("Integer Random Walk Mutation used in IntegerVectorSpecies.  Be advised that during initialization these genes will only be set to integer values.");
            } else {
                state.output.error("IntegerVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE).push(postfix), def.push(P_MUTATIONTYPE).push(postfix));
            }
        }
        if (mutType == 1) {
            if (state.parameters.exists(base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix))) {
                this.randomWalkProbability[index] = state.parameters.getDoubleWithMax(base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix), 0.0, 1.0);
                if (this.randomWalkProbability[index] <= 0.0) {
                    state.output.error("If it's going to use random walk mutation as a per-gene or per-segment type, IntegerVectorSpecies must a random walk mutation probability between 0.0 and 1.0.", base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix));
                }
            } else {
                state.output.error("If IntegerVectorSpecies is going to use polynomial mutation as a per-gene or per-segment type, either the global or per-gene/per-segment random walk mutation probability must be defined.", base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix));
            }
            if (state.parameters.exists(base.push(P_MUTATION_BOUNDED).push(postfix), def.push(P_MUTATION_BOUNDED).push(postfix))) {
                this.mutationIsBounded[index] = state.parameters.getBoolean(base.push(P_MUTATION_BOUNDED).push(postfix), def.push(P_MUTATION_BOUNDED).push(postfix), true);
            } else if (!this.mutationIsBoundedDefined) {
                state.output.fatal("If IntegerVectorSpecies is going to use gaussian, polynomial, or integer random walk mutation as a per-gene or per-segment type, the mutation bounding must be defined.", base.push(P_MUTATION_BOUNDED).push(postfix), def.push(P_MUTATION_BOUNDED).push(postfix));
            }
        }
    }
}

