/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneDuplicationPipeline
extends BreedingPipeline {
    public static final String P_DUPLICATION = "duplicate";
    public static final int NUM_SOURCES = 1;

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_DUPLICATION);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        for (int q = start; q < n + start; ++q) {
            VectorIndividual ind = (VectorIndividual)inds.get(q);
            int len = ind.genomeLength();
            if (len == 0) {
                return n;
            }
            int end = 0;
            int begin = state.random[thread].nextInt(len + 1);
            while (begin == (end = state.random[thread].nextInt(len + 1))) {
            }
            if (end < begin) {
                int temp = end;
                end = begin;
                begin = temp;
            }
            Object[] original = new Object[2];
            ind.split(new int[]{0, len}, original);
            Object[] splice = new Object[3];
            ind.split(new int[]{begin, end}, splice);
            ind.cloneGenes(splice[1]);
            ind.join(new Object[]{original[1], splice[1]});
        }
        return n;
    }
}

