/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.IntBag;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorCrossoverPipeline
extends BreedingPipeline {
    public static final String P_TOSS = "toss";
    public static final String P_CROSSOVER = "xover";
    public static final int NUM_SOURCES = 2;
    public static final String KEY_PARENTS = "parents";
    public boolean tossSecondParent;
    ArrayList<Individual> parents = new ArrayList();

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_CROSSOVER);
    }

    @Override
    public int numSources() {
        return 2;
    }

    @Override
    public Object clone() {
        VectorCrossoverPipeline c = (VectorCrossoverPipeline)super.clone();
        c.parents = new ArrayList<Individual>(this.parents);
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
    }

    @Override
    public int typicalIndsProduced() {
        return this.tossSecondParent ? this.minChildProduction() : this.minChildProduction() * 2;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        IntBag[] parentparents = null;
        IntBag[] preserveParents = null;
        if (misc != null && misc.containsKey(KEY_PARENTS)) {
            preserveParents = (IntBag[])misc.get(KEY_PARENTS);
            parentparents = new IntBag[2];
            misc.put(KEY_PARENTS, parentparents);
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            this.sources[0].produce(n, n, subpopulation, inds, state, thread, misc);
            return n;
        }
        int q = start;
        while (q < n + start) {
            this.parents.clear();
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, subpopulation, this.parents, state, thread, misc);
            } else {
                this.sources[0].produce(1, 1, subpopulation, this.parents, state, thread, misc);
                this.sources[1].produce(1, 1, subpopulation, this.parents, state, thread, misc);
            }
            ((VectorIndividual)this.parents.get(0)).defaultCrossover(state, thread, (VectorIndividual)this.parents.get(1));
            this.parents.get((int)0).evaluated = false;
            this.parents.get((int)1).evaluated = false;
            inds.add(this.parents.get(0));
            if (preserveParents != null) {
                parentparents[0].addAll(parentparents[1]);
                preserveParents[q] = parentparents[0];
            }
            if (++q >= n + start || this.tossSecondParent) continue;
            inds.add(this.parents.get(1));
            if (preserveParents != null) {
                preserveParents[q] = new IntBag(parentparents[0]);
            }
            ++q;
        }
        if (preserveParents != null) {
            misc.put(KEY_PARENTS, preserveParents);
        }
        return n;
    }
}

