/*
 * Decompiled with CFR 0.152.
 */
package drm.agentbase;

import java.io.Serializable;
import java.net.InetAddress;

public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    InetAddress host = null;
    public final int port;
    public final String name;

    public Address(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must not be empty in Address.");
        }
        this.name = name;
        this.port = -1;
    }

    public Address(InetAddress host, int port, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must not be empty in Address.");
        }
        if (port <= 0 && host != null) {
            throw new IllegalArgumentException("Port must be positive in Address.");
        }
        this.host = host;
        this.port = port;
        this.name = name;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public boolean isLocal() {
        return this.host == null && this.port <= 0;
    }

    public boolean equals(Object o) {
        Address a;
        block5: {
            block4: {
                try {
                    a = (Address)o;
                    if ((a.name != null || this.name == null) && (a.name == null || this.name != null)) break block4;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (this.name != null) break block5;
            return true;
        }
        return a.name.equals(this.name);
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return 0;
    }

    public String toString() {
        String result = "";
        if (!this.isLocal()) {
            result = this.host != null ? this.host.toString() : "<host not known>";
            result = String.valueOf(result) + ":";
            result = this.port != -1 ? String.valueOf(result) + this.port : String.valueOf(result) + "<no port known!>";
            result = String.valueOf(result) + ":";
        }
        result = this.name != null ? String.valueOf(result) + this.name : String.valueOf(result) + "<no name known!>";
        return result;
    }
}

