/*
 * Decompiled with CFR 0.152.
 */
package drm.agentbase;

import drm.agentbase.ClassLoaderBox;
import drm.agentbase.JobClassLoader;
import drm.agentbase.Logger;
import drm.agentbase.ShutdownCLMThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

final class ClassLoaderManager {
    private final File dir;
    private Hashtable loaders = new Hashtable();
    private final ShutdownCLMThread shutDown;

    synchronized void inc(String name) {
        ClassLoaderBox box = (ClassLoaderBox)this.loaders.get(name);
        if (box != null) {
            ++box.users;
        }
    }

    synchronized void dec(String name) {
        ClassLoaderBox box = (ClassLoaderBox)this.loaders.get(name);
        if (box == null) {
            return;
        }
        --box.users;
        if (box.users == 0) {
            box.unusedFrom = System.currentTimeMillis();
        }
    }

    void putLoader(String name, ObjectInputStream is) throws IOException, ClassNotFoundException {
        File file = null;
        int N = is.readInt();
        if (N == -2) {
            file = (File)is.readObject();
            if (!file.canRead()) {
                throw new IOException(file + " is not readable");
            }
        } else {
            int n;
            file = File.createTempFile("jar" + name, null);
            FileOutputStream fos = new FileOutputStream(file);
            Logger.debug(this.getClass().getName(), "saving " + file);
            int buffsize = 1000;
            byte[] buff = new byte[1000];
            int nsum = 0;
            nsum = n = is.read(buff, 0, Math.min(1000, N));
            while (n != -1) {
                fos.write(buff, 0, n);
                if (nsum >= N) break;
                n = is.read(buff, 0, Math.min(1000, N - nsum));
                if (n == -1) continue;
                nsum += n;
            }
            fos.close();
        }
        this.loaders.put(name, new ClassLoaderBox(new JobClassLoader(file), 0));
    }

    ClassLoader getLoader(String name) {
        ClassLoaderBox box = (ClassLoaderBox)this.loaders.get(name);
        if (box != null) {
            return box.cl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanup(long timeout) {
        long t = System.currentTimeMillis();
        Hashtable hashtable = this.loaders;
        synchronized (hashtable) {
            Iterator i = this.loaders.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                ClassLoaderBox clb = (ClassLoaderBox)e.getValue();
                File f = clb.cl.file;
                String name = (String)e.getKey();
                if (clb.users > 0 || t - clb.unusedFrom <= timeout) continue;
                Logger.debug(this.getClass().getName(), "scheduling removal of " + name + (f.isFile() ? " and " + f : ""));
                if (f.isFile()) {
                    this.shutDown.toDelete.add(f);
                }
                i.remove();
            }
        }
        this.shutDown.tryRemoval();
    }

    ClassLoaderManager(File clDir) {
        this.dir = clDir.getAbsoluteFile();
        Logger.debug(this.getClass().getName(), "using: " + this.dir);
        this.shutDown = new ShutdownCLMThread();
        Runtime.getRuntime().addShutdownHook(this.shutDown);
    }
}

