/*
 * Decompiled with CFR 0.152.
 */
package drm.agentbase;

import drm.agentbase.ILogListener;
import java.util.Vector;

public abstract class Logger {
    private static Vector listeners = new Vector();

    private Logger() {
    }

    public static synchronized void addListener(ILogListener l) {
        if (listeners.contains(l)) {
            return;
        }
        listeners.addElement(l);
    }

    public static synchronized void removeListener(ILogListener l) {
        listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int type, String sender, String comment, Throwable thr) {
        Vector vector = listeners;
        synchronized (vector) {
            int i = 0;
            while (i < listeners.size()) {
                ((ILogListener)listeners.elementAt(i)).handleLogMessage(type, sender, comment, thr);
                ++i;
            }
        }
    }

    public static void panic(String sender, String comment, Throwable thr) {
        Logger.log(0, sender, comment, thr);
    }

    public static void error(String sender, String comment, Throwable thr) {
        Logger.log(1, sender, comment, thr);
    }

    public static void warning(String sender, String comment, Throwable thr) {
        Logger.log(2, sender, comment, thr);
    }

    public static void debug(String sender, String comment) {
        Logger.log(3, sender, comment, null);
    }

    public static void info(String sender, String comment) {
        Logger.log(4, sender, comment, null);
    }
}

