/*
 * Decompiled with CFR 0.152.
 */
package drm.agentbase;

import drm.agentbase.Address;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Message
implements Serializable {
    private static final long serialVersionUID = 49323201182294530L;
    Address sender;
    Address recipient;
    String type;
    byte[] content;
    transient Object reply = null;

    public Message(Address sender, Address recipient, String type) {
        if (sender == null) {
            throw new IllegalArgumentException("sender mustn't be null in Message constructor");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("recipient mustn't be null in Message constructor");
        }
        if (type == null) {
            throw new IllegalArgumentException("type mustn't be null in Message constructor");
        }
        this.sender = sender;
        this.recipient = recipient;
        this.type = type;
        this.content = null;
    }

    public Message(Address sender, Address recipient, String type, Object object) throws IOException {
        this(sender, recipient, type);
        if (object == null) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        oos.flush();
        this.content = bos.toByteArray();
    }

    public Address getSender() {
        return this.sender;
    }

    public Address getRecipient() {
        return this.recipient;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getBinary() {
        return this.content;
    }

    public void setReply(Object o) {
        this.reply = o;
    }

    public String toString() {
        String s = "Message\nFrom: " + this.sender + "\nTo: " + this.recipient + "\nSubject: " + this.type + "\nContent: ";
        if (this.content != null) {
            return String.valueOf(s) + this.content;
        }
        return String.valueOf(s) + "null";
    }
}

