/*
 * Decompiled with CFR 0.152.
 */
package drm.agents;

import drm.agentbase.Address;
import drm.agentbase.IAgent;
import drm.agentbase.IBase;
import drm.agentbase.IRequest;
import drm.agentbase.Message;
import drm.agentbase.StaticRequest;
import drm.core.ContributionBox;
import drm.core.IDRM;
import drm.core.NodeContribution;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Agent
implements IAgent {
    private static final long serialVersionUID = 833584182806685860L;
    protected transient IBase base = null;
    protected volatile transient boolean shouldLive = true;
    protected final String name;
    protected final String type;
    protected final String job;
    protected static final int VERSION = 200000;

    private static String randomName() {
        return ("" + Math.random()).substring(2, 9);
    }

    public Agent(String type, String job, String name) {
        if (type == null || job == null) {
            throw new IllegalArgumentException("null argument in agent constructor");
        }
        if (name == null) {
            name = Agent.randomName();
        }
        this.name = String.valueOf(type) + "." + job + "." + name;
        this.job = job;
        this.type = type;
    }

    public void onArrival(Address from, Address to) {
        this.shouldLive = true;
    }

    public void onDestruction() {
        this.shouldLive = false;
    }

    public final String getName() {
        return this.name;
    }

    public final String getJob() {
        return this.job;
    }

    public final String getType() {
        return this.type;
    }

    public final void setBase(IBase b) {
        this.base = b;
    }

    public Address[] getPeerAddresses() {
        Iterator nodes = this.getDRM().getContributions().iterator();
        ArrayList<Address> peers = new ArrayList<Address>();
        while (nodes.hasNext()) {
            ContributionBox cb = (ContributionBox)nodes.next();
            NodeContribution nc = (NodeContribution)cb.contribution;
            Iterator agents = nc.getAgents().iterator();
            while (agents.hasNext()) {
                String name = (String)agents.next();
                if (!name.contains(this.job)) continue;
                peers.add(new Address(cb.contributor.getHost(), cb.contributor.port, name));
            }
        }
        if (peers.size() > 0) {
            return peers.toArray(new Address[peers.size()]);
        }
        return new Address[0];
    }

    public boolean handleMessage(Message m, Object object) {
        if (m.getType().equals("selfTest")) {
            this.selfTest(null);
        } else if (m.getType().equals("getState")) {
            m.setReply(this.getState());
        } else {
            return false;
        }
        return true;
    }

    public final int version() {
        return 200000;
    }

    public final IRequest fireMessage(Address recipient, String type, Object object) {
        try {
            return this.base.fireMessage(new Message(new Address(this.getName()), recipient, type, object));
        }
        catch (IOException e) {
            return new StaticRequest(2, e);
        }
    }

    public final IRequest fireMessage(String recipient, String type, Object object) {
        try {
            return this.base.fireMessage(new Message(new Address(this.getName()), new Address(recipient), type, object));
        }
        catch (IOException e) {
            return new StaticRequest(2, e);
        }
    }

    public final IRequest fireMessage(Address recipient, String type) {
        IRequest r = null;
        try {
            r = this.fireMessage(recipient, type, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public final void suicide() {
        this.base.destroyAgent(this.name);
    }

    public void selfTest(PrintStream output) {
        if (output == null) {
            output = System.out;
        }
        output.println("serial version: 833584182806685860");
        output.println("-- Agent name: " + this.getName());
        output.println("-- job: " + this.job);
        output.println("-- type: " + this.type);
        output.println("-- shouldLive: " + this.shouldLive);
    }

    public final IDRM getDRM() {
        return (IDRM)((Object)this.base);
    }

    public String getState() {
        throw new RuntimeException();
    }

    public String toString() {
        return this.name;
    }

    public abstract void run();
}

