/*
 * Decompiled with CFR 0.152.
 */
package drm.agents;

import drm.agentbase.Address;
import drm.agentbase.Logger;
import drm.agentbase.Message;
import drm.agents.Agent;
import drm.core.Collective;
import drm.core.ContributionBox;
import drm.core.Contributor;
import drm.core.Observer;
import java.io.PrintStream;

public abstract class ContributorAgent
extends Agent
implements Contributor,
Observer {
    static final long serialVersionUID = 3630371562251930132L;
    protected Collective collective = null;
    protected Address root = null;

    public ContributorAgent(String type, String job, String name) {
        super(type, job, name);
    }

    public ContributorAgent(String type, String job, String name, Address root) {
        super(type, job, name);
        this.root = root;
    }

    public final void onArrival(Address from, Address to) {
        super.onArrival(from, to);
        if (this.root != null && this.root.isLocal() && from != null) {
            this.root = new Address(from.getHost(), from.port, this.root.name);
        }
        this.collective = this.collective == null ? new Collective(this.job, (Observer)this, this) : new Collective(this.collective, (Observer)this, (Contributor)this, null);
        this.collective.addPeerAddress(this.root);
        new Thread((Runnable)this.collective, String.valueOf(this.getJob()) + " Collective").start();
    }

    public final void onDestruction() {
        super.onDestruction();
        this.collective.close();
    }

    public boolean handleMessage(Message m, Object object) {
        if (super.handleMessage(m, object)) {
            return true;
        }
        if (m.getType().equals("collectiveUpdate-" + this.job)) {
            return this.collective.handleMessage(m, object);
        }
        Logger.debug(String.valueOf(this.getClass().getName()) + "#handleMessage", String.valueOf(m.getType()) + " received from " + m.getSender());
        return false;
    }

    public Object getContribution() {
        return null;
    }

    public void collectiveUpdated(ContributionBox peer) {
    }

    public Address getRootAddress() {
        if (this.root == null) {
            return null;
        }
        return this.root;
    }

    public void selfTest(PrintStream output) {
        if (output == null) {
            output = System.out;
        }
        super.selfTest(output);
        output.println("-- root: " + this.root);
        output.println("-- collective: " + this.collective);
    }
}

