/*
 * Decompiled with CFR 0.152.
 */
package drm.core;

import drm.agentbase.Address;
import drm.agentbase.Base;
import drm.agentbase.IAgent;
import drm.agentbase.IRequest;
import drm.agentbase.Logger;
import drm.agentbase.Message;
import drm.agentbase.StaticRequest;
import drm.core.Collective;
import drm.core.ContributionBox;
import drm.core.Contributor;
import drm.core.Controller;
import drm.core.IDRM;
import drm.core.NodeCommand;
import drm.core.NodeContribution;
import drm.core.Observer;
import drm.util.StringCollections;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Node
extends Base
implements Observer,
Contributor,
Controller,
IDRM {
    private static final long serialVersionUID = 1L;
    private Collective DRM = null;
    private ContributionBox lastPeer = null;
    private HashSet newCommands = new HashSet();
    private List executedCommands = new Vector();

    public Node(Properties cfg) {
        super(cfg);
    }

    public IRequest launch(String method, final IAgent agent, Object par) {
        if (method != null && method.equals("RANDOM")) {
            return (IRequest)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LaunchThread t = new LaunchThread(agent);
                    t.start();
                    return t;
                }
            });
        }
        return super.launch(method, agent, par);
    }

    public ContributionBox getContribution(String nodeName) {
        if (this.DRM == null) {
            return null;
        }
        return this.DRM.getContribution(nodeName);
    }

    public ContributionBox getNewestContribution() {
        return this.lastPeer;
    }

    public List getContributions() {
        if (this.DRM == null) {
            return Collections.EMPTY_LIST;
        }
        return this.DRM.getContributions();
    }

    public void close() {
        super.close();
        if (this.DRM != null) {
            this.DRM.close();
        }
    }

    public Base.Firewall getFirewall() {
        return new NodeFirewall();
    }

    public boolean handleMessage(Message m, Object object) {
        if (super.handleMessage(m, object)) {
            return true;
        }
        if (m.getType().equals("collectiveUpdate-" + this.getJob())) {
            return this.DRM.handleMessage(m, object);
        }
        if (m.getType().equals("addCommand")) {
            this.newCommands.add(object);
        } else if (m.getType().equals("getInfo")) {
            m.setReply("java.version " + System.getProperty("java.version") + "\nDRM.version " + this.version() + "\nmemory " + Runtime.getRuntime().freeMemory());
        } else if (m.getType().equals("getStatus")) {
            m.setReply("running");
        } else {
            Logger.debug(String.valueOf(this.getClass().getName()) + "#handleMessage", String.valueOf(m.getType()) + " received from " + m.getSender());
            return false;
        }
        return true;
    }

    public String getType() {
        return "Node";
    }

    public void onArrival(Address from, Address to) {
        boolean spy = this.cfg.getProperty("spy", "false").equals("true");
        this.DRM = new Collective(this.group, (Observer)this, (Contributor)(spy ? null : this), (Controller)this);
        new Thread((Runnable)this.DRM, "DRM Collective").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collectiveUpdated(ContributionBox peer) {
        if (peer == null) {
            return;
        }
        this.lastPeer = peer;
        List commands = this.DRM.getCommands();
        int oldSize = this.executedCommands.size();
        List list = commands;
        synchronized (list) {
            Iterator i = commands.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof NodeCommand) || this.executedCommands.contains(o)) continue;
                this.executedCommands.add(o);
            }
        }
        commands = null;
        int i = oldSize;
        while (i < this.executedCommands.size()) {
            this.invokeCommandLocally((NodeCommand)this.executedCommands.get(i));
            ++i;
        }
        while ((long)this.executedCommands.size() > 100L) {
            this.executedCommands.remove(0);
        }
    }

    public Address[] getPeerAddresses() {
        this.addNodes(this.cfg);
        return null;
    }

    public IRequest fireMessage(Address recipient, String type, Object content) {
        try {
            return this.fireMessage(new Message(new Address(this.getName()), recipient, type, content));
        }
        catch (IOException e) {
            return new StaticRequest(2, e);
        }
    }

    public Object getContribution() {
        return new NodeContribution(null, this.getNames());
    }

    public Set getCommands() {
        Set ret = (Set)this.newCommands.clone();
        this.newCommands.clear();
        return ret;
    }

    public void addNodes(Properties cfg) {
        String logSender = String.valueOf(this.getClass().getName()) + "#addNodes";
        Enumeration<?> i = cfg.propertyNames();
        while (i.hasMoreElements()) {
            String tmp = (String)i.nextElement();
            if (!tmp.startsWith("base") && !tmp.startsWith("node")) continue;
            try {
                String addr = cfg.getProperty(tmp);
                if (addr == null || addr.length() == 0) continue;
                addr = addr.trim();
                int port = Integer.parseInt(cfg.getProperty("port", "10101"));
                InetAddress host = null;
                StringTokenizer st = new StringTokenizer(addr, " :");
                if (st.countTokens() > 0) {
                    host = InetAddress.getByName(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    port = Integer.parseInt(st.nextToken());
                }
                Logger.debug(logSender, "checking " + host + ":" + port);
                String n = Base.getBaseName(host, port, this.group, 10000);
                if (n == null) {
                    Logger.error(logSender, host + ":" + port + " is not alive", null);
                    continue;
                }
                if (this.name.equals(n)) continue;
                Address a = new Address(host, port, n);
                Logger.debug(logSender, "adding " + a);
                this.DRM.addPeerAddress(a);
            }
            catch (Exception e) {
                Logger.error(logSender, tmp, e);
            }
        }
    }

    public void invokeCommand(NodeCommand command) {
        this.newCommands.add(command);
    }

    public void invokeCommandLocally(NodeCommand command) {
        switch (command.com) {
            case 0: {
                this.wipeClean((Long)command.pars[0]);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Collective access$0(Node node) {
        return node.DRM;
    }

    private class LaunchThread
    extends Thread
    implements IRequest {
        private final IAgent agent;
        private int status = 0;
        private Throwable thr = null;
        private final long startTime;
        private Address target = null;
        String type = "failed";

        public int getStatus() {
            return this.status;
        }

        public Throwable getThrowable() {
            return this.thr;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Object getInfo(String q) {
            if (q == null) {
                return null;
            }
            if (q.equals("type")) {
                return this.type;
            }
            if (q.equals("address")) {
                if (this.status != 1) {
                    return null;
                }
                if (this.target == null) {
                    return new Address(this.agent.getName());
                }
                return new Address(this.target.getHost(), this.target.port, this.agent.getName());
            }
            return null;
        }

        public LaunchThread(IAgent agent) {
            super("Launch-" + agent.getName());
            this.agent = agent;
            this.startTime = System.currentTimeMillis();
            if (agent.getType().equals("Node")) {
                throw new IllegalArgumentException(String.valueOf(agent.getName()) + " is a node.");
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block23: {
                block20: {
                    block22: {
                        block18: {
                            block19: {
                                Logger.debug(this.getClass().getName(), "Launching " + this.agent);
                                peers = Node.access$0(Node.this).getContributions();
                                try {
                                    try {
                                        pre = String.valueOf(this.agent.getType()) + "." + this.agent.getJob();
                                        if (!StringCollections.containsPrefix(Node.this.getNames(), pre) || peers.size() == 0) {
                                            this.type = "local";
lbl9:
                                            // 2 sources

                                            while (true) {
                                                var5_4 = null;
                                                if (this.thr != null) {
                                                    this.status = 2;
                                                    return;
                                                }
                                                if (this.target != null) break block18;
                                                break block19;
                                                break;
                                            }
                                        }
                                        p = (int)Math.floor(Math.random() * (double)(peers.size() + 1));
                                        peer = null;
                                        if (p < peers.size()) {
                                            peer = (ContributionBox)peers.get(p);
                                        }
                                        if (p == peers.size() || peer.contributor.name.equals(Node.this.name)) {
                                            this.type = "random local";
                                            ** continue;
                                        }
                                        this.type = "random";
                                        this.target = peer.contributor;
                                    }
                                    catch (Throwable e) {
                                        this.thr = e;
                                    }
                                    break block20;
                                }
                                catch (Throwable var6_18) {
                                    var5_5 = null;
                                    if (this.thr != null) {
                                        this.status = 2;
                                        throw var6_18;
                                    }
                                    if (this.target == null) {
                                        Logger.debug(this.getClass().getName(), "Launch type: '" + this.type + "'");
                                        r = Node.this.launch("DIRECT", this.agent, this.target);
                                        this.status = r.getStatus();
                                        this.thr = r.getThrowable();
                                        throw var6_18;
                                    }
                                    Logger.debug(this.getClass().getName(), "Launch type '" + this.type + "' to " + this.target);
                                    r = Node.this.launch("DIRECT", this.agent, this.target);
                                    try {
                                        ((Thread)r).join();
                                    }
                                    catch (Exception var8_14) {
                                        // empty catch block
                                    }
                                    this.status = r.getStatus();
                                    this.thr = r.getThrowable();
                                    throw var6_18;
                                }
                            }
                            Logger.debug(this.getClass().getName(), "Launch type: '" + this.type + "'");
                            r = Node.this.launch("DIRECT", this.agent, this.target);
                            this.status = r.getStatus();
                            this.thr = r.getThrowable();
                            return;
                        }
                        Logger.debug(this.getClass().getName(), "Launch type '" + this.type + "' to " + this.target);
                        r = Node.this.launch("DIRECT", this.agent, this.target);
                        ** try [egrp 2[TRYBLOCK] [5 : 393->404)] { 
lbl62:
                        // 1 sources

                        ((Thread)r).join();
                        break block22;
lbl64:
                        // 1 sources

                        catch (Exception var8_13) {
                            // empty catch block
                        }
                    }
                    this.status = r.getStatus();
                    this.thr = r.getThrowable();
                    return;
                }
                var5_6 = null;
                if (this.thr != null) {
                    this.status = 2;
                    return;
                }
                if (this.target == null) {
                    Logger.debug(this.getClass().getName(), "Launch type: '" + this.type + "'");
                    r = Node.this.launch("DIRECT", this.agent, this.target);
                    this.status = r.getStatus();
                    this.thr = r.getThrowable();
                    return;
                }
                Logger.debug(this.getClass().getName(), "Launch type '" + this.type + "' to " + this.target);
                r = Node.this.launch("DIRECT", this.agent, this.target);
                ** try [egrp 2[TRYBLOCK] [5 : 393->404)] { 
lbl84:
                // 1 sources

                ((Thread)r).join();
                break block23;
lbl86:
                // 1 sources

                catch (Exception var8_15) {
                    // empty catch block
                }
            }
            this.status = r.getStatus();
            this.thr = r.getThrowable();
        }
    }

    private class NodeFirewall
    extends Base.Firewall
    implements IDRM {
        private NodeFirewall() {
            super(Node.this);
        }

        public ContributionBox getContribution(String nodeName) {
            return ((IDRM)((Object)this.b)).getContribution(nodeName);
        }

        public ContributionBox getNewestContribution() {
            return ((IDRM)((Object)this.b)).getNewestContribution();
        }

        public List getContributions() {
            return ((IDRM)((Object)this.b)).getContributions();
        }
    }
}

