/*
 * Decompiled with CFR 0.152.
 */
package drm.core;

import java.io.Serializable;
import java.util.StringTokenizer;

public class NodeCommand
implements Serializable {
    static final long serialVersionUID = -3564369650116231150L;
    byte com;
    Object[] pars = null;
    long quiteUniqueID = System.currentTimeMillis();
    public static final byte CLEANALL = 0;

    public NodeCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        StringTokenizer st = new StringTokenizer(command);
        if (st.countTokens() == 0) {
            throw new IllegalArgumentException("No command in given string '" + command + "'");
        }
        String cname = st.nextToken();
        if (cname.equals("cleanall")) {
            this.com = 0;
            this.pars = new Object[]{new Long(10000L)};
            if (st.hasMoreTokens()) {
                try {
                    this.pars[0] = new Long(st.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if ((Long)this.pars[0] < 0L) {
                    this.pars[0] = new Long(10000L);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown command '" + command + "'");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeCommand)) {
            return false;
        }
        NodeCommand nc = (NodeCommand)o;
        if (nc.com != this.com || nc.quiteUniqueID != this.quiteUniqueID) {
            return false;
        }
        if (nc.pars == null && this.pars == null) {
            return true;
        }
        if (nc.pars == null || this.pars == null || this.pars.length != nc.pars.length) {
            return false;
        }
        int i = 0;
        while (i < this.pars.length) {
            if (!nc.pars[i].equals(this.pars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.com + (int)(this.quiteUniqueID ^ this.quiteUniqueID >>> 32);
    }

    public String toString() {
        String result = "";
        switch (this.com) {
            case 0: {
                result = String.valueOf(result) + "cleanall ";
            }
        }
        if (this.pars != null) {
            int i = 0;
            while (i < this.pars.length) {
                result = String.valueOf(result) + this.pars[i] + " ";
                ++i;
            }
        }
        return result;
    }
}

