/*
 * Decompiled with CFR 0.152.
 */
package drm.server;

import drm.agentbase.Logger;
import drm.core.Node;
import drm.server.ConsoleLogger;
import drm.server.PeriodicRestarter;
import drm.server.ScriptUtils;
import drm.util.ConfigProperties;

public class NakedNode {
    public static volatile Node s = null;
    public static ConfigProperties cfg = null;
    public static ConsoleLogger cl = new ConsoleLogger();

    private static void loadcfg(String[] args) {
        cfg = new ConfigProperties(args, null);
        if (cfg.getProperty("group", "default").equals("default")) {
            try {
                cfg.loadSystemResource("drm/resources/AddressList.properties");
            }
            catch (Throwable e) {
                Logger.error("NakedNode", "loading address list", e);
            }
        }
    }

    public static void main(String[] args) {
        int port;
        Logger.addListener(cl);
        NakedNode.cl.verbosity = 3;
        NakedNode.loadcfg(args);
        NakedNode.cl.verbosity = Integer.parseInt(cfg.getProperty("verbosity", "10"));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (s != null) {
                    s.close();
                }
            }
        });
        long startTime = -1L;
        try {
            startTime = Long.parseLong(cfg.getProperty("startTime", "-1"));
        }
        catch (Throwable t) {
            Logger.panic("NakedNode", "config value startTime", t);
            System.exit(1);
        }
        if (startTime - System.currentTimeMillis() > 0L) {
            try {
                Logger.debug("NakedNode", "waiting until " + startTime);
                Thread.sleep(startTime - System.currentTimeMillis());
            }
            catch (InterruptedException t) {
                // empty catch block
            }
        }
        if ((s = new Node(cfg)).goOnline(port = Integer.parseInt(cfg.getProperty("port", "10101")), port + 10) < 0) {
            Logger.panic("NakedNode", "Could not go online", null);
            s.close();
            System.exit(1);
        }
        long lifeTime = -1L;
        try {
            lifeTime = Long.parseLong(cfg.getProperty("lifeTime", "-1"));
        }
        catch (Throwable t) {
            Logger.panic("NakedNode", "config value lifeTime", t);
            s.close();
            System.exit(1);
        }
        long intv = -1L;
        try {
            intv = Long.parseLong(cfg.getProperty("restartInterval", "-1"));
        }
        catch (Throwable t) {
            Logger.panic("NakedNode", "config value restartInterval", t);
            s.close();
            System.exit(1);
        }
        PeriodicRestarter prs = new PeriodicRestarter(intv);
        prs.start();
        try {
            Thread.sleep(30000L);
            ScriptUtils.startAllScripts(cfg, "runClass", s);
        }
        catch (Throwable t) {
            Logger.error("NakedNode", "problems with starting configured tasks", t);
        }
        if (lifeTime > 0L) {
            try {
                Thread.sleep(lifeTime * 1000L);
                Logger.debug("NakedNode", "Timeout " + lifeTime + "s elapsed, exiting");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            s.close();
            System.exit(1);
        }
    }
}

