/*
 * Decompiled with CFR 0.152.
 */
package drm.server;

import drm.agentbase.Logger;
import drm.core.Node;
import drm.server.NakedNode;
import java.util.Random;

class PeriodicRestarter
extends Thread {
    private long interval = 0L;

    public PeriodicRestarter(long interval) {
        super("PeriodicRestarter(" + interval + ")");
        this.interval = interval;
    }

    public void run() {
        if (NakedNode.s == null) {
            throw new IllegalArgumentException("No node");
        }
        if (this.interval <= 0L) {
            return;
        }
        Random rnd = new Random();
        while (true) {
            int d;
            if ((d = (int)((double)this.interval + (double)this.interval * rnd.nextGaussian() / 2.0)) <= 0) {
                continue;
            }
            try {
                Thread.sleep(d * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.debug(this.getClass().getName(), "Timeout " + d + "s elapsed, restarting");
            NakedNode.s.close();
            NakedNode.s = new Node(NakedNode.cfg);
            int port = Integer.parseInt(NakedNode.cfg.getProperty("port", "10101"));
            if (NakedNode.s.goOnline(port, port + 10) >= 0) continue;
            Logger.panic("NakedNode", "Could not go online", null);
            NakedNode.s.close();
            System.exit(1);
        }
    }
}

