/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.ConnectionDialog;
import dream.gui.Console;
import dream.gui.ConsoleControl;
import dream.gui.Control;
import dream.gui.StatusPrinter;
import dream.util.PropertyHandler;
import drm.agentbase.Logger;
import drm.core.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ConnectionDialog
extends JDialog
implements StatusPrinter {
    private Properties connectProps = null;
    private ConnectTableModel meshModel = new ConnectTableModel();
    private ConnectTableModel otherNodesModel = new ConnectTableModel();
    private ConnectCellRenderer otherRenderer = new ConnectCellRenderer();
    private Console parent = null;
    private PropertyHandler propHandler = null;
    private static int MIN_SIZE_X = 400;
    private static int MIN_SIZE_Y = 350;
    public static String DEFAULT_GROUP = "default";
    private int numOfAliveThreads = 0;
    private JLabel defaultDreamLabel;
    private JScrollPane jScrollPane1;
    private JButton testAvailButton;
    private JMenuItem jMenuItem2;
    private JButton deleteButton;
    private JPanel bottomButtonPanel;
    private JLabel statusLabel;
    private JPanel jPanel3;
    private JPanel horizontalSepPanel1;
    private JSplitPane jSplitPane1;
    private JPopupMenu jPopupMenu2;
    private JMenuItem deleteItem;
    private JPanel jPanel5;
    private JPanel addDelPanel;
    private JTextField meshName;
    private JLabel knownDreamsLabel;
    private JScrollPane jScrollPane2;
    private JButton cancelButton;
    private JButton saveButton;
    private JTextField newMachineText;
    private JSeparator jSeparator1;
    private JTable otherMachineTable;
    private JPanel verticalSepPanel1;
    private JTable meshTable;
    private JLabel jLabel6;
    private JButton addButton;
    private JButton connectButton;
    private JProgressBar jProgressBar1;
    private JPopupMenu jPopupMenu1;
    private JLabel knownMachinesLabel;
    private JTabbedPane jTabbedPane1;

    public ConnectionDialog(Console parent, boolean modal, PropertyHandler propHandler) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.propHandler = propHandler;
        this.setName("connectionDialog");
        this.connectProps = propHandler.fetch(ConsoleControl.networkPropID);
        if (this.connectProps == null) {
            this.connectProps = new Properties();
        }
        this.initComponents();
        this.configureMeshesTable(this.meshTable, this.meshModel);
        this.configureNodesTable(this.otherMachineTable, this.otherNodesModel);
        this.setTextFields(this.connectProps);
        if (this.meshModel.getRowCount() == 0) {
            Vector<String> toInsert = new Vector<String>();
            toInsert.add(DEFAULT_GROUP);
            this.meshModel.addRow(toInsert);
        }
        if (this.meshName.getText().length() < 1) {
            this.meshName.setText(DEFAULT_GROUP);
        }
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
        this.initPopups();
        this.init();
    }

    public void init() {
        new Thread(new Runnable(){

            public void run() {
                ConnectionDialog.this.liveChecker(ConnectionDialog.this.otherNodesModel, ConnectionDialog.this.meshModel);
            }
        }).start();
    }

    public void initPopups() {
        PopupListener popupListener = new PopupListener();
        this.otherMachineTable.addMouseListener(popupListener);
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.deleteItem = new JMenuItem();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItem2 = new JMenuItem();
        this.bottomButtonPanel = new JPanel();
        this.connectButton = new JButton();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.knownDreamsLabel = new JLabel();
        this.knownMachinesLabel = new JLabel();
        this.verticalSepPanel1 = new JPanel();
        this.horizontalSepPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.otherMachineTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.meshTable = new JTable();
        this.defaultDreamLabel = new JLabel();
        this.meshName = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jSplitPane1 = new JSplitPane();
        this.jProgressBar1 = new JProgressBar();
        this.statusLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.addDelPanel = new JPanel();
        this.newMachineText = new JTextField();
        this.addButton = new JButton();
        this.jPanel3 = new JPanel();
        this.deleteButton = new JButton();
        this.jPanel5 = new JPanel();
        this.testAvailButton = new JButton();
        this.jLabel6 = new JLabel();
        this.deleteItem.setText("delete");
        this.deleteItem.setToolTipText("removes this item from the table");
        this.deleteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.deleteItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.deleteItem);
        this.jMenuItem2.setText("Item2");
        this.jPopupMenu2.add(this.jMenuItem2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("DREAM Connection Dialog");
        this.setName("connectionDialog");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ConnectionDialog.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectionDialog.this.closeDialog(evt);
            }
        });
        this.bottomButtonPanel.setLayout(new GridBagLayout());
        this.connectButton.setIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-default-16.gif")));
        this.connectButton.setText("modify");
        this.connectButton.setToolTipText("leave dialog, save data and modify connection (restart local nodes)");
        this.connectButton.setAlignmentY(0.0f);
        this.connectButton.setHorizontalAlignment(2);
        this.connectButton.setHorizontalTextPosition(4);
        this.connectButton.setMargin(new Insets(0, 14, 0, 14));
        this.connectButton.setRolloverEnabled(true);
        this.connectButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-rollover-16.gif")));
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.connectButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.bottomButtonPanel.add((Component)this.connectButton, gridBagConstraints);
        this.saveButton.setText("save only");
        this.saveButton.setToolTipText("leave dialog without modifying connection, but save data");
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setMargin(new Insets(0, 14, 0, 14));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.bottomButtonPanel.add((Component)this.saveButton, gridBagConstraints);
        this.cancelButton.setText("cancel");
        this.cancelButton.setToolTipText("leave the dialog without saving data");
        this.cancelButton.setHorizontalTextPosition(0);
        this.cancelButton.setMargin(new Insets(0, 14, 0, 14));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.bottomButtonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.bottomButtonPanel, gridBagConstraints);
        this.knownDreamsLabel.setText("known drm groups:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.knownDreamsLabel, gridBagConstraints);
        this.knownMachinesLabel.setText("all known machines:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.knownMachinesLabel, gridBagConstraints);
        this.verticalSepPanel1.setMinimumSize(new Dimension(6, 6));
        this.verticalSepPanel1.setPreferredSize(new Dimension(6, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        this.getContentPane().add((Component)this.verticalSepPanel1, gridBagConstraints);
        this.horizontalSepPanel1.setMinimumSize(new Dimension(6, 6));
        this.horizontalSepPanel1.setPreferredSize(new Dimension(6, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.horizontalSepPanel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.otherMachineTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 3.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane2.setToolTipText("one click selects this group as default, double click  modifies the connection to enter that group instantly");
        this.meshTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ConnectionDialog.this.meshTableMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.meshTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.defaultDreamLabel.setText("default drm group:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.defaultDreamLabel, gridBagConstraints);
        this.meshName.setText("default");
        this.meshName.setToolTipText("enter a new dream here or select from below");
        this.meshName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.drmgroupActionPerformed(evt);
            }
        });
        this.meshName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ConnectionDialog.this.meshNameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.meshName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 3, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(4);
        this.jSplitPane1.setAlignmentX(0.5f);
        this.jSplitPane1.setAlignmentY(0.5f);
        this.jSplitPane1.setMinimumSize(new Dimension(83, 19));
        this.jSplitPane1.setPreferredSize(new Dimension(83, 19));
        this.jProgressBar1.setToolTipText("shows connection progress");
        this.jProgressBar1.setBorder(new CompoundBorder(new EmptyBorder(new Insets(0, 0, 0, 0)), new LineBorder(new Color(0, 0, 0))));
        this.jProgressBar1.setMaximumSize(new Dimension(0, 0));
        this.jProgressBar1.setMinimumSize(new Dimension(0, 0));
        this.jProgressBar1.setPreferredSize(new Dimension(100, 15));
        this.jProgressBar1.setAutoscrolls(true);
        this.jSplitPane1.setLeftComponent(this.jProgressBar1);
        this.statusLabel.setText("status: ready.");
        this.statusLabel.setAlignmentX(0.5f);
        this.statusLabel.setBorder(new EmptyBorder(new Insets(0, 4, 0, 4)));
        this.statusLabel.setMaximumSize(new Dimension(77, 15));
        this.statusLabel.setMinimumSize(new Dimension(77, 15));
        this.statusLabel.setPreferredSize(new Dimension(77, 15));
        this.statusLabel.setAutoscrolls(true);
        this.statusLabel.setHorizontalTextPosition(10);
        this.jSplitPane1.setRightComponent(this.statusLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.addDelPanel.setLayout(new GridBagLayout());
        this.newMachineText.setToolTipText("insert machine name here and click add (or press carriage return)");
        this.newMachineText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.jTextField1ActionPerformed(evt);
                ConnectionDialog.this.jTextField1ActionPerforme(evt);
                ConnectionDialog.this.newMachineTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.addDelPanel.add((Component)this.newMachineText, gridBagConstraints);
        this.addButton.setText("add this machine");
        this.addButton.setToolTipText("add the machine in the text field above to the known machines table");
        this.addButton.setMargin(new Insets(0, 10, 0, 10));
        this.addButton.setMaximumSize(new Dimension(0, 0));
        this.addButton.setMinimumSize(new Dimension(50, 23));
        this.addButton.setPreferredSize(new Dimension(50, 23));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.addDelPanel.add((Component)this.addButton, gridBagConstraints);
        this.jPanel3.setMinimumSize(new Dimension(6, 6));
        this.jPanel3.setPreferredSize(new Dimension(6, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.addDelPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.deleteButton.setText("delete selected machine(s)");
        this.deleteButton.setToolTipText("select machines first, then press button");
        this.deleteButton.setMargin(new Insets(0, 10, 0, 10));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.addDelPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.jTabbedPane1.addTab("add/del machines", null, this.addDelPanel, "");
        this.jPanel5.setLayout(new GridBagLayout());
        this.testAvailButton.setText("test availability");
        this.testAvailButton.setToolTipText("performs a network availability test on the named machines");
        this.testAvailButton.setMargin(new Insets(0, 10, 0, 10));
        this.testAvailButton.setPreferredSize(new Dimension(50, 23));
        this.testAvailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionDialog.this.testAvailButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.testAvailButton, gridBagConstraints);
        this.jTabbedPane1.addTab("test network", null, this.jPanel5, "");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.4;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jLabel6.setText("actions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(400, 300));
        this.setLocation((screenSize.width - 400) / 2, (screenSize.height - 300) / 2);
    }

    private void meshNameFocusLost(FocusEvent evt) {
        this.drmgroupActionPerformed(null);
    }

    private void deleteItemActionPerformed(ActionEvent evt) {
        JMenuItem menu = (JMenuItem)evt.getSource();
        JPopupMenu firedAt = (JPopupMenu)menu.getParent();
        Point pos = (Point)firedAt.getClientProperty("lastLocation");
        JTable tab = (JTable)firedAt.getInvoker();
        ((DefaultTableModel)tab.getModel()).removeRow(tab.rowAtPoint(pos));
    }

    private void formComponentResized(ComponentEvent evt) {
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteSelected(this.otherMachineTable);
    }

    private void meshTableMouseClicked(MouseEvent evt) {
        int index = this.meshTable.rowAtPoint(evt.getPoint());
        if (index > -1) {
            this.saveDefaultToKnown();
            this.meshName.setText((String)this.meshTable.getModel().getValueAt(index, 0));
        }
        if (evt.getClickCount() == 2 && index > -1) {
            this.connectButtonActionPerformed(new ActionEvent(this.meshTable, 0, "connect"));
        }
    }

    private void testAvailButtonActionPerformed(ActionEvent evt) {
        this.liveChecker(this.otherNodesModel, this.meshModel);
    }

    private void otherMachineListMouseClicked(MouseEvent evt) {
    }

    private void newMachineTextActionPerformed(ActionEvent evt) {
        this.addButtonActionPerformed(evt);
    }

    private void jTextField1ActionPerforme(ActionEvent evt) {
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String newOther = this.newMachineText.getText().trim();
        Object[] newRow = new Object[3];
        boolean found = false;
        newRow[1] = "";
        newRow[2] = new Boolean(false);
        if (newOther.length() > 0) {
            int row = 0;
            while (row < this.otherNodesModel.getRowCount()) {
                if (newOther.compareTo((String)this.otherNodesModel.getValueAt(row, 0)) == 0) {
                    found = true;
                }
                ++row;
            }
            if (!found) {
                newRow[0] = newOther;
                this.otherNodesModel.addRow(newRow);
                this.liveChecker(this.otherNodesModel, this.meshModel);
            }
        }
    }

    private void meshListMouseClicked(MouseEvent evt) {
    }

    private void drmgroupActionPerformed(ActionEvent evt) {
        String newMesh = this.getMeshName();
        if (newMesh != null && !this.meshModel.getColumnValues(0).contains(newMesh)) {
            Vector<String> toInsert = new Vector<String>();
            toInsert.add(newMesh);
            this.meshModel.addRow(toInsert);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.updateProps(this.connectProps);
        this.parent.connectModAction.setEnabled(true);
        this.shutdown();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.parent.connectModAction.setEnabled(true);
        this.shutdown();
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        Properties startProps = new Properties();
        this.updateProps(this.connectProps);
        startProps.setProperty("port", this.connectProps.getProperty("port", "10101"));
        startProps.setProperty("group", this.connectProps.getProperty("group", "default"));
        this.packToProp(startProps, this.otherNodesModel, "base.", "", true);
        this.parent.doConnect(startProps, true, null);
        this.parent.connectAction.setConnect(false);
        this.shutdown();
    }

    private void closeDialog(WindowEvent evt) {
        this.parent.connectModAction.setEnabled(true);
        this.shutdown();
    }

    private void configureNodesTable(JTable table, DefaultTableModel tabMod) {
        TableColumn column = null;
        table.setModel(tabMod);
        tabMod.addColumn("machine");
        tabMod.addColumn("dream");
        tabMod.addColumn("alive");
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(150);
        column.setCellRenderer(this.otherRenderer);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
        column.setCellRenderer(this.otherRenderer);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(30);
        column.setCellRenderer(this.otherRenderer);
    }

    private void configureMeshesTable(JTable table, DefaultTableModel meshesMod) {
        Object column = null;
        table.setModel(meshesMod);
        meshesMod.addColumn("dream");
    }

    private void deleteSelected(JTable table) {
        ListSelectionModel rowSM = table.getSelectionModel();
        int min = rowSM.getMinSelectionIndex();
        int max = rowSM.getMaxSelectionIndex();
        ConnectTableModel tabModel = (ConnectTableModel)table.getModel();
        if (min >= 0) {
            int i = min;
            while (i <= rowSM.getMaxSelectionIndex()) {
                if (rowSM.isSelectedIndex(i)) {
                    tabModel.removeRow(i);
                    --i;
                }
                ++i;
            }
        }
    }

    private void liveChecker(DefaultTableModel machineTab, DefaultTableModel meshTab) {
        InetAddress newHost = null;
        int port = 0;
        int updateTimeout = Integer.parseInt(this.connectProps.getProperty("aliveTimeout", "5000"));
        if (this.aliveTerminated() < 0) {
            return;
        }
        int meshes = meshTab.getRowCount();
        int nodes = machineTab.getRowCount();
        if (nodes > 0 && meshes > 0) {
            try {
                Control.installProgressTimer(this, this.jProgressBar1, this.statusLabel, updateTimeout + 1000, false, this.getClass().getMethod("aliveTerminated", null), this, null, null, 0, "Machine availability test started.", "Machine availability test successfully finished.", "Machine availability test finished.", "Network error during availability test, aborted.", Integer.parseInt(this.connectProps.getProperty("clearDelay", "-1")), "status: ready.");
            }
            catch (Exception ex) {
                Logger.warning((String)this.getClass().getName(), (String)"during installProgressTimer ", (Throwable)ex);
            }
            int n = 0;
            while (n < nodes) {
                machineTab.setValueAt("", n, 1);
                machineTab.setValueAt(new Boolean(false), n, 2);
                ++n;
            }
            int m = 0;
            while (m < meshes) {
                int i = 0;
                while (i < nodes) {
                    newHost = null;
                    String nodeName = (String)machineTab.getValueAt(i, 0);
                    String meshName = (String)meshTab.getValueAt(m, 0);
                    int nameLen = nodeName.length();
                    int namePart = nodeName.indexOf(":");
                    if (namePart > 0) {
                        try {
                            newHost = InetAddress.getByName(nodeName.substring(0, namePart));
                        }
                        catch (UnknownHostException ex) {
                            newHost = null;
                        }
                        port = Integer.parseInt(nodeName.substring(namePart + 1, nameLen));
                    }
                    if (newHost != null) {
                        class MachineChecker
                        extends Thread {
                            InetAddress target;
                            String mesh;
                            int portNo;
                            int timeout;
                            int tableRow;
                            int aliveCol;
                            int meshCol;
                            private final /* synthetic */ DefaultTableModel val$machineTab;
                            private final /* synthetic */ ConnectionDialog this$0;

                            MachineChecker(ConnectionDialog this$0, InetAddress adr, int p, String meshName, int timeoutMs, int row, int aliveColumn, int meshColumn, DefaultTableModel val$machineTab) {
                                this.this$0 = this$0;
                                this.val$machineTab = val$machineTab;
                                this.target = null;
                                this.mesh = null;
                                this.portNo = 0;
                                this.timeout = 0;
                                this.tableRow = 0;
                                this.aliveCol = 4000000;
                                this.meshCol = 4000000;
                                this.target = adr;
                                this.portNo = p;
                                this.mesh = meshName;
                                this.timeout = timeoutMs;
                                this.tableRow = row;
                                this.aliveCol = aliveColumn;
                                this.meshCol = meshColumn;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                String answer = Node.getBaseName((InetAddress)this.target, (int)this.portNo, (String)this.mesh, (int)this.timeout);
                                if (answer != null) {
                                    DefaultTableModel defaultTableModel = this.val$machineTab;
                                    synchronized (defaultTableModel) {
                                        this.val$machineTab.setValueAt(this.mesh, this.tableRow, this.meshCol);
                                        this.val$machineTab.setValueAt(new Boolean(true), this.tableRow, this.aliveCol);
                                    }
                                    Logger.debug((String)(this.getClass().getName() + "#run"), (String)("target " + this.target + ", asked for group: " + this.mesh + ", returns: " + answer));
                                }
                                ConnectionDialog.access$2010(this.this$0);
                            }
                        }
                        MachineChecker checkOne = new MachineChecker(this, newHost, port, meshName, updateTimeout, i, 2, 1, machineTab);
                        ++this.numOfAliveThreads;
                        checkOne.start();
                    }
                    ++i;
                }
                ++m;
            }
        }
    }

    public int aliveTerminated() {
        return -this.numOfAliveThreads;
    }

    private void shutdown() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * Unable to fully structure code
     */
    private void unpackToTable(Properties props, ConnectTableModel target, String baseString, String appendString, Object[] template) {
        newElem = null;
        request = null;
        counter = 1;
        firstCol = template[0];
        if (template.length == target.getColumnCount()) ** GOTO lbl12
        System.err.println(this.getClass() + ".unpackToTable(): invalid template cardinality");
        return;
lbl-1000:
        // 1 sources

        {
            if (newElem.compareTo("") != 0 && !target.getColumnValues(0).contains(newElem)) {
                template[0] = newElem;
                target.addRow(template);
            }
            ++counter;
lbl12:
            // 2 sources

            ** while ((newElem = props.getProperty((String)(baseString + String.valueOf((int)counter) + appendString))) != null)
        }
lbl13:
        // 1 sources

        target.buildupRows = --counter;
        template[0] = firstCol;
    }

    private void packToProp(Properties props, ConnectTableModel target, String baseString, String appendString, boolean onlyAlive) {
        int rowWritten = 1;
        int rows = target.getRowCount();
        Set<Object> oldKeys = props.keySet();
        Vector<String> toDelete = new Vector<String>();
        if (oldKeys != null) {
            Iterator<Object> keyIt = oldKeys.iterator();
            while (keyIt.hasNext()) {
                String propName = (String)keyIt.next();
                if (!propName.startsWith(baseString)) continue;
                toDelete.add(propName);
            }
            int i = 0;
            while (i < toDelete.size()) {
                props.remove((String)toDelete.get(i));
                ++i;
            }
        }
        int counter = 0;
        while (counter < rows) {
            if (!onlyAlive || ((Boolean)target.getValueAt(counter, 2)).booleanValue()) {
                props.setProperty(baseString + String.valueOf(rowWritten) + appendString, (String)target.getValueAt(counter, 0));
                ++rowWritten;
            }
            ++counter;
        }
    }

    private void saveDefaultToKnown() {
        String defaultMesh = this.getMeshName();
        if (defaultMesh != null && !this.meshModel.getColumnValues(0).contains(defaultMesh)) {
            Vector<String> toInsert = new Vector<String>();
            toInsert.add(defaultMesh);
            this.meshModel.addRow(toInsert);
        }
    }

    private String getMeshName() {
        String connectMesh = this.meshName.getText();
        String answer = null;
        if (connectMesh != null && (connectMesh = connectMesh.trim()).length() > 0) {
            answer = connectMesh;
        }
        return answer;
    }

    private void updateProps(Properties confProps) {
        String connectMesh = null;
        connectMesh = this.getMeshName();
        if (connectMesh != null) {
            this.connectProps.setProperty("group", connectMesh);
        }
        this.packToProp(confProps, this.otherNodesModel, "base.", "", false);
        this.packToProp(confProps, this.meshModel, "knownMesh.", "", false);
    }

    private void setTextFields(Properties confProps) {
        if (confProps != null) {
            this.meshName.setText(confProps.getProperty("group"));
            this.unpackToTable(confProps, this.meshModel, "knownMesh.", "", new Object[]{""});
            this.unpackToTable(confProps, this.otherNodesModel, "base.", "", new Object[]{"", "", new Boolean(false)});
            this.unpackToTable(this.propHandler.fetch(ConsoleControl.addressListID), this.otherNodesModel, "base.sysresource.", "", new Object[]{"", "", new Boolean(false)});
        }
    }

    public String getDefaultMessage() {
        return "Status: ready.";
    }

    public String getStatusMessage() {
        return this.statusLabel.getText();
    }

    public void printStatusMessage(String message) {
        int clearDelay = 0;
        try {
            clearDelay = Integer.parseInt(this.propHandler.getProperty("clearDelay", "0"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        Control.setStatus(this, this.statusLabel, message, clearDelay);
    }

    static /* synthetic */ int access$2010(ConnectionDialog x0) {
        return x0.numOfAliveThreads--;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ConnectionDialog.this.jPopupMenu1.putClientProperty("lastLocation", e.getPoint());
                ConnectionDialog.this.jPopupMenu1.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ConnectTableModel
    extends DefaultTableModel {
        public int buildupRows = -1;

        ConnectTableModel() {
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Collection getColumnValues(int column) {
            Vector<Object> answer = new Vector<Object>();
            int rows = this.getRowCount();
            if (column >= 0 && column < this.getColumnCount()) {
                int row = 0;
                while (row < rows) {
                    answer.add(this.getValueAt(row, column));
                    ++row;
                }
            }
            return answer;
        }
    }

    class ConnectCellRenderer
    extends DefaultTableCellRenderer {
        Color defaultFore = new Color(0.15f, 0.3f, 0.15f);
        Color defaultBack = new Color(0.9f, 0.95f, 0.9f);
        DefaultTableCellRenderer defRenderer = new DefaultTableCellRenderer();
        Icon conRollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-rollover-16.gif"));
        Icon disRollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/disconnect-rollover-16.gif"));

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel answer = this;
            String nodeAdr = (String)table.getModel().getValueAt(row, 0);
            if (ConnectionDialog.this.propHandler.fetch(ConsoleControl.addressListID).containsValue(nodeAdr)) {
                if (!isSelected) {
                    this.setBackground(this.defaultBack);
                    this.setForeground(this.defaultFore);
                } else {
                    this.setBackground(this.defaultFore);
                    this.setForeground(this.defaultBack);
                }
                this.setToolTipText("this is a default address and cannot be changed");
            } else {
                JLabel renderComp = (JLabel)this.defRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderComp.setToolTipText("right click gives you a context menu");
                answer = renderComp;
            }
            if (column == 0) {
                answer.setHorizontalAlignment(2);
            } else {
                answer.setHorizontalAlignment(0);
            }
            if (value instanceof Boolean) {
                answer.setText(null);
                if (((Boolean)value).booleanValue()) {
                    answer.setIcon(this.conRollIcon);
                } else {
                    answer.setIcon(this.disRollIcon);
                }
            } else {
                answer.setIcon(null);
            }
            return answer;
        }
    }
}

