/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.StatusPrinter;
import dream.gui.tasks.ConsoleTask;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class ConsoleTaskHandler {
    private Hashtable taskList = new Hashtable();
    private String activeTask = null;
    private Color activeOriginalBackground = null;
    private JPanel taskPanel = null;
    private JPanel buttonPanel = null;
    private GridBagConstraints gConstraints = null;

    public ConsoleTaskHandler(JPanel taskViewer, JPanel buttonViewer, JPanel toolPanel, JMenuBar menuBar) {
        this.taskPanel = taskViewer;
        this.buttonPanel = buttonViewer;
        this.gConstraints = new GridBagConstraints();
        this.gConstraints.gridx = 0;
        this.gConstraints.fill = 2;
        this.gConstraints.weightx = 1.0;
        this.gConstraints.gridy = 1;
    }

    public JComponent getParentComponent() {
        return this.taskPanel;
    }

    public void addTask(ConsoleTask task, boolean setActive) {
        final ConsoleTaskHandler taskHandler = this;
        final String taskLabel = task.getLabelText();
        if ((TaskDefinition)this.taskList.get(taskLabel) == null) {
            Icon icon = task.getIcon(0);
            JButton taskButton = new JButton(taskLabel, icon);
            taskButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    taskHandler.setActiveTask(taskLabel);
                }
            });
            if (task.getTooltip() != null) {
                taskButton.setToolTipText(task.getTooltip());
            }
            TaskDefinition tDef = new TaskDefinition(task, taskButton, task.getVisual());
            this.gConstraints.gridy = -1;
            this.buttonPanel.add(taskButton, this.gConstraints, 0);
            this.taskList.put(task.getLabelText(), tDef);
            if (this.taskList.size() == 0 || setActive) {
                task.setConsoleTaskHandler(this);
                this.setActiveTask(task.getLabelText());
            }
        }
    }

    public void setActiveTask(ConsoleTask task) {
        this.setActiveTask(task.getLabelText());
    }

    public void setActiveTask(String labelText) {
        if (this.activeTask != null && this.activeTask.equals(labelText)) {
            return;
        }
        TaskDefinition activeDef = (TaskDefinition)this.taskList.get(labelText);
        if (activeDef != null) {
            if (this.activeTask != null) {
                TaskDefinition lastActive = (TaskDefinition)this.taskList.get(this.activeTask);
                lastActive.t.onPassive();
                lastActive.v.setVisible(false);
                lastActive.b.setBackground(this.activeOriginalBackground);
                this.taskPanel.remove(lastActive.v);
                this.taskPanel.revalidate();
            }
            this.activeTask = activeDef.t.getLabelText();
            activeDef.t.onActive();
            this.activeOriginalBackground = activeDef.b.getBackground();
            activeDef.b.setBackground(new Color(1.0f, 0.8f, 0.5f));
            this.taskPanel.add(activeDef.v);
            activeDef.v.setVisible(true);
            this.taskPanel.revalidate();
        }
    }

    public void removeTask(String labelText) {
    }

    public ConsoleTask getTask(String labelText) {
        TaskDefinition tDef = (TaskDefinition)this.taskList.get(labelText);
        if (tDef != null) {
            return tDef.t;
        }
        return null;
    }

    public static void printStatusMessage(ConsoleTask task, String message) {
        JComponent taskComponent = task.getConsoleTaskHandler().getParentComponent();
        Container root = taskComponent.getTopLevelAncestor();
        if (root instanceof StatusPrinter) {
            ((StatusPrinter)((Object)root)).printStatusMessage(message);
        }
    }

    class TaskDefinition {
        ConsoleTask t = null;
        JButton b = null;
        JComponent v = null;
        Icon defaultIcon = null;
        Icon rolloverIcon = null;

        TaskDefinition(ConsoleTask task, JButton taskButton, JComponent visual) {
            this.t = task;
            this.b = taskButton;
            this.v = visual;
        }
    }
}

