/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.Control;
import dream.gui.StatusPrinter;
import dream.util.PropertyHandler;
import drm.agentbase.Logger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class Control {
    protected String currentDir = ".";
    protected Runtime run = Runtime.getRuntime();
    public static PropertyHandler propHandler = PropertyHandler.getDefaultHandler();
    public static final String OWNED_PROP_KEY = "ownedBy";
    public static final String OWNERS_KEY = "numOfOwners";
    public static final String userHome = System.getProperty("user.home");
    public static final String userDreamPath = userHome + File.separator + ".dream";

    protected Control() {
    }

    public static void setStatus(StatusPrinter caller, JLabel statusLabel, String newStatus) {
        final String statusText = newStatus;
        final JLabel label = statusLabel;
        Runnable updateLabel = new Runnable(){

            public void run() {
                label.setText(statusText);
                label.repaint();
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(updateLabel);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            label.setText(statusText);
            label.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setStatus(final StatusPrinter caller, JLabel statusLabel, String newStatus, int timeout) {
        String oldStat;
        final JLabel status = statusLabel;
        boolean ownerCount = false;
        JLabel jLabel = status;
        synchronized (jLabel) {
            Control.setStatus(caller, statusLabel, newStatus);
            Integer oc = (Integer)status.getClientProperty(OWNERS_KEY);
            if (oc == null) {
                oc = new Integer(1);
                oldStat = statusLabel.getText();
            } else {
                oc = new Integer(oc + 1);
                oldStat = caller.getDefaultMessage();
            }
            status.putClientProperty(OWNERS_KEY, oc);
        }
        if (timeout > 0) {
            Timer clearTimer = new Timer(timeout, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent evt) {
                    JLabel jLabel = status;
                    synchronized (jLabel) {
                        int owners = (Integer)status.getClientProperty(Control.OWNERS_KEY);
                        if (owners == 1) {
                            Control.setStatus(caller, status, oldStat);
                        }
                        status.putClientProperty(Control.OWNERS_KEY, new Integer(owners - 1));
                    }
                }
            });
            clearTimer.setRepeats(false);
            clearTimer.start();
        }
    }

    public static void setParentStatus(Component comp, String message) {
        Container parent = comp.getParent();
        if (parent instanceof StatusPrinter) {
            ((StatusPrinter)((Object)parent)).printStatusMessage(message);
        }
    }

    public static void recurseSetStatus(Component comp, String message) {
        if (comp instanceof StatusPrinter) {
            ((StatusPrinter)((Object)comp)).printStatusMessage(message);
        }
        Control.setParentStatus(comp, message);
    }

    public static void ensureSize(Component comp, int minWidth, int minHeight) {
        boolean callSetSize = false;
        if (comp == null) {
            return;
        }
        Dimension dim = comp.getSize();
        if (dim.width < minWidth) {
            dim.width = minWidth;
            callSetSize = true;
        }
        if (dim.height < minHeight) {
            dim.height = minHeight;
            callSetSize = true;
        }
        if (callSetSize) {
            comp.setSize(dim);
        }
    }

    public static void installProgressTimer(final StatusPrinter caller, final JProgressBar progBar, final JLabel status, final int timeout, final boolean allowMoreTime, final Method isTerminated, final Object invokeOn, final Properties props, final String setProperty, final int mixWeight, final String startMessage, final String successMessage, final String timeoutMessage, final String failureMessage, final int clearDelay, final String clearingMessage) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Logger.debug((String)"dream.gui.Control#installProgressTimer", (String)"waiting for progress bar lock.");
                JProgressBar jProgressBar = progBar;
                synchronized (jProgressBar) {
                    Logger.debug((String)"dream.gui.Control#installProgressTimer", (String)"entering (synchronized on progress bar).");
                    if (progBar.getClientProperty(Control.OWNED_PROP_KEY) != null) {
                        try {
                            Logger.debug((String)"dream.gui.Control", (String)"waiting on progress bar.");
                            progBar.wait();
                        }
                        catch (InterruptedException ex) {
                            System.err.println(ex);
                        }
                    }
                    progBar.setStringPainted(true);
                    progBar.setValue(0);
                    Control.setStatus(caller, status, startMessage);
                    Timer progressTimer = new Timer(timeout / 100, new ActionListener(this){
                        boolean terminationValid;
                        boolean terminationError;
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = this$0;
                            this.terminationValid = 3.access$000(this.this$0) != null;
                            this.terminationError = false;
                        }

                        public void prepareStop() {
                            3.access$100(this.this$0).setMaximum(100);
                            3.access$100(this.this$0).setValue(100);
                            3.access$100(this.this$0).setStringPainted(false);
                            3.access$100(this.this$0).putClientProperty("ownedBy", null);
                            Logger.debug((String)"dream.gui.Control", (String)"notifying on progress bar.");
                            3.access$100(this.this$0).notify();
                            if (3.access$200(this.this$0) >= 0) {
                                Timer clearTimer = new Timer(3.access$200(this.this$0), new ActionListener(this){
                                    private final /* synthetic */ 4 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void actionPerformed(ActionEvent evt) {
                                        JProgressBar jProgressBar = 3.access$100(4.access$300(this.this$1));
                                        synchronized (jProgressBar) {
                                            if (3.access$100(4.access$300(this.this$1)).getClientProperty("ownedBy") == null) {
                                                3.access$100(4.access$300(this.this$1)).setValue(0);
                                                Control.setStatus(3.access$400(4.access$300(this.this$1)), 3.access$500(4.access$300(this.this$1)), 3.access$600(4.access$300(this.this$1)));
                                            }
                                        }
                                    }
                                });
                                clearTimer.setRepeats(false);
                                clearTimer.start();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent evt) {
                            JProgressBar jProgressBar = 3.access$100(this.this$0);
                            synchronized (jProgressBar) {
                                int actValue = 3.access$100(this.this$0).getValue() + 1;
                                if (actValue > 100) {
                                    3.access$100(this.this$0).setMaximum(actValue);
                                }
                                3.access$100(this.this$0).setValue(actValue);
                                if (this.terminationValid) {
                                    try {
                                        int state = (Integer)3.access$000(this.this$0).invoke(3.access$700(this.this$0), null);
                                        if (state == 0) {
                                            Control.setStatus(3.access$400(this.this$0), 3.access$500(this.this$0), 3.access$800(this.this$0));
                                            ((Timer)evt.getSource()).stop();
                                            int newTimeout = (3.access$900(this.this$0) * 3.access$1000(this.this$0) + actValue * 3.access$1000(this.this$0) / 100) / (3.access$900(this.this$0) + 1);
                                            if (3.access$1100(this.this$0) != null && 3.access$1200(this.this$0) != null) {
                                                3.access$1100(this.this$0).setProperty(3.access$1200(this.this$0), String.valueOf(newTimeout));
                                            }
                                            this.prepareStop();
                                        }
                                        if (state > 0) {
                                            Control.setStatus(3.access$400(this.this$0), 3.access$500(this.this$0), 3.access$1300(this.this$0));
                                            ((Timer)evt.getSource()).stop();
                                            this.prepareStop();
                                        }
                                    }
                                    catch (Exception ex) {
                                        this.terminationValid = false;
                                        this.terminationError = true;
                                        Logger.warning((String)(this.getClass().getName() + "#installProgressTimer"), (String)("termination test method could not be invoked: " + ex.toString()), (Throwable)ex);
                                    }
                                }
                                if (actValue == 100) {
                                    if (this.terminationValid) {
                                        if (3.access$1400(this.this$0)) {
                                            Control.setStatus(3.access$400(this.this$0), 3.access$500(this.this$0), 3.access$1500(this.this$0));
                                        } else {
                                            Control.setStatus(3.access$400(this.this$0), 3.access$500(this.this$0), 3.access$1300(this.this$0));
                                            ((Timer)evt.getSource()).stop();
                                            this.prepareStop();
                                        }
                                    } else {
                                        if (this.terminationError) {
                                            Control.setStatus(3.access$400(this.this$0), 3.access$500(this.this$0), 3.access$1300(this.this$0));
                                        } else {
                                            Control.setStatus(3.access$400(this.this$0), 3.access$500(this.this$0), 3.access$800(this.this$0));
                                        }
                                        ((Timer)evt.getSource()).stop();
                                        this.prepareStop();
                                    }
                                }
                            }
                        }

                        static /* synthetic */ 3 access$300(4 x0) {
                            return x0.this$0;
                        }
                    });
                    progBar.putClientProperty(Control.OWNED_PROP_KEY, progressTimer);
                    progressTimer.setRepeats(true);
                    progressTimer.start();
                }
                Logger.debug((String)"dream.gui.Control", (String)"leaving installProgressTimer (synchronized on progress bar).");
            }

            static /* synthetic */ Method access$000(3 x0) {
                return x0.isTerminated;
            }

            static /* synthetic */ JProgressBar access$100(3 x0) {
                return x0.progBar;
            }

            static /* synthetic */ int access$200(3 x0) {
                return x0.clearDelay;
            }

            static /* synthetic */ StatusPrinter access$400(3 x0) {
                return x0.caller;
            }

            static /* synthetic */ JLabel access$500(3 x0) {
                return x0.status;
            }

            static /* synthetic */ String access$600(3 x0) {
                return x0.clearingMessage;
            }

            static /* synthetic */ Object access$700(3 x0) {
                return x0.invokeOn;
            }

            static /* synthetic */ String access$800(3 x0) {
                return x0.successMessage;
            }

            static /* synthetic */ int access$900(3 x0) {
                return x0.mixWeight;
            }

            static /* synthetic */ int access$1000(3 x0) {
                return x0.timeout;
            }

            static /* synthetic */ Properties access$1100(3 x0) {
                return x0.props;
            }

            static /* synthetic */ String access$1200(3 x0) {
                return x0.setProperty;
            }

            static /* synthetic */ String access$1300(3 x0) {
                return x0.failureMessage;
            }

            static /* synthetic */ boolean access$1400(3 x0) {
                return x0.allowMoreTime;
            }

            static /* synthetic */ String access$1500(3 x0) {
                return x0.timeoutMessage;
            }
        }).start();
    }
}

