/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.ConsoleControl;
import dream.gui.Control;
import dream.gui.StatusPrinter;
import dream.util.PropertyHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpViewer
extends JFrame
implements HyperlinkListener,
StatusPrinter {
    private static int MIN_SIZE_X = 400;
    private static int MIN_SIZE_Y = 400;
    String base = null;
    URL page = null;
    protected URL home = null;
    protected int loaded = -1;
    protected String linkShown = "";
    protected PropertyHandler ph = null;
    private JPanel topPanel;
    private JScrollPane jScrollPane1;
    private JButton homeButton;
    private JButton backButton;
    private JSplitPane jSplitPane2;
    private JLabel statusLabel;
    private JTextPane helpTextPane;
    private JTextField addressTextField;
    private JPanel jPanel2;
    private JButton forwardButton;
    private JPanel jPanel1;
    private JPanel statusPanel;
    private JProgressBar jProgressBar1;

    public HelpViewer(PropertyHandler ph) {
        this.ph = ph;
        if (ph == null) {
            this.ph = PropertyHandler.getDefaultHandler();
        }
        this.initComponents();
        this.initLocal();
    }

    public HelpViewer(PropertyHandler ph, URL page) {
        this(ph);
        this.setPage(page);
    }

    public URL getHome() {
        return this.home;
    }

    public void setHome(URL home) {
        this.home = home;
    }

    public int pageLoaded() {
        return this.loaded;
    }

    public void setPage(URL page) {
        block10: {
            if (this.page == null && this.home == null) {
                this.home = page;
            }
            if (this.base == null) {
                String path = page.toString();
                if (path.lastIndexOf(47) > 0) {
                    path = path.substring(0, path.lastIndexOf(47) + 1);
                }
                if (path != null) {
                    this.setBase(path);
                }
            }
            try {
                this.loaded = -1;
                try {
                    String loadProp = "help.localLoadTime";
                    if (!page.getProtocol().equalsIgnoreCase("file")) {
                        loadProp = "help.meanLoadPageTime";
                    }
                    Control.installProgressTimer(this, this.jProgressBar1, this.statusLabel, Integer.parseInt(this.ph.getProperty(loadProp, "2000")), true, this.getClass().getMethod("pageLoaded", null), this, this.ph.fetch(ConsoleControl.helpPropID), loadProp, 9, "Loading page" + page, "Page " + page + " loaded.", "Still need more time load page " + page + " .", "Page " + page + " could not be loaded.", Integer.parseInt(this.ph.getProperty("clearDelay", "5000")), "");
                }
                catch (NoSuchMethodException ex) {
                    System.err.println(ex);
                }
                this.helpTextPane.setPage(page);
                this.helpTextPane.setEditable(false);
                if (this.base != null && page.toString().indexOf(this.base) >= 0) {
                    this.addressTextField.setText(page.toString().substring(this.base.length()));
                    break block10;
                }
                this.addressTextField.setText(page.toString());
            }
            catch (IOException e) {
                this.loaded = 1;
            }
        }
    }

    public void setBase(String base) {
        this.base = base;
    }

    private void initLocal() {
        this.helpTextPane.addHyperlinkListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.helpTextPane = new JTextPane();
        this.jSplitPane2 = new JSplitPane();
        this.jProgressBar1 = new JProgressBar();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.topPanel = new JPanel();
        this.backButton = new JButton();
        this.forwardButton = new JButton();
        this.jPanel2 = new JPanel();
        this.addressTextField = new JTextField();
        this.homeButton = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                HelpViewer.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HelpViewer.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.helpTextPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                HelpViewer.this.helpTextPanePropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.helpTextPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jSplitPane2.setDividerLocation(100);
        this.jSplitPane2.setDividerSize(4);
        this.jSplitPane2.setMinimumSize(new Dimension(93, 19));
        this.jSplitPane2.setPreferredSize(new Dimension(231, 19));
        this.jSplitPane2.setLeftComponent(this.jProgressBar1);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusPanel.setMinimumSize(new Dimension(101, 20));
        this.statusPanel.setPreferredSize(new Dimension(101, 20));
        this.statusLabel.setText("Status: ready.");
        this.statusLabel.setAlignmentX(0.5f);
        this.statusLabel.setBorder(new EmptyBorder(new Insets(0, 4, 0, 4)));
        this.statusLabel.setMaximumSize(new Dimension(77, 15));
        this.statusLabel.setMinimumSize(new Dimension(77, 15));
        this.statusLabel.setPreferredSize(new Dimension(77, 15));
        this.statusLabel.setAutoscrolls(true);
        this.statusLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.statusPanel);
        this.getContentPane().add((Component)this.jSplitPane2, "South");
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.setMinimumSize(new Dimension(227, 32));
        this.topPanel.setPreferredSize(new Dimension(227, 32));
        this.backButton.setText("back");
        this.backButton.setToolTipText("back to the page last visited");
        this.backButton.setEnabled(false);
        this.topPanel.add((Component)this.backButton, new GridBagConstraints());
        this.forwardButton.setText("forward");
        this.forwardButton.setEnabled(false);
        this.topPanel.add((Component)this.forwardButton, new GridBagConstraints());
        this.jPanel2.setLayout(new BorderLayout());
        this.addressTextField.setBackground(new Color(236, 244, 240));
        this.addressTextField.setEditable(false);
        this.addressTextField.setToolTipText("address of the actual page");
        this.addressTextField.setBorder(new LineBorder(new Color(0, 0, 0), 2));
        this.jPanel2.add((Component)this.addressTextField, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.topPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.homeButton.setText("home");
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HelpViewer.this.homeButtonActionPerformed(evt);
            }
        });
        this.topPanel.add((Component)this.homeButton, new GridBagConstraints());
        this.getContentPane().add((Component)this.topPanel, "North");
        this.pack();
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        if (this.home != null) {
            this.setPage(this.home);
        }
    }

    private void helpTextPanePropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("page")) {
            this.loaded = 0;
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent.getURL().toExternalForm().endsWith(".pdf") || hyperlinkEvent.getURL().toString().endsWith(".doc")) {
                this.printStatusMessage("Error: target page file format is not supported!");
            } else {
                this.printStatusMessage(hyperlinkEvent.getDescription());
                this.setPage(hyperlinkEvent.getURL());
            }
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.printStatusMessage(hyperlinkEvent.getDescription());
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.printStatusMessage("");
        }
    }

    public String getDefaultMessage() {
        return "";
    }

    public String getStatusMessage() {
        return this.linkShown;
    }

    public void printStatusMessage(String message) {
        int clearDelay = 0;
        try {
            clearDelay = Integer.parseInt(this.ph.fetch(ConsoleControl.optionPropID).getProperty("clearDelay", "0"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        Control.setStatus(this, this.statusLabel, message, clearDelay);
    }

    public static void main(String[] args) {
        HelpViewer testView = new HelpViewer(PropertyHandler.getDefaultHandler());
        testView.setPage(testView.getClass().getResource("/dream/resources/helpSets/console/console.html"));
        testView.setSize(600, 600);
        testView.show();
    }
}

