/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JWindow;

public class StartDialog
extends JPanel {
    public static final int NO_SELECTION = -1;
    public static final int NORMAL_SELECTION = 1;
    public static final int NODE_SELECTION = 2;
    public static final int CONSOLE_SELECTION = 3;
    public static final int INSTALLER_SELECTION = 4;
    public int selection = -1;
    public boolean shouldLive = true;
    private JLabel backLabel;
    private JRadioButton onlyConsoleButton;
    private JLabel glueLabel;
    private JLabel versionLabel;
    private JRadioButton installerButton;
    private JLabel leftGlueLabel;
    private JLabel bottomText;
    private JRadioButton onlyNodeButton;
    private JLabel selectTextLabel;
    private ButtonGroup initButtonGroup;
    private JPanel overlayPanel;
    private JRadioButton normalModeButton;
    private JPanel switchPanel;

    protected StartDialog() {
        this.initComponents();
        this.initUserComps();
    }

    protected void initUserComps() {
        this.remove(this.overlayPanel);
        this.overlayPanel.setPreferredSize(new Dimension(400, 267));
        this.versionLabel.setText("version " + String.valueOf(2.0));
        this.doLayout();
        this.backLabel.setLayout(new FlowLayout());
        this.backLabel.add(this.overlayPanel);
        this.backLabel.setPreferredSize(new Dimension(400, 267));
        this.backLabel.doLayout();
    }

    private synchronized void setOptionNo(int optionNo) {
        this.selection = optionNo;
    }

    public void waitForSelection(int sleepTime, JWindow win) {
        boolean stable = false;
        while (this.shouldLive || !stable) {
            win.toFront();
            int oldSelection = this.selection;
            try {
                Thread.currentThread();
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            stable = false;
            if (this.selection != oldSelection || this.selection == -1) continue;
            stable = true;
        }
    }

    private void initComponents() {
        this.initButtonGroup = new ButtonGroup();
        this.backLabel = new JLabel();
        this.overlayPanel = new JPanel();
        this.glueLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.switchPanel = new JPanel();
        this.selectTextLabel = new JLabel();
        this.leftGlueLabel = new JLabel();
        this.normalModeButton = new JRadioButton();
        this.onlyNodeButton = new JRadioButton();
        this.onlyConsoleButton = new JRadioButton();
        this.installerButton = new JRadioButton();
        this.bottomText = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(400, 267));
        this.setPreferredSize(new Dimension(400, 267));
        this.backLabel.setIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/console-start-dialog.gif")));
        this.backLabel.setText("jLabel1");
        this.backLabel.setMaximumSize(new Dimension(100, 267));
        this.backLabel.setMinimumSize(new Dimension(100, 267));
        this.backLabel.setPreferredSize(new Dimension(100, 267));
        this.backLabel.setOpaque(true);
        this.add((Component)this.backLabel, new GridBagConstraints());
        this.overlayPanel.setOpaque(false);
        this.glueLabel.setPreferredSize(new Dimension(400, 90));
        this.overlayPanel.add(this.glueLabel);
        this.versionLabel.setFont(new Font("SansSerif", 0, 11));
        this.versionLabel.setForeground(Color.black);
        this.versionLabel.setHorizontalAlignment(0);
        this.versionLabel.setText("DREAM version:");
        this.versionLabel.setPreferredSize(new Dimension(400, 20));
        this.versionLabel.setHorizontalTextPosition(0);
        this.overlayPanel.add(this.versionLabel);
        this.switchPanel.setLayout(new GridBagLayout());
        this.switchPanel.setOpaque(false);
        this.selectTextLabel.setForeground(new Color(40, 63, 136));
        this.selectTextLabel.setText("please select start option:");
        this.selectTextLabel.setMaximumSize(new Dimension(147, 19));
        this.selectTextLabel.setMinimumSize(new Dimension(147, 19));
        this.selectTextLabel.setPreferredSize(new Dimension(147, 23));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        this.switchPanel.add((Component)this.selectTextLabel, gridBagConstraints);
        this.leftGlueLabel.setMinimumSize(new Dimension(50, 0));
        this.leftGlueLabel.setPreferredSize(new Dimension(50, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 10.0;
        this.switchPanel.add((Component)this.leftGlueLabel, gridBagConstraints);
        this.normalModeButton.setFont(new Font("SansSerif", 0, 11));
        this.normalModeButton.setText("Node and Console (normal mode)");
        this.initButtonGroup.add(this.normalModeButton);
        this.normalModeButton.setMargin(new Insets(0, 2, 0, 2));
        this.normalModeButton.setOpaque(false);
        this.normalModeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartDialog.this.normalModeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.switchPanel.add((Component)this.normalModeButton, gridBagConstraints);
        this.onlyNodeButton.setFont(this.normalModeButton.getFont());
        this.onlyNodeButton.setText("local Node only (no GUI)");
        this.initButtonGroup.add(this.onlyNodeButton);
        this.onlyNodeButton.setMargin(new Insets(2, 2, 0, 2));
        this.onlyNodeButton.setOpaque(false);
        this.onlyNodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartDialog.this.onlyNodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.switchPanel.add((Component)this.onlyNodeButton, gridBagConstraints);
        this.onlyConsoleButton.setFont(this.normalModeButton.getFont());
        this.onlyConsoleButton.setText("Console only (do not contribute to the DREAM)");
        this.initButtonGroup.add(this.onlyConsoleButton);
        this.onlyConsoleButton.setMargin(new Insets(2, 2, 0, 2));
        this.onlyConsoleButton.setOpaque(false);
        this.onlyConsoleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartDialog.this.onlyConsoleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.switchPanel.add((Component)this.onlyConsoleButton, gridBagConstraints);
        this.installerButton.setFont(this.normalModeButton.getFont());
        this.installerButton.setText("call Installer/Uninstaller (DREAM software reconfiguration)");
        this.initButtonGroup.add(this.installerButton);
        this.installerButton.setMargin(new Insets(2, 2, 0, 2));
        this.installerButton.setOpaque(false);
        this.installerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartDialog.this.installerButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.switchPanel.add((Component)this.installerButton, gridBagConstraints);
        this.overlayPanel.add(this.switchPanel);
        this.bottomText.setFont(new Font("SansSerif", 0, 11));
        this.bottomText.setForeground(Color.white);
        this.bottomText.setHorizontalAlignment(0);
        this.bottomText.setVerticalAlignment(3);
        this.bottomText.setPreferredSize(new Dimension(400, 21));
        this.overlayPanel.add(this.bottomText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.overlayPanel, gridBagConstraints);
    }

    private void installerButtonActionPerformed(ActionEvent evt) {
        this.setOptionNo(4);
        this.bottomText.setText("DREAM setup chosen, preparing...");
        this.shouldLive = false;
    }

    private void onlyConsoleButtonActionPerformed(ActionEvent evt) {
        this.setOptionNo(3);
        this.shouldLive = false;
    }

    private void onlyNodeButtonActionPerformed(ActionEvent evt) {
        this.setOptionNo(2);
        this.shouldLive = false;
    }

    private void normalModeButtonActionPerformed(ActionEvent evt) {
        this.setOptionNo(1);
        this.shouldLive = false;
    }

    public static int askStartOption(int sleepTime) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        JWindow win = new JWindow();
        StartDialog optionPanel = new StartDialog();
        int answer = -1;
        win.setBounds(screenDim.width / 2 - 200, screenDim.height / 2 - 134, 400, 267);
        win.getContentPane().add(optionPanel);
        win.show();
        win.toFront();
        optionPanel.waitForSelection(sleepTime, win);
        win.dispose();
        return optionPanel.selection;
    }

    public static void main(String[] args) {
        System.out.println("start option code: " + StartDialog.askStartOption(1500));
        System.exit(0);
    }
}

