/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.componentTree;

import dream.gui.componentTree.DreamIsland;
import dream.gui.componentTree.DreamNode;
import dream.gui.componentTree.DreamThread;
import dream.gui.componentTree.DreamTreeModel;
import dream.gui.componentTree.Timing;
import drm.agentbase.Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DreamComponent
extends DefaultMutableTreeNode {
    public static final Class ISLAND_CLASS = class$dream$gui$componentTree$DreamIsland == null ? (class$dream$gui$componentTree$DreamIsland = DreamComponent.class$("dream.gui.componentTree.DreamIsland")) : class$dream$gui$componentTree$DreamIsland;
    public static final Class NODE_CLASS = class$dream$gui$componentTree$DreamNode == null ? (class$dream$gui$componentTree$DreamNode = DreamComponent.class$("dream.gui.componentTree.DreamNode")) : class$dream$gui$componentTree$DreamNode;
    public static final Class MACHINE_CLASS = class$dream$gui$componentTree$DreamMachine == null ? (class$dream$gui$componentTree$DreamMachine = DreamComponent.class$("dream.gui.componentTree.DreamMachine")) : class$dream$gui$componentTree$DreamMachine;
    public static final Class MESH_CLASS = class$dream$gui$componentTree$DreamMesh == null ? (class$dream$gui$componentTree$DreamMesh = DreamComponent.class$("dream.gui.componentTree.DreamMesh")) : class$dream$gui$componentTree$DreamMesh;
    public static final Class JOB_CLASS = class$dream$gui$componentTree$DreamJob == null ? (class$dream$gui$componentTree$DreamJob = DreamComponent.class$("dream.gui.componentTree.DreamJob")) : class$dream$gui$componentTree$DreamJob;
    public static final Class THREAD_CLASS = class$dream$gui$componentTree$DreamThread == null ? (class$dream$gui$componentTree$DreamThread = DreamComponent.class$("dream.gui.componentTree.DreamThread")) : class$dream$gui$componentTree$DreamThread;
    public boolean isInserted = false;
    protected DreamTreeModel model = null;
    public Timing time = null;
    protected boolean isDerived = false;
    protected boolean isDuplicate = false;
    protected Map derived = Collections.synchronizedMap(new HashMap());
    protected Map duplicated = Collections.synchronizedMap(new HashMap());
    protected DreamComponent duplicateOf = null;
    protected DreamComponent derivedFrom = null;
    protected int shareCount = 0;
    public Vector cipMessages = new Vector();
    static /* synthetic */ Class class$dream$gui$componentTree$DreamIsland;
    static /* synthetic */ Class class$dream$gui$componentTree$DreamNode;
    static /* synthetic */ Class class$dream$gui$componentTree$DreamMachine;
    static /* synthetic */ Class class$dream$gui$componentTree$DreamMesh;
    static /* synthetic */ Class class$dream$gui$componentTree$DreamJob;
    static /* synthetic */ Class class$dream$gui$componentTree$DreamThread;

    public static DreamComponent specialize(DreamComponent dc) {
        DreamComponent answer = dc;
        if (dc.userObject == null) {
            return dc;
        }
        Address addr = dc.getAddress();
        if (addr != null) {
            answer = null;
            if (addr.name.startsWith("Servent") || addr.name.startsWith("Node")) {
                answer = new DreamNode(addr);
            }
            if (addr.name.startsWith("Island")) {
                answer = new DreamIsland(addr);
            }
            if (answer == null) {
                answer = new DreamThread(addr);
            }
            answer.isInserted = dc.isInserted;
            answer.model = dc.model;
            answer.time = dc.time;
        }
        return answer;
    }

    public DreamComponent() {
        this.time = new Timing();
    }

    public DreamComponent(Object o) {
        super(o);
        this.time = new Timing();
    }

    public DreamComponent duplicate() {
        DreamComponent answer = (DreamComponent)super.clone();
        answer.isDuplicate = true;
        answer.duplicateOf = this;
        answer.derived = Collections.synchronizedMap(new HashMap());
        answer.duplicated = Collections.synchronizedMap(new HashMap());
        answer.shareCount = 0;
        this.duplicated.put(answer.getIdentifier(), answer);
        return answer;
    }

    public boolean isLocal() {
        block3: {
            Address myAdr = this.getAddress();
            if (myAdr == null) break block3;
            try {
                if (myAdr.getHost().equals(InetAddress.getLocalHost())) {
                    return true;
                }
            }
            catch (UnknownHostException ex) {}
        }
        return false;
    }

    public Address getAddress() {
        if (this.userObject == null) {
            return null;
        }
        if (this.userObject instanceof Address) {
            return (Address)this.userObject;
        }
        if (this.userObject instanceof Map.Entry) {
            Object o = ((Map.Entry)this.userObject).getKey();
            if (o != null && o instanceof Address) {
                return (Address)o;
            }
            return null;
        }
        return null;
    }

    public Comparable getPropertyValue() {
        if (this.userObject instanceof Map.Entry) {
            Object o = ((Map.Entry)this.userObject).getValue();
            if (o != null && o instanceof Comparable) {
                return (Comparable)o;
            }
            return null;
        }
        return null;
    }

    public DreamTreeModel getModel() {
        return this.model;
    }

    public void setModel(DreamTreeModel model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long newRemoteTime) {
        this.time.update(newRemoteTime);
        Map map = this.derived;
        synchronized (map) {
            Iterator derIt = this.derived.values().iterator();
            DreamComponent toUpdate = null;
            while (derIt.hasNext()) {
                toUpdate = (DreamComponent)derIt.next();
                toUpdate.time.update(newRemoteTime);
            }
        }
    }

    public void importTimes(DreamComponent comp) {
        this.time.update(comp.time.remoteCreation);
    }

    public void callOnInsert() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDerivedComponents() {
        Map map = this.derived;
        synchronized (map) {
            Iterator derIt = this.derived.values().iterator();
            DreamComponent toRemove = null;
            while (derIt.hasNext()) {
                toRemove = (DreamComponent)derIt.next();
                toRemove.removeFromParent();
            }
            this.derived.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDuplicates() {
        Map map = this.duplicated;
        synchronized (map) {
            Iterator dupIt = this.duplicated.values().iterator();
            DreamComponent toRemove = null;
            while (dupIt.hasNext()) {
                toRemove = (DreamComponent)dupIt.next();
                toRemove.removeFromParent();
            }
            this.duplicated.clear();
        }
    }

    public boolean equals(Object o) {
        boolean answer = false;
        Object oUser = null;
        if (this == o) {
            return true;
        }
        if (o instanceof DreamComponent) {
            oUser = ((DreamComponent)o).userObject;
            if (this.userObject != null && oUser != null && this.userObject.equals(oUser)) {
                answer = true;
            }
        }
        return answer;
    }

    public String toString() {
        if (this.userObject != null) {
            return this.userObject.toString();
        }
        return null;
    }

    public boolean add(DreamComponent newChild) {
        boolean answer = false;
        if (this.model.isInsertable(newChild, true)) {
            answer = true;
            super.add(newChild);
            newChild.isInserted = true;
            newChild.setModel(((DreamComponent)this.getRoot()).getModel());
            this.model.reload(this);
            newChild.callOnInsert();
        }
        return answer;
    }

    public boolean addDerived(DreamComponent newChild) {
        boolean answer = false;
        newChild.isDerived = true;
        newChild.time = this.time;
        answer = this.add(newChild);
        if (answer) {
            this.derived.put(newChild.getIdentifier(), newChild);
        }
        return answer;
    }

    public void registerDerived(DreamComponent newDerived) {
        newDerived.isDerived = true;
        newDerived.time.update(this.time.remoteCreation);
        if (!this.derived.containsKey(newDerived.getIdentifier())) {
            this.derived.put(newDerived.getIdentifier(), newDerived);
            ++newDerived.shareCount;
        }
    }

    public String getIdentifier() {
        Address adr = this.getAddress();
        String answer = null;
        if (adr != null) {
            answer = adr.name;
        } else if (this.getUserObject() instanceof String) {
            return (String)this.getUserObject();
        }
        return answer;
    }

    public DreamComponent childWithName(String name) {
        DreamComponent tmp = null;
        int childNo = 0;
        while (childNo < this.getChildCount()) {
            tmp = (DreamComponent)this.getChildAt(childNo);
            if (tmp.getIdentifier().equals(name)) {
                return tmp;
            }
            ++childNo;
        }
        return null;
    }

    public synchronized void removeFromParent() {
        DreamComponent parent = (DreamComponent)this.getParent();
        if (this.shareCount <= 0) {
            int childCount = this.getChildCount();
            int i = 0;
            while (i < childCount) {
                ((DreamComponent)this.getChildAt(i)).removeFromParent();
                ++i;
            }
            this.removeDuplicates();
            this.removeDerivedComponents();
            super.removeFromParent();
            if (this.model != null && !this.isDuplicate) {
                this.model.treeGuard.remove(this.toString());
            }
            if (this.model != null) {
                this.model.reload(parent);
            }
        } else {
            --this.shareCount;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

