/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.componentTree;

import dream.gui.componentTree.DreamComponent;
import dream.gui.componentTree.DreamNode;
import dream.util.PropertyHandler;
import drm.agentbase.Address;
import drm.core.ContributionBox;
import drm.core.IDRM;
import drm.core.Node;
import drm.core.NodeContribution;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DreamTreeModel
extends DefaultTreeModel {
    private DreamComponent tNodes = null;
    private DreamComponent tMachines = null;
    private DreamComponent tJobs = null;
    private DreamComponent tIslands = null;
    private DreamComponent tThreads = null;
    Map treeGuard = Collections.synchronizedMap(new HashMap());
    PropertyHandler ph = null;

    public DreamTreeModel(DreamComponent root, PropertyHandler ph) {
        super(root);
        this.ph = ph;
        this.setup();
    }

    public DreamTreeModel(DreamComponent root, boolean askAllowsChildren) {
        super(root, askAllowsChildren);
        this.setup();
    }

    private void setup() {
        DreamComponent treeRoot = (DreamComponent)this.getRoot();
        treeRoot.setModel(this);
        this.tNodes = new DreamComponent("nodes");
        this.tMachines = new DreamComponent("machines");
        this.tJobs = new DreamComponent("experiments");
        this.tIslands = new DreamComponent("islands");
        this.tThreads = new DreamComponent("agents");
        treeRoot.add(this.tNodes);
        treeRoot.add(this.tMachines);
        treeRoot.add(this.tJobs);
        treeRoot.add(this.tIslands);
        treeRoot.add(this.tThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        DreamComponent treeRoot;
        DreamComponent dreamComponent = treeRoot = (DreamComponent)this.getRoot();
        synchronized (dreamComponent) {
            DreamComponent branchRoot = null;
            DreamComponent toDelete = null;
            Enumeration<TreeNode> rootChildren = treeRoot.children();
            while (rootChildren.hasMoreElements()) {
                branchRoot = (DreamComponent)rootChildren.nextElement();
                while (branchRoot.getChildCount() > 0) {
                    toDelete = (DreamComponent)branchRoot.getChildAt(0);
                    toDelete.removeFromParent();
                }
            }
            this.treeGuard = Collections.synchronizedMap(new HashMap());
        }
    }

    public boolean isInsertable(DreamComponent insert, boolean doIfPossible) {
        boolean answer = false;
        String comp = null;
        if (insert != null) {
            answer = true;
            comp = insert.getIdentifier();
            if (this.treeGuard.containsKey(comp) && !insert.isDuplicate || comp == null) {
                answer = false;
            } else if (doIfPossible && !insert.isDuplicate) {
                this.treeGuard.put(comp, insert);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromDRM(Node node) {
        if (node != null) {
            DreamComponent treeRoot;
            IDRM drm = (IDRM)node.getFirewall();
            DreamComponent dreamComponent = treeRoot = (DreamComponent)this.getRoot();
            synchronized (dreamComponent) {
                List data = drm.getContributions();
                int i = 0;
                while (i < data.size()) {
                    ContributionBox contrib = (ContributionBox)data.get(i);
                    this.update(contrib);
                    ++i;
                }
            }
        }
    }

    public void update(ContributionBox a) {
        InetAddress baseAdr = a.contributor.getHost();
        int basePort = a.contributor.port;
        Hashtable<String, DreamComponent> newList = new Hashtable<String, DreamComponent>();
        DreamNode node = null;
        String nodeAdr = null;
        DreamComponent workComp = null;
        try {
            Iterator nIter = ((NodeContribution)a.contribution).getAgents().iterator();
            while (nIter.hasNext()) {
                workComp = new DreamComponent(new Address(baseAdr, basePort, (String)nIter.next()));
                workComp = DreamComponent.specialize(workComp);
                workComp.time.update(a.timeStamp());
                if (workComp instanceof DreamNode) continue;
                newList.put(workComp.getIdentifier(), workComp);
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        nodeAdr = a.contributor.name;
        if (this.treeGuard.containsKey(nodeAdr)) {
            node = (DreamNode)this.treeGuard.get(nodeAdr);
            node.update(a.timeStamp());
        } else {
            DreamNode sameNode = this.sameHostNode(a.contributor);
            if (sameNode != null) {
                if (a.timeStamp() > sameNode.time.remoteCreation) {
                    sameNode.removeFromParent();
                } else {
                    nodeAdr = null;
                }
            }
            if (nodeAdr != null) {
                node = new DreamNode(a.contributor);
                node.update(a.timeStamp());
                this.getBranchRoot(node.getClass()).add(node);
            }
        }
        if (node != null) {
            node.updateAgentTable(newList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DreamNode sameHostNode(Address nodeAdr) {
        DreamNode answer = null;
        if (this.tNodes != null) {
            DreamComponent dreamComponent = this.tNodes;
            synchronized (dreamComponent) {
                int child = 0;
                while (child < this.tNodes.getChildCount()) {
                    answer = (DreamNode)this.tNodes.getChildAt(child);
                    if (answer.getAddress().port == nodeAdr.port && answer.getAddress().getHost().equals(nodeAdr.getHost()) && !answer.getAddress().equals((Object)nodeAdr)) {
                        return answer;
                    }
                    ++child;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkComponents(DreamComponent checkRoot) {
        if (checkRoot == null) {
            return;
        }
        DreamComponent dreamComponent = checkRoot;
        synchronized (dreamComponent) {
            DreamComponent actComp = null;
            long checktime = System.currentTimeMillis();
            Enumeration<TreeNode> comps = checkRoot.breadthFirstEnumeration();
            while (comps.hasMoreElements()) {
                actComp = (DreamComponent)comps.nextElement();
                if (actComp.time.getRemoteAge() <= 0x6DDD00L || actComp.getLevel() <= 1) continue;
                actComp.removeFromParent();
            }
        }
    }

    public DreamComponent getBranchRoot(Class type) {
        DreamComponent answer = null;
        if (type == DreamComponent.ISLAND_CLASS) {
            answer = this.tIslands;
        }
        if (type == DreamComponent.NODE_CLASS) {
            answer = this.tNodes;
        }
        if (type == DreamComponent.MACHINE_CLASS) {
            answer = this.tMachines;
        }
        if (type == DreamComponent.JOB_CLASS) {
            answer = this.tJobs;
        }
        if (type == DreamComponent.THREAD_CLASS) {
            answer = this.tThreads;
        }
        return answer;
    }

    public void putToDefaultPlace(DreamComponent newComponent) {
        DreamComponent insertLocation = this.getBranchRoot(newComponent.getClass());
        insertLocation.add(newComponent);
    }
}

