/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.tasks;

import dream.gui.ConsoleTaskHandler;
import dream.gui.tasks.ConsoleTask;
import drm.agentbase.ILogListener;
import drm.agentbase.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;

public class Messages
extends JPanel
implements ConsoleTask,
ILogListener {
    private static final String LABEL_TEXT = "Messages";
    protected ConsoleTaskHandler handler = null;
    protected int maxLines = 1000;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public Messages() {
        this.initComponents();
        Logger.addListener((ILogListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertLines(int maxLineNumber) {
        JTextArea jTextArea = this.jTextArea1;
        synchronized (jTextArea) {
            int currentLines = this.jTextArea1.getLineCount();
            int removing = 0;
            if (currentLines > maxLineNumber) {
                try {
                    removing = this.jTextArea1.getLineStartOffset(currentLines - maxLineNumber);
                    this.jTextArea1.replaceRange("", 0, removing);
                }
                catch (BadLocationException ex) {
                    System.err.println(ex);
                }
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(new TitledBorder(LABEL_TEXT));
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public Icon getIcon(int heightInPixels) {
        ImageIcon defaultIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/messages-default-16.gif"));
        return defaultIcon;
    }

    public String getTooltip() {
        return "see log messages";
    }

    public JMenu[] getMenues() {
        return null;
    }

    public JToolBar[] getToolBars() {
        return null;
    }

    public String getLabelText() {
        return LABEL_TEXT;
    }

    public JComponent getVisual() {
        return this;
    }

    public void onPassive() {
    }

    public void onActive() {
    }

    public void handleLogMessage(int type, String sender, String comment, Throwable thr) {
        String s1 = sender == null ? "" : sender;
        String s2 = comment == null ? "" : comment;
        String s3 = thr == null ? "" : thr.toString();
        switch (type) {
            case 0: {
                this.jTextArea1.append("PANIC! ");
                this.jTextArea1.append(s1 + ": " + s2 + " " + s3 + "\n");
                break;
            }
            case 1: {
                this.jTextArea1.append("ERROR! ");
                this.jTextArea1.append(s1 + ": " + s2 + " " + s3 + "\n");
                break;
            }
            case 2: {
                this.jTextArea1.append("WARNING! ");
                this.jTextArea1.append(s1 + ": " + s2 + " " + s3 + "\n");
                break;
            }
            case 3: {
                this.jTextArea1.append("DEBUG! ");
                this.jTextArea1.append(s1 + ": " + s2 + " " + s3 + "\n");
                break;
            }
            default: {
                this.jTextArea1.append(s1 + ": " + s2 + " " + s3 + "\n");
            }
        }
        this.assertLines(this.maxLines);
    }

    public ConsoleTaskHandler getConsoleTaskHandler() {
        return this.handler;
    }

    public void setConsoleTaskHandler(ConsoleTaskHandler handler) {
        this.handler = handler;
    }
}

