/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.tasks;

import dream.gui.ConsoleControl;
import dream.gui.ConsoleTaskHandler;
import dream.gui.componentTree.ComponentMessage;
import dream.gui.componentTree.DreamComponent;
import dream.gui.event.DRMRequest;
import dream.gui.event.DRMRequestEvent;
import dream.gui.event.DRMRequestHandler;
import dream.gui.event.DRMRequestListener;
import dream.gui.tasks.ConsoleTask;
import drm.agentbase.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class ObjectInfo
extends JPanel
implements ConsoleTask,
DRMRequestListener,
Runnable {
    private static final String LABEL_TEXT = "Component Info";
    private JTree sourceTree = null;
    private ConsoleControl control = null;
    private DRMRequestHandler requestHandler = null;
    private ConsoleTaskHandler handler = null;
    private DreamComponent componentShown = null;
    private boolean shouldLive = false;
    public long updateCycle = 10000L;
    private JTextArea jText;
    private JScrollPane jScroll;

    public ObjectInfo(final JTree componentTree, ConsoleControl control, DRMRequestHandler requestHandler) {
        this.initComponents();
        this.jText.setBorder(new TitledBorder(LABEL_TEXT));
        this.sourceTree = componentTree;
        this.control = control;
        this.requestHandler = requestHandler;
        requestHandler.addDRMRequestListener(this);
        componentTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ObjectInfo.this.treeElementSelected(e, componentTree);
            }
        });
    }

    private void initComponents() {
        this.jScroll = new JScrollPane();
        this.jText = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jText.setEditable(false);
        this.jText.setLineWrap(true);
        this.jText.setWrapStyleWord(true);
        this.jScroll.setViewportView(this.jText);
        this.add((Component)this.jScroll, "Center");
    }

    public void onPassive() {
        this.componentShown = null;
        this.shouldLive = false;
    }

    public Icon getIcon(int heightInPixels) {
        ImageIcon defaultIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/component-noframe-16.gif"));
        return defaultIcon;
    }

    public String getTooltip() {
        return "displays information about a component";
    }

    public JMenu[] getMenues() {
        return null;
    }

    public JToolBar[] getToolBars() {
        return null;
    }

    public String getLabelText() {
        return LABEL_TEXT;
    }

    public JComponent getVisual() {
        return this.jScroll;
    }

    public void onActive() {
        boolean wasShouldLive = this.shouldLive;
        this.shouldLive = true;
        if (!wasShouldLive) {
            new Thread(this).start();
        }
    }

    public void treeElementSelected(TreeSelectionEvent e, JTree tree) {
        TreePath newSel = e.getPath();
        DreamComponent selectedElem = null;
        if (e != null) {
            this.componentShown = selectedElem = (DreamComponent)newSel.getLastPathComponent();
            if (selectedElem.cipMessages.size() < 1) {
                this.startInfoRequest(this.jText, "getInfo", null, selectedElem);
            } else {
                this.startInfoRequest(this.jText, "getStatus", null, selectedElem);
            }
        }
    }

    public int startInfoRequest(JTextComponent display, String messageType, Object userObject, DreamComponent askAbout) {
        this.control.requestHandler.add(new DRMRequest(messageType, askAbout));
        ConsoleTaskHandler.printStatusMessage(this, "component " + askAbout + " information requested...");
        return 0;
    }

    private void updateComponentDisplay(JTextComponent display, DreamComponent component) {
        String text = "";
        this.jText.setBorder(new TitledBorder("Component Info: " + component.getAddress()));
        ComponentMessage mess = (ComponentMessage)component.cipMessages.get(0);
        text = text + "INFO (" + new Date(mess.timestamp) + "): \n" + this.formatAnswer(mess) + "\n";
        if (component.cipMessages.size() > 1) {
            int i = 1;
            while (i < component.cipMessages.size()) {
                mess = (ComponentMessage)component.cipMessages.get(i);
                text = text + "STATUS (" + new Date(mess.timestamp) + "): \n" + this.formatAnswer(mess) + "\n";
                ++i;
            }
        }
        display.setText(text);
        this.getConsoleTaskHandler().setActiveTask(this);
    }

    private String formatAnswer(ComponentMessage message) {
        if (message.answer instanceof Map) {
            return this.performMapOutput((Map)message.answer);
        }
        if (message.answer != null) {
            return message.answer.toString();
        }
        return "";
    }

    private String performMapOutput(Map toPrint) {
        Set keys;
        String prepareOutput = "";
        if (toPrint != null && (keys = toPrint.keySet()) != null) {
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object nextKey = iter.next();
                prepareOutput = prepareOutput + nextKey.toString() + " " + toPrint.get(nextKey) + "\n";
            }
        }
        return prepareOutput;
    }

    public synchronized void requestStateChanged(DRMRequestEvent evt) {
        Logger.debug((String)(this.getClass().getName() + "#requestStateChanged"), (String)("state " + evt.getState() + " info " + evt.getInfo()));
        DreamComponent target = ((DRMRequest)evt.getSource()).target;
        String message = ((DRMRequest)evt.getSource()).messageText;
        if (evt.getState() == 2) {
            ConsoleTaskHandler.printStatusMessage(this, "component " + target + " does not provide " + message + " information.");
        }
        if (evt.getState() == 1) {
            ConsoleTaskHandler.printStatusMessage(this, "component " + target + " " + message + " information arrived...");
            target.cipMessages.add(new ComponentMessage(message, evt.getInfo()));
            this.updateComponentDisplay(this.jText, target);
        }
    }

    public ConsoleTaskHandler getConsoleTaskHandler() {
        return this.handler;
    }

    public void setConsoleTaskHandler(ConsoleTaskHandler handler) {
        this.handler = handler;
    }

    public void run() {
        while (this.shouldLive) {
            this.updateCycle = Integer.parseInt(this.control.connectProps.getProperty("requestRefreshTime", "10000"));
            try {
                Thread.currentThread();
                Thread.sleep(this.updateCycle);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.componentShown == null || this.componentShown.cipMessages.size() <= 0) continue;
            this.startInfoRequest(this.jText, "getStatus", null, this.componentShown);
        }
    }
}

