/*
 * Decompiled with CFR 0.152.
 */
package dream.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class WrappedCollection
extends AbstractCollection {
    private Collection baseCollection;
    private Class wrapper;

    public WrappedCollection(Collection base, Class wrapper) {
        this.baseCollection = base;
        this.wrapper = wrapper;
    }

    public Iterator iterator() {
        return new ConverterIterator(this.baseCollection.iterator());
    }

    public int size() {
        return this.baseCollection.size();
    }

    private class ConverterIterator
    implements Iterator {
        private Iterator i;
        private final Constructor cons;

        public ConverterIterator(Iterator i) {
            Constructor c = null;
            this.i = i;
            Class[] constype = new Class[]{new Object().getClass()};
            try {
                if (WrappedCollection.this.wrapper != null) {
                    c = WrappedCollection.this.wrapper.getConstructor(constype);
                }
            }
            catch (NoSuchMethodException e) {
                c = null;
            }
            this.cons = c;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            Object o = this.i.next();
            if (this.cons == null) {
                return o;
            }
            Object[] consarg = new Object[]{o};
            try {
                return this.cons.newInstance(consarg);
            }
            catch (IllegalAccessException e) {
                return o;
            }
            catch (InstantiationException e) {
                return o;
            }
            catch (InvocationTargetException e) {
                return o;
            }
        }
    }
}

