/*
 * Decompiled with CFR 0.152.
 */
package jscl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.im.InputContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jscl.editor.Editor;
import jscl.editor.MathTextPane;
import jscl.math.Debug;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.mathml.MathML;
import jscl.text.ParseException;
import net.sourceforge.jeuclid.DOMMathBuilder;
import net.sourceforge.jeuclid.MathBase;
import org.jdesktop.layout.GroupLayout;

public class Editor
extends JFrame {
    UndoManager undo = new UndoManager();
    UndoableEditListener undoHandler = new UndoHandler();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    Action newAction = new NewAction();
    Action openAction = new OpenAction();
    Action saveAction = new SaveAction();
    Action saveAsAction = new SaveAsAction();
    Action exportToXHTMLAction = new ExportToXHTMLAction();
    Action copyToWikiAction = new CopyToWikiAction();
    Action expandAction = new ExpandAction();
    Action factorizeAction = new FactorizeAction();
    Action elementaryAction = new ElementaryAction();
    Action simplifyAction = new SimplifyAction();
    Action numericAction = new NumericAction();
    Action toJavaAction = new ToJavaAction();
    Action toMathMLAction = new ToMathMLAction();
    JFileChooser chooser = new JFileChooser();
    StyledDocument doc;
    File file;
    File xhtmlfile;
    boolean proceed;
    boolean overwrite;
    boolean modified;
    boolean found;
    private Map actions;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    private JButton jButton17;
    private JButton jButton18;
    private JButton jButton19;
    private JButton jButton2;
    private JButton jButton20;
    private JButton jButton21;
    private JButton jButton22;
    private JButton jButton23;
    private JButton jButton24;
    private JButton jButton25;
    private JButton jButton26;
    private JButton jButton27;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JDialog jDialog1;
    private JDialog jDialog2;
    private JDialog jDialog3;
    private JDialog jDialog4;
    private JDialog jDialog5;
    private JDialog jDialog6;
    private JDialog jDialog7;
    private JDialog jDialog8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem18;
    private JMenuItem jMenuItem19;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem20;
    private JMenuItem jMenuItem21;
    private JMenuItem jMenuItem22;
    private JMenuItem jMenuItem23;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JToolBar jToolBar4;
    private MathTextPane mathTextPane1;

    public Editor(File file) {
        this.file = file;
        this.initComponents();
        this.jDialog1.pack();
        this.jDialog2.pack();
        this.jDialog4.pack();
        this.jDialog5.pack();
        this.jDialog6.pack();
        this.jDialog7.pack();
        this.jDialog8.pack();
        Dimension size = this.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(Math.min(size.width, screen.width), Math.min(size.height, screen.height));
        this.setLocation(screen.width - size.width >> 1, screen.height - size.height >> 1);
        this.mathTextPane1.requestFocus();
        this.mathTextPane1.setFont(new Font("monospaced", 0, 12));
        this.mathTextPane1.setTransferHandler(new MathTransferHandler());
        this.doc = this.mathTextPane1.getStyledDocument();
        this.doc.addUndoableEditListener(this.undoHandler);
        if (file != null) {
            this.chooser.setCurrentDirectory(file.getParentFile());
            this.chooser.setSelectedFile(file);
            this.open();
        }
    }

    void open() {
        if (this.file.exists()) {
            new FileLoader().start();
        }
    }

    private void createActionTable(JTextComponent textComponent) {
        this.actions = new HashMap();
        Action[] actionsArray = textComponent.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            this.actions.put(a.getValue("Name"), a);
        }
    }

    private Action getActionByName(String name) {
        if (this.actions == null) {
            this.createActionTable(this.mathTextPane1);
        }
        return (Action)this.actions.get(name);
    }

    public Action getCutAction() {
        return this.getActionByName("cut-to-clipboard");
    }

    public Action getCopyAction() {
        return this.getActionByName("copy-to-clipboard");
    }

    public Action getPasteAction() {
        return this.getActionByName("paste-from-clipboard");
    }

    public Action getSelectAllAction() {
        return this.getActionByName("select-all");
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
        this.setTitle((this.file == null ? "Untitled" : this.file.getName()) + (modified ? " (Modified)" : ""));
    }

    String read() throws IOException {
        char[] data = new char[(int)this.file.length()];
        FileReader in = new FileReader(this.file);
        in.read(data);
        ((Reader)in).close();
        return new String(data);
    }

    void write(String data) throws IOException {
        FileWriter out = new FileWriter(this.file);
        out.write(data);
        ((Writer)out).close();
    }

    void write(MathML document) {
        document.write(this.xhtmlfile.toURI().toString());
    }

    void showException(Throwable ex) {
        if (Debug.getOutputStream() == null) {
            this.jLabel4.setText(ex.toString());
            this.jDialog3.pack();
            this.setDialogLocation(this.jDialog3);
            this.jDialog3.setVisible(true);
        } else {
            ex.printStackTrace();
        }
        Debug.reset();
    }

    static boolean bracketed(String str) {
        return str.length() >= 4 && str.substring(0, 2).equals("[[") && str.substring(str.length() - 2).equals("]]");
    }

    static String unbracket(String s) {
        return s.substring(2, s.length() - 2);
    }

    String createWiki(int offset, int length) throws BadLocationException, ParseException {
        StringBuffer b = new StringBuffer();
        String str = this.doc.getText(offset, length);
        int n = 0;
        int m = 0;
        while (true) {
            if ((n = str.indexOf(32, n)) == -1) break;
            ImageIcon icon = Editor.getIcon(this.doc, offset + n);
            if (icon != null) {
                b.append(str.substring(m, n));
                b.append(Expression.valueOf(icon.getDescription()).toMathML());
                m = n + 1;
            }
            ++n;
        }
        n = str.length();
        b.append(str.substring(m, n));
        return b.toString().replaceAll("\n", "<br/>\n");
    }

    File changeExtension(File file) {
        String name = file.getPath();
        int n = name.lastIndexOf(46);
        if (n == -1) {
            n = name.length();
        }
        name = name.substring(0, n) + ".xhtml";
        return new File(name);
    }

    void createXHTML(MathML element) throws BadLocationException, ParseException {
        String str = this.doc.getText(0, this.doc.getLength());
        int n = 0;
        int m = 0;
        while (true) {
            if ((n = str.indexOf(32, n)) == -1) break;
            ImageIcon icon = Editor.getIcon(this.doc, 0 + n);
            if (icon != null) {
                this.createXHTMLText(element, str.substring(m, n));
                MathML e = element.element("math");
                e.setAttribute("xmlns", "http://www.w3.org/1998/Math/MathML");
                Expression.valueOf(icon.getDescription()).toMathML(e, null);
                element.appendChild(e);
                m = n + 1;
            }
            ++n;
        }
        n = str.length();
        this.createXHTMLText(element, str.substring(m, n));
    }

    void createXHTMLText(MathML element, String str) {
        int n = 0;
        int m = 0;
        while (true) {
            if ((n = str.indexOf(10, n)) == -1) break;
            element.appendChild(element.text(str.substring(m, n)));
            element.appendChild(element.element("br"));
            element.appendChild(element.text("\n"));
            m = n + 1;
            ++n;
        }
        n = str.length();
        element.appendChild(element.text(str.substring(m, n)));
    }

    static String createText(StyledDocument doc, int offset, int length) throws BadLocationException {
        StringBuffer b = new StringBuffer();
        String str = doc.getText(offset, length);
        int n = 0;
        int m = 0;
        while (true) {
            if ((n = str.indexOf(32, n)) == -1) break;
            ImageIcon icon = Editor.getIcon(doc, offset + n);
            if (icon != null) {
                b.append(str.substring(m, n));
                b.append("[[" + icon.getDescription() + "]]");
                m = n + 1;
            }
            ++n;
        }
        n = str.length();
        b.append(str.substring(m, n));
        return b.toString();
    }

    static ImageIcon getIcon(StyledDocument doc, int offset) {
        Element e = doc.getCharacterElement(offset);
        AttributeSet s = e.getAttributes();
        ImageIcon icon = (ImageIcon)StyleConstants.getIcon(s);
        return icon;
    }

    static void replaceSelection(JTextPane comp, String str) {
        MathExpressionMatcher pm = new MathExpressionMatcher(str);
        int n = 0;
        while (pm.find()) {
            int m = pm.start();
            comp.replaceSelection(str.substring(n, m));
            try {
                comp.insertIcon(Editor.createImageIcon(Editor.unbracket(pm.group())));
            }
            catch (ParseException ex) {
                comp.replaceSelection(pm.group());
            }
            n = pm.end();
        }
        comp.replaceSelection(str.substring(n));
    }

    static ImageIcon createImageIcon(String text) throws ParseException {
        MathBase base = new MathBase();
        Logger log = MathBase.getJeuclidLogger();
        MathML document = new MathML("math", "-//W3C//DTD MathML 2.0//EN", "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd");
        MathML e = document.element("math");
        Expression.valueOf(text).toMathML(e, null);
        document.appendChild(e);
        new DOMMathBuilder(document.document(), log, base);
        BufferedImage tempimage = new BufferedImage(1, 1, 2);
        Graphics tempg = tempimage.getGraphics();
        int width = base.getWidth(tempg);
        int height = base.getHeight(tempg);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color transparency = new Color(255, 255, 255, 0);
        g.setColor(transparency);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        base.paint((Graphics)g);
        return new ImageIcon(image, text);
    }

    void setDialogLocation(Component dialog) {
        Point location = this.getLocation();
        Dimension size = this.getSize();
        Dimension s = dialog.getSize();
        location.translate(size.width - s.width >> 1, size.height - s.height >> 1);
        dialog.setLocation(location);
    }

    boolean findNext(String dstData, boolean wrap) {
        String t = this.mathTextPane1.getText();
        boolean b = dstData.equals(" ");
        int n = t.indexOf(dstData, this.mathTextPane1.getSelectionEnd());
        if (b) {
            while (n != -1 && Editor.getIcon(this.doc, n) != null) {
                n = t.indexOf(dstData, n + 1);
            }
        }
        if (wrap && n == -1) {
            n = t.indexOf(dstData);
        }
        if (b) {
            while (n != -1 && Editor.getIcon(this.doc, n) != null) {
                n = t.indexOf(dstData, n + 1);
            }
        }
        if (n == -1) {
            return false;
        }
        this.mathTextPane1.select(n, n + dstData.length());
        return true;
    }

    boolean findFirst(String dstData) {
        String t = this.mathTextPane1.getText();
        boolean b = dstData.equals(" ");
        int n = t.indexOf(dstData);
        if (b) {
            while (n != -1 && Editor.getIcon(this.doc, n) != null) {
                n = t.indexOf(dstData, n + 1);
            }
        }
        if (n == -1) {
            return false;
        }
        this.mathTextPane1.select(n, n + dstData.length());
        return true;
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jButton10 = new JButton();
        this.jDialog2 = new JDialog(this);
        this.jLabel3 = new JLabel();
        this.jDialog3 = new JDialog(this);
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton11 = new JButton();
        this.jDialog4 = new JDialog(this);
        this.jLabel5 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jPanel2 = new JPanel();
        this.jButton12 = new JButton();
        this.jButton13 = new JButton();
        this.jDialog5 = new JDialog(this);
        this.jLabel6 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton14 = new JButton();
        this.jButton15 = new JButton();
        this.jButton16 = new JButton();
        this.jButton17 = new JButton();
        this.jDialog6 = new JDialog(this);
        this.jLabel8 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jButton18 = new JButton();
        this.jButton19 = new JButton();
        this.jDialog7 = new JDialog(this);
        this.jLabel9 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jButton21 = new JButton();
        this.jButton22 = new JButton();
        this.jDialog8 = new JDialog(this);
        this.jLabel10 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jButton20 = new JButton();
        this.jToolBar2 = new JToolBar();
        this.jButton4 = new JButton();
        this.jButton23 = new JButton();
        this.jButton24 = new JButton();
        this.jButton25 = new JButton();
        this.jButton26 = new JButton();
        this.jButton27 = new JButton();
        this.jToolBar3 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jToolBar4 = new JToolBar();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.mathTextPane1 = new MathTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem23 = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.jMenuItem3 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItem14 = new JMenuItem();
        this.jMenuItem15 = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuItem12 = new JMenuItem();
        this.jMenuItem13 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem16 = new JMenuItem();
        this.jMenuItem17 = new JMenuItem();
        this.jMenuItem18 = new JMenuItem();
        this.jMenuItem19 = new JMenuItem();
        this.jMenuItem20 = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.jMenuItem22 = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.jMenuItem21 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenuItem11 = new JMenuItem();
        this.jDialog1.setTitle("About");
        this.jDialog1.setResizable(false);
        this.jLabel1.setText("jscl-meditor : java symbolic computing library and mathematical editor");
        this.jLabel2.setText("Copyright (C) 2000-2007 Raphael Jolly");
        this.jButton10.setText("Ok");
        this.jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton10ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton10);
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout((LayoutManager)jDialog1Layout);
        jDialog1Layout.setHorizontalGroup((GroupLayout.Group)jDialog1Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog1Layout.createSequentialGroup().add(2, 2, 2).add((GroupLayout.Group)jDialog1Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)).add((Component)this.jPanel3, -1, 459, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup((GroupLayout.Group)jDialog1Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2)));
        this.jDialog2.setDefaultCloseOperation(0);
        this.jDialog2.setBackground(Color.white);
        this.jDialog2.setModal(true);
        this.jDialog2.setResizable(false);
        this.jLabel3.setText("Working...");
        GroupLayout jDialog2Layout = new GroupLayout(this.jDialog2.getContentPane());
        this.jDialog2.getContentPane().setLayout((LayoutManager)jDialog2Layout);
        jDialog2Layout.setHorizontalGroup((GroupLayout.Group)jDialog2Layout.createParallelGroup(1).add((Component)this.jLabel3));
        jDialog2Layout.setVerticalGroup((GroupLayout.Group)jDialog2Layout.createParallelGroup(1).add((Component)this.jLabel3));
        this.jDialog3.setModal(true);
        this.jDialog3.setResizable(false);
        this.jLabel4.setText("Error");
        this.jButton11.setText("Ok");
        this.jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton11ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton11);
        GroupLayout jDialog3Layout = new GroupLayout(this.jDialog3.getContentPane());
        this.jDialog3.getContentPane().setLayout((LayoutManager)jDialog3Layout);
        jDialog3Layout.setHorizontalGroup((GroupLayout.Group)jDialog3Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog3Layout.createSequentialGroup().add((Component)this.jLabel4).addContainerGap(32, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        jDialog3Layout.setVerticalGroup((GroupLayout.Group)jDialog3Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog3Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2)));
        this.jDialog4.setTitle("Find");
        this.jDialog4.setResizable(false);
        this.jLabel5.setText("Find :");
        this.jButton12.setText("Next");
        this.jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton12ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton12);
        this.jButton13.setText("Done");
        this.jButton13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton13ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton13);
        GroupLayout jDialog4Layout = new GroupLayout(this.jDialog4.getContentPane());
        this.jDialog4.getContentPane().setLayout((LayoutManager)jDialog4Layout);
        jDialog4Layout.setHorizontalGroup((GroupLayout.Group)jDialog4Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog4Layout.createSequentialGroup().add((Component)this.jLabel5).addContainerGap(301, Short.MAX_VALUE)).add((Component)this.jTextField1, -1, 335, Short.MAX_VALUE).add((Component)this.jPanel2, -1, 335, Short.MAX_VALUE));
        jDialog4Layout.setVerticalGroup((GroupLayout.Group)jDialog4Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog4Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextField1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)));
        this.jDialog5.setTitle("Replace");
        this.jDialog5.setResizable(false);
        this.jLabel6.setText("Find :");
        this.jLabel7.setText("Replace with :");
        this.jButton14.setText("Next");
        this.jButton14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton14ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton14);
        this.jButton15.setText("Replace");
        this.jButton15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton15ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton15);
        this.jButton16.setText("Replace all");
        this.jButton16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton16ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton16);
        this.jButton17.setText("Done");
        this.jButton17.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton17ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton17);
        GroupLayout jDialog5Layout = new GroupLayout(this.jDialog5.getContentPane());
        this.jDialog5.getContentPane().setLayout((LayoutManager)jDialog5Layout);
        jDialog5Layout.setHorizontalGroup((GroupLayout.Group)jDialog5Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog5Layout.createSequentialGroup().add((Component)this.jLabel6).addContainerGap(301, Short.MAX_VALUE)).add((Component)this.jTextField2, -1, 335, Short.MAX_VALUE).add((GroupLayout.Group)jDialog5Layout.createSequentialGroup().add((Component)this.jLabel7).addContainerGap()).add((Component)this.jTextField3, -1, 335, Short.MAX_VALUE).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE));
        jDialog5Layout.setVerticalGroup((GroupLayout.Group)jDialog5Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog5Layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jTextField2, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.jTextField3, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2)));
        this.jDialog6.setModal(true);
        this.jDialog6.setResizable(false);
        this.jLabel8.setText("Changes have not been saved. Proceed anyway ?");
        this.jButton18.setText("Ok");
        this.jButton18.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton18ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton18);
        this.jButton19.setText("Cancel");
        this.jButton19.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton19ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton19);
        GroupLayout jDialog6Layout = new GroupLayout(this.jDialog6.getContentPane());
        this.jDialog6.getContentPane().setLayout((LayoutManager)jDialog6Layout);
        jDialog6Layout.setHorizontalGroup((GroupLayout.Group)jDialog6Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog6Layout.createSequentialGroup().add((Component)this.jLabel8).addContainerGap(-1, Short.MAX_VALUE)).add((Component)this.jPanel5, -1, 314, Short.MAX_VALUE));
        jDialog6Layout.setVerticalGroup((GroupLayout.Group)jDialog6Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog6Layout.createSequentialGroup().add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.jPanel5, -2, -1, -2)));
        this.jDialog7.setModal(true);
        this.jDialog7.setResizable(false);
        this.jLabel9.setText("The file already exists. Overwrite ?");
        this.jButton21.setText("Ok");
        this.jButton21.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton21ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton21);
        this.jButton22.setText("Cancel");
        this.jButton22.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton22ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton22);
        GroupLayout jDialog7Layout = new GroupLayout(this.jDialog7.getContentPane());
        this.jDialog7.getContentPane().setLayout((LayoutManager)jDialog7Layout);
        jDialog7Layout.setHorizontalGroup((GroupLayout.Group)jDialog7Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog7Layout.createSequentialGroup().add((Component)this.jLabel9).addContainerGap(-1, Short.MAX_VALUE)).add((Component)this.jPanel6, -1, 227, Short.MAX_VALUE));
        jDialog7Layout.setVerticalGroup((GroupLayout.Group)jDialog7Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog7Layout.createSequentialGroup().add((Component)this.jLabel9).addPreferredGap(0).add((Component)this.jPanel6, -2, -1, -2)));
        this.jDialog8.setModal(true);
        this.jDialog8.setResizable(false);
        this.jLabel10.setText("The file doesn't exist.");
        this.jButton20.setText("Ok");
        this.jButton20.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jButton20ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton20);
        GroupLayout jDialog8Layout = new GroupLayout(this.jDialog8.getContentPane());
        this.jDialog8.getContentPane().setLayout((LayoutManager)jDialog8Layout);
        jDialog8Layout.setHorizontalGroup((GroupLayout.Group)jDialog8Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog8Layout.createSequentialGroup().add((Component)this.jLabel10).addContainerGap(-1, Short.MAX_VALUE)).add((Component)this.jPanel7, -1, 146, Short.MAX_VALUE));
        jDialog8Layout.setVerticalGroup((GroupLayout.Group)jDialog8Layout.createParallelGroup(1).add((GroupLayout.Group)jDialog8Layout.createSequentialGroup().add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.jPanel7, -2, -1, -2)));
        this.setDefaultCloseOperation(0);
        this.setTitle("meditor");
        this.setForeground(Color.white);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Editor.this.formWindowClosing(evt);
            }
        });
        this.jButton4.setAction(this.toMathMLAction);
        this.jButton4.setText("Ma");
        this.jButton4.setToolTipText("To MathML");
        this.jToolBar2.add(this.jButton4);
        this.jButton23.setAction(this.expandAction);
        this.jButton23.setText("Ex");
        this.jButton23.setToolTipText("Expand");
        this.jToolBar2.add(this.jButton23);
        this.jButton24.setAction(this.factorizeAction);
        this.jButton24.setText("Fc");
        this.jButton24.setToolTipText("Factorize");
        this.jToolBar2.add(this.jButton24);
        this.jButton25.setAction(this.elementaryAction);
        this.jButton25.setText("El");
        this.jButton25.setToolTipText("Elementary");
        this.jToolBar2.add(this.jButton25);
        this.jButton26.setAction(this.simplifyAction);
        this.jButton26.setText("Sy");
        this.jButton26.setToolTipText("Simplify");
        this.jToolBar2.add(this.jButton26);
        this.jButton27.setAction(this.numericAction);
        this.jButton27.setText("Nu");
        this.jButton27.setToolTipText("Numeric");
        this.jToolBar2.add(this.jButton27);
        this.jButton1.setAction(this.getCutAction());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/cut.gif")));
        this.jButton1.setText("");
        this.jButton1.setToolTipText("Cut");
        this.jToolBar3.add(this.jButton1);
        this.jButton2.setAction(this.getCopyAction());
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/copy.gif")));
        this.jButton2.setText("");
        this.jButton2.setToolTipText("Copy");
        this.jToolBar3.add(this.jButton2);
        this.jButton3.setAction(this.getPasteAction());
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/paste.gif")));
        this.jButton3.setText("");
        this.jButton3.setToolTipText("Paste");
        this.jToolBar3.add(this.jButton3);
        this.jButton8.setAction(this.getUndoAction());
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/undo.gif")));
        this.jButton8.setToolTipText("Undo");
        this.jToolBar3.add(this.jButton8);
        this.jButton9.setAction(this.getRedoAction());
        this.jButton9.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/redo.gif")));
        this.jButton9.setToolTipText("Redo");
        this.jToolBar3.add(this.jButton9);
        this.jButton5.setAction(this.newAction);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/newFile.gif")));
        this.jButton5.setText("");
        this.jButton5.setToolTipText("New");
        this.jToolBar4.add(this.jButton5);
        this.jButton6.setAction(this.openAction);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/openFile.gif")));
        this.jButton6.setText("");
        this.jButton6.setToolTipText("Open");
        this.jToolBar4.add(this.jButton6);
        this.jButton7.setAction(this.saveAction);
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/saveFile.gif")));
        this.jButton7.setText("");
        this.jButton7.setToolTipText("Save");
        this.jToolBar4.add(this.jButton7);
        this.jScrollPane1.setViewportView(this.mathTextPane1);
        this.jMenu1.setText("File");
        this.jMenuItem1.setAction(this.newAction);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/newFile.gif")));
        this.jMenuItem1.setText("New");
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAction(this.openAction);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/openFile.gif")));
        this.jMenuItem2.setText("Open...");
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem9.setAction(this.saveAction);
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem9.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/saveFile.gif")));
        this.jMenuItem9.setText("Save");
        this.jMenu1.add(this.jMenuItem9);
        this.jMenuItem10.setAction(this.saveAsAction);
        this.jMenuItem10.setText("Save as...");
        this.jMenu1.add(this.jMenuItem10);
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem23.setAction(this.exportToXHTMLAction);
        this.jMenuItem23.setText("Export to XHTML...");
        this.jMenu1.add(this.jMenuItem23);
        this.jMenu1.add(this.jSeparator7);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.jMenuItem3.setText("Exit");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuItem4.setAction(this.getCutAction());
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItem4.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/cut.gif")));
        this.jMenuItem4.setText("Cut");
        this.jMenu2.add(this.jMenuItem4);
        this.jMenuItem5.setAction(this.getCopyAction());
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem5.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/copy.gif")));
        this.jMenuItem5.setText("Copy");
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuItem6.setAction(this.getPasteAction());
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem6.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/paste.gif")));
        this.jMenuItem6.setText("Paste");
        this.jMenu2.add(this.jMenuItem6);
        this.jMenu2.add(this.jSeparator2);
        this.jMenuItem7.setAction(this.getSelectAllAction());
        this.jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuItem7.setText("Select all");
        this.jMenu2.add(this.jMenuItem7);
        this.jMenu2.add(this.jSeparator3);
        this.jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuItem14.setText("Find...");
        this.jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jMenuItem14ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem14);
        this.jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.jMenuItem15.setText("Replace...");
        this.jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jMenuItem15ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem15);
        this.jMenu2.add(this.jSeparator4);
        this.jMenuItem12.setAction(this.getUndoAction());
        this.jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuItem12.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/undo.gif")));
        this.jMenuItem12.setText("Undo");
        this.jMenu2.add(this.jMenuItem12);
        this.jMenuItem13.setAction(this.getRedoAction());
        this.jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuItem13.setIcon(new ImageIcon(this.getClass().getResource("/jscl/editor/resources/redo.gif")));
        this.jMenuItem13.setText("Redo");
        this.jMenu2.add(this.jMenuItem13);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Math");
        this.jMenuItem16.setAction(this.expandAction);
        this.jMenuItem16.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItem16.setText("Expand");
        this.jMenu3.add(this.jMenuItem16);
        this.jMenuItem17.setAction(this.factorizeAction);
        this.jMenuItem17.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.jMenuItem17.setText("Factorize");
        this.jMenu3.add(this.jMenuItem17);
        this.jMenuItem18.setAction(this.elementaryAction);
        this.jMenuItem18.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItem18.setText("Elementary");
        this.jMenu3.add(this.jMenuItem18);
        this.jMenuItem19.setAction(this.simplifyAction);
        this.jMenuItem19.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem19.setText("Simplify");
        this.jMenu3.add(this.jMenuItem19);
        this.jMenuItem20.setAction(this.numericAction);
        this.jMenuItem20.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.jMenuItem20.setText("Numeric");
        this.jMenu3.add(this.jMenuItem20);
        this.jMenu3.add(this.jSeparator5);
        this.jMenuItem22.setAction(this.copyToWikiAction);
        this.jMenuItem22.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.jMenuItem22.setText("Copy To meditorworld");
        this.jMenu3.add(this.jMenuItem22);
        this.jMenu3.add(this.jSeparator6);
        this.jMenuItem21.setAction(this.toJavaAction);
        this.jMenuItem21.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.jMenuItem21.setText("To Java");
        this.jMenu3.add(this.jMenuItem21);
        this.jMenuItem8.setAction(this.toMathMLAction);
        this.jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jMenuItem8.setText("To MathML");
        this.jMenu3.add(this.jMenuItem8);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu4.setText("Help");
        this.jMenuItem11.setText("About...");
        this.jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Editor.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem11);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar4, -2, 100, -2).addPreferredGap(0).add((Component)this.jToolBar3, -2, -1, -2).addPreferredGap(0).add((Component)this.jToolBar2, -2, -1, -2).addContainerGap(122, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 569, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jToolBar4, -2, 25, -2).add((Component)this.jToolBar3, -2, 25, -2).add((Component)this.jToolBar2, -2, 25, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 384, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton20ActionPerformed(ActionEvent evt) {
        this.jDialog8.setVisible(false);
    }

    private void jButton22ActionPerformed(ActionEvent evt) {
        this.overwrite = false;
        this.jDialog7.setVisible(false);
    }

    private void jButton21ActionPerformed(ActionEvent evt) {
        this.overwrite = true;
        this.jDialog7.setVisible(false);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        if (this.modified) {
            this.proceed = false;
            this.setDialogLocation(this.jDialog6);
            this.jDialog6.setVisible(true);
        } else {
            this.proceed = true;
        }
        if (this.proceed) {
            System.exit(0);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.modified) {
            this.proceed = false;
            this.setDialogLocation(this.jDialog6);
            this.jDialog6.setVisible(true);
        } else {
            this.proceed = true;
        }
        if (this.proceed) {
            System.exit(0);
        }
    }

    private void jButton19ActionPerformed(ActionEvent evt) {
        this.proceed = false;
        this.jDialog6.setVisible(false);
    }

    private void jButton18ActionPerformed(ActionEvent evt) {
        this.proceed = true;
        this.jDialog6.setVisible(false);
    }

    private void jMenuItem15ActionPerformed(ActionEvent evt) {
        this.setDialogLocation(this.jDialog5);
        this.jDialog5.setVisible(true);
    }

    private void jButton17ActionPerformed(ActionEvent evt) {
        this.jDialog5.setVisible(false);
    }

    private void jButton16ActionPerformed(ActionEvent evt) {
        this.found = this.findFirst(this.jTextField2.getText());
        while (this.found) {
            this.mathTextPane1.replaceSelection(this.jTextField3.getText());
            this.found = this.findNext(this.jTextField2.getText(), false);
        }
    }

    private void jButton15ActionPerformed(ActionEvent evt) {
        if (this.found) {
            this.mathTextPane1.replaceSelection(this.jTextField3.getText());
            this.found = this.findNext(this.jTextField2.getText(), true);
        }
    }

    private void jButton14ActionPerformed(ActionEvent evt) {
        this.found = this.findNext(this.jTextField2.getText(), true);
    }

    private void jMenuItem14ActionPerformed(ActionEvent evt) {
        this.setDialogLocation(this.jDialog4);
        this.jDialog4.setVisible(true);
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        this.jDialog4.setVisible(false);
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        this.findNext(this.jTextField1.getText(), true);
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.jDialog1.setVisible(false);
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.jDialog3.setVisible(false);
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        this.setDialogLocation(this.jDialog1);
        this.jDialog1.setVisible(true);
    }

    public static void main(String[] args) {
        int n = 0;
        if (args.length > n && args[n].compareTo("-usage") == 0) {
            System.out.println("Usage: java jscl.editor.Editor [-debug] [file]");
            System.exit(0);
        }
        while (args.length > n && args[n].compareTo("-debug") == 0) {
            Debug.setOutputStream(System.out);
            ++n;
        }
        final File file = args.length > n ? new File(args[n]) : null;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Editor(file).setVisible(true);
            }
        });
    }

    static /* synthetic */ JDialog access$400(Editor x0) {
        return x0.jDialog2;
    }

    static class MathTransferHandler
    extends TransferHandler {
        MathTransferHandler() {
        }

        public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) {
            int p1;
            JTextComponent text;
            int p0;
            if (comp instanceof JTextComponent && (p0 = (text = (JTextComponent)comp).getSelectionStart()) != (p1 = text.getSelectionEnd())) {
                try {
                    StyledDocument doc = (StyledDocument)text.getDocument();
                    String srcData = Editor.createText(doc, p0, p1 - p0);
                    StringSelection contents = new StringSelection(srcData);
                    clipboard.setContents(contents, null);
                    if (action == 2) {
                        doc.remove(p0, p1 - p0);
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
        }

        public boolean importData(JComponent comp, Transferable t) {
            DataFlavor flavor;
            if (comp instanceof JTextComponent && (flavor = this.getFlavor(t.getTransferDataFlavors())) != null) {
                InputContext ic = comp.getInputContext();
                if (ic != null) {
                    ic.endComposition();
                }
                try {
                    String data = (String)t.getTransferData(flavor);
                    Editor.replaceSelection((JTextPane)comp, data);
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            JTextComponent c = (JTextComponent)comp;
            if (!c.isEditable() || !c.isEnabled()) {
                return false;
            }
            return this.getFlavor(transferFlavors) != null;
        }

        public int getSourceActions(JComponent c) {
            return 0;
        }

        private DataFlavor getFlavor(DataFlavor[] flavors) {
            if (flavors != null) {
                for (int counter = 0; counter < flavors.length; ++counter) {
                    if (!flavors[counter].equals(DataFlavor.stringFlavor)) continue;
                    return flavors[counter];
                }
            }
            return null;
        }
    }

    static class MathExpressionMatcher {
        String text;
        int m;
        int n;

        MathExpressionMatcher(String text) {
            this.text = text;
        }

        boolean find() {
            this.m = this.text.substring(this.n).indexOf("[[");
            if (this.m == -1) {
                return false;
            }
            this.m += this.n;
            this.n = this.m;
            int r = 0;
            int l = this.text.length();
            while (this.n < l) {
                if (this.text.charAt(this.n) == '[') {
                    ++r;
                } else if (this.text.charAt(this.n) == ']') {
                    --r;
                }
                ++this.n;
                if (r != 0) continue;
                return true;
            }
            return false;
        }

        int start() {
            return this.m;
        }

        int end() {
            return this.n;
        }

        String group() {
            return this.text.substring(this.m, this.n);
        }
    }

    class ExportToXHTMLAction
    extends StyledEditorKit.StyledTextAction {
        ExportToXHTMLAction() {
            super("export-to-xhtml");
        }

        public void actionPerformed(ActionEvent e) {
            Editor.this.chooser.setSelectedFile(Editor.this.file == null ? new File("") : Editor.this.changeExtension(Editor.this.file));
            if (Editor.this.chooser.showSaveDialog(Editor.this) != 0) {
                return;
            }
            File f = Editor.this.chooser.getSelectedFile();
            if (f.exists()) {
                Editor.this.overwrite = false;
                Editor.this.setDialogLocation(Editor.this.jDialog7);
                Editor.this.jDialog7.setVisible(true);
            } else {
                Editor.this.overwrite = true;
            }
            if (Editor.this.overwrite) {
                Editor.this.xhtmlfile = f;
                try {
                    MathML document = new MathML("html", "-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN", "http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd");
                    MathML e0 = document.element("html");
                    e0.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                    Editor.this.createXHTML(e0);
                    document.appendChild(e0);
                    new FileSaver(document).start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class CopyToWikiAction
    extends StyledEditorKit.StyledTextAction {
        CopyToWikiAction() {
            super("copy-to-wiki");
        }

        public void actionPerformed(ActionEvent e) {
            int p1;
            int p0 = Editor.this.mathTextPane1.getSelectionStart();
            if (p0 != (p1 = Editor.this.mathTextPane1.getSelectionEnd())) {
                try {
                    String srcData = Editor.this.createWiki(p0, p1 - p0);
                    StringSelection contents = new StringSelection(srcData);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public class ToMathMLAction
    extends MathAction {
        ToMathMLAction() {
            super("to-mathml");
        }

        String process(String text) throws ParseException {
            if (Editor.bracketed(text)) {
                return Editor.unbracket(text);
            }
            Expression in = Expression.valueOf(text);
            return "[[" + text + "]]";
        }

        Generic process(Generic in) {
            return null;
        }
    }

    class ToJavaAction
    extends MathAction {
        ToJavaAction() {
            super("to-java");
        }

        String process(String text) throws ParseException {
            Expression in = Expression.valueOf(Editor.bracketed(text) ? Editor.unbracket(text) : text);
            return ((Generic)in).toJava();
        }

        Generic process(Generic in) {
            return null;
        }
    }

    class NumericAction
    extends MathAction {
        NumericAction() {
            super("numeric");
        }

        Generic process(Generic in) {
            return in.numeric();
        }
    }

    class SimplifyAction
    extends MathAction {
        SimplifyAction() {
            super("simplify");
        }

        Generic process(Generic in) {
            return in.simplify();
        }
    }

    class ElementaryAction
    extends MathAction {
        ElementaryAction() {
            super("elementary");
        }

        Generic process(Generic in) {
            return in.elementary();
        }
    }

    class FactorizeAction
    extends MathAction {
        FactorizeAction() {
            super("factorize");
        }

        Generic process(Generic in) {
            return in.factorize();
        }
    }

    public class ExpandAction
    extends MathAction {
        ExpandAction() {
            super("expand");
        }

        Generic process(Generic in) {
            return in.expand();
        }
    }

    abstract class MathAction
    extends StyledEditorKit.StyledTextAction {
        MathAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            int n1 = Editor.this.mathTextPane1.getSelectionStart();
            int n2 = Editor.this.mathTextPane1.getSelectionEnd();
            try {
                String text = Editor.createText(Editor.this.doc, n1, n2 - n1);
                new Thread(this, text){
                    private final /* synthetic */ String val$text;
                    private final /* synthetic */ MathAction this$1;
                    {
                        this.this$1 = this$1;
                        this.val$text = val$text;
                    }

                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                MathAction.access$800(7.access$700(this.this$2)).setDialogLocation(Editor.access$400(MathAction.access$800(7.access$700(this.this$2))));
                                Editor.access$400(MathAction.access$800(7.access$700(this.this$2))).setVisible(true);
                            }
                        });
                        try {
                            String result = this.this$1.process(this.val$text);
                            SwingUtilities.invokeLater(new Runnable(this, result){
                                private final /* synthetic */ String val$result;
                                private final /* synthetic */ 7 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$result = val$result;
                                }

                                public void run() {
                                    Editor.access$400(MathAction.access$800(7.access$700(this.this$2))).setVisible(false);
                                    Editor.replaceSelection(Editor.access$100(MathAction.access$800(7.access$700(this.this$2))), this.val$result);
                                }
                            });
                        }
                        catch (Throwable ex) {
                            SwingUtilities.invokeLater(new Runnable(this, ex){
                                private final /* synthetic */ Throwable val$ex;
                                private final /* synthetic */ 7 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$ex = val$ex;
                                }

                                public void run() {
                                    Editor.access$400(MathAction.access$800(7.access$700(this.this$2))).setVisible(false);
                                    MathAction.access$800(7.access$700(this.this$2)).showException(this.val$ex);
                                }
                            });
                        }
                    }

                    static /* synthetic */ MathAction access$700(7 x0) {
                        return x0.this$1;
                    }
                }.start();
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }

        String process(String text) throws ParseException {
            boolean b = Editor.bracketed(text);
            Expression in = Expression.valueOf(b ? Editor.unbracket(text) : text);
            Generic out = this.process(in);
            return b ? "[[" + out + "]]" : "" + out;
        }

        abstract Generic process(Generic var1);

        static /* synthetic */ Editor access$800(MathAction x0) {
            return x0.Editor.this;
        }
    }

    class SaveAsAction
    extends StyledEditorKit.StyledTextAction {
        SaveAsAction() {
            super("save-as");
        }

        public void actionPerformed(ActionEvent e) {
            Editor.this.chooser.setSelectedFile(Editor.this.file == null ? new File("") : Editor.this.file);
            if (Editor.this.chooser.showSaveDialog(Editor.this) != 0) {
                return;
            }
            File f = Editor.this.chooser.getSelectedFile();
            if (f.exists()) {
                Editor.this.overwrite = false;
                Editor.this.setDialogLocation(Editor.this.jDialog7);
                Editor.this.jDialog7.setVisible(true);
            } else {
                Editor.this.overwrite = true;
            }
            if (Editor.this.overwrite) {
                Editor.this.file = f;
                try {
                    String text = Editor.createText(Editor.this.doc, 0, Editor.this.doc.getLength());
                    new FileSaver(text).start();
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class FileSaver
    extends Thread {
        String text;
        MathML document;

        FileSaver(String text) {
            this.text = text;
        }

        FileSaver(MathML document) {
            this.document = document;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FileSaver this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    FileSaver.access$500(this.this$1).setDialogLocation(Editor.access$400(FileSaver.access$500(this.this$1)));
                    Editor.access$400(FileSaver.access$500(this.this$1)).setVisible(true);
                }
            });
            try {
                if (this.document == null) {
                    Editor.this.write(this.text);
                } else {
                    Editor.this.write(this.document);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ FileSaver this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Editor.access$400(FileSaver.access$500(this.this$1)).setVisible(false);
                        if (this.this$1.document == null) {
                            FileSaver.access$500(this.this$1).setModified(false);
                            FileSaver.access$500((FileSaver)this.this$1).saveAction.setEnabled(true);
                        }
                    }
                });
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(new Runnable(this, ex){
                    private final /* synthetic */ IOException val$ex;
                    private final /* synthetic */ FileSaver this$1;
                    {
                        this.this$1 = this$1;
                        this.val$ex = val$ex;
                    }

                    public void run() {
                        Editor.access$400(FileSaver.access$500(this.this$1)).setVisible(false);
                        FileSaver.access$500(this.this$1).showException(this.val$ex);
                    }
                });
            }
        }

        static /* synthetic */ Editor access$500(FileSaver x0) {
            return x0.Editor.this;
        }
    }

    class SaveAction
    extends StyledEditorKit.StyledTextAction {
        SaveAction() {
            super("save");
            this.setEnabled(Editor.this.file != null);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String text = Editor.createText(Editor.this.doc, 0, Editor.this.doc.getLength());
                new FileSaver(text).start();
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    class FileLoader
    extends Thread {
        FileLoader() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FileLoader this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    FileLoader.access$300(this.this$1).setDialogLocation(Editor.access$400(FileLoader.access$300(this.this$1)));
                    Editor.access$400(FileLoader.access$300(this.this$1)).setVisible(true);
                }
            });
            try {
                String result = Editor.this.read();
                SwingUtilities.invokeLater(new Runnable(this, result){
                    private final /* synthetic */ String val$result;
                    private final /* synthetic */ FileLoader this$1;
                    {
                        this.this$1 = this$1;
                        this.val$result = val$result;
                    }

                    public void run() {
                        Editor.access$400(FileLoader.access$300(this.this$1)).setVisible(false);
                        FileLoader.access$300((FileLoader)this.this$1).doc.removeUndoableEditListener(FileLoader.access$300((FileLoader)this.this$1).undoHandler);
                        Editor.access$100(FileLoader.access$300(this.this$1)).setStyledDocument(new DefaultStyledDocument());
                        FileLoader.access$300((FileLoader)this.this$1).doc = Editor.access$100(FileLoader.access$300(this.this$1)).getStyledDocument();
                        Editor.replaceSelection(Editor.access$100(FileLoader.access$300(this.this$1)), this.val$result);
                        Editor.access$100(FileLoader.access$300(this.this$1)).setCaretPosition(0);
                        FileLoader.access$300((FileLoader)this.this$1).doc.addUndoableEditListener(FileLoader.access$300((FileLoader)this.this$1).undoHandler);
                        FileLoader.access$300(this.this$1).resetUndoManager();
                        FileLoader.access$300(this.this$1).setModified(false);
                        FileLoader.access$300((FileLoader)this.this$1).saveAction.setEnabled(true);
                    }
                });
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(new Runnable(this, ex){
                    private final /* synthetic */ IOException val$ex;
                    private final /* synthetic */ FileLoader this$1;
                    {
                        this.this$1 = this$1;
                        this.val$ex = val$ex;
                    }

                    public void run() {
                        Editor.access$400(FileLoader.access$300(this.this$1)).setVisible(false);
                        FileLoader.access$300(this.this$1).showException(this.val$ex);
                    }
                });
            }
        }

        static /* synthetic */ Editor access$300(FileLoader x0) {
            return x0.Editor.this;
        }
    }

    class OpenAction
    extends StyledEditorKit.StyledTextAction {
        OpenAction() {
            super("open");
        }

        public void actionPerformed(ActionEvent e) {
            if (Editor.this.modified) {
                Editor.this.proceed = false;
                Editor.this.setDialogLocation(Editor.this.jDialog6);
                Editor.this.jDialog6.setVisible(true);
            } else {
                Editor.this.proceed = true;
            }
            if (Editor.this.proceed) {
                Editor.this.chooser.setSelectedFile(Editor.this.file == null ? new File("") : Editor.this.file);
                if (Editor.this.chooser.showOpenDialog(Editor.this) != 0) {
                    return;
                }
                File f = Editor.this.chooser.getSelectedFile();
                if (f.exists()) {
                    Editor.this.file = f;
                    new FileLoader().start();
                } else {
                    Editor.this.setDialogLocation(Editor.this.jDialog8);
                    Editor.this.jDialog8.setVisible(true);
                }
            }
        }
    }

    class NewAction
    extends StyledEditorKit.StyledTextAction {
        NewAction() {
            super("new");
        }

        public void actionPerformed(ActionEvent e) {
            if (Editor.this.modified) {
                Editor.this.proceed = false;
                Editor.this.setDialogLocation(Editor.this.jDialog6);
                Editor.this.jDialog6.setVisible(true);
            } else {
                Editor.this.proceed = true;
            }
            if (Editor.this.proceed) {
                Editor.this.file = null;
                Editor.this.doc.removeUndoableEditListener(Editor.this.undoHandler);
                Editor.this.mathTextPane1.setStyledDocument(new DefaultStyledDocument());
                Editor.this.doc = Editor.this.mathTextPane1.getStyledDocument();
                Editor.this.doc.addUndoableEditListener(Editor.this.undoHandler);
                Editor.this.resetUndoManager();
                Editor.this.setModified(false);
                Editor.this.saveAction.setEnabled(false);
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
            Editor.this.setModified(true);
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
            Editor.this.setModified(true);
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected class UndoHandler
    implements UndoableEditListener {
        protected UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            Editor.this.undo.addEdit(e.getEdit());
            Editor.this.undoAction.updateUndoState();
            Editor.this.redoAction.updateRedoState();
            Editor.this.setModified(true);
        }
    }
}

