/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import jscl.math.Factorization;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Literal;
import jscl.math.Matrix;
import jscl.math.NotDivisibleException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Rational;
import jscl.math.Simplification;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;
import jscl.mathml.MathML;
import jscl.text.ExpressionParser;
import jscl.text.ParseException;
import jscl.text.Parser;
import jscl.util.ArrayUtils;

public class Expression
extends Generic {
    Literal[] literal;
    JSCLInteger[] coef;
    int size;

    Expression() {
    }

    Expression(int size) {
        this.init(size);
    }

    public int size() {
        return this.size;
    }

    public Literal literal(int n) {
        return this.literal[n];
    }

    public JSCLInteger coef(int n) {
        return this.coef[n];
    }

    void init(int size) {
        this.literal = new Literal[size];
        this.coef = new JSCLInteger[size];
        this.size = size;
    }

    void resize(int size) {
        int length = this.literal.length;
        if (size < length) {
            Literal[] literal = new Literal[size];
            JSCLInteger[] coef = new JSCLInteger[size];
            System.arraycopy(this.literal, length - size, literal, 0, size);
            System.arraycopy(this.coef, length - size, coef, 0, size);
            this.literal = literal;
            this.coef = coef;
            this.size = size;
        }
    }

    public Expression add(Expression expression) {
        Literal l2;
        Expression ex = this.newinstance(this.size + expression.size);
        int i = ex.size;
        int i1 = this.size;
        int i2 = expression.size;
        Literal l1 = i1 > 0 ? this.literal[--i1] : null;
        Literal literal = l2 = i2 > 0 ? expression.literal[--i2] : null;
        while (l1 != null || l2 != null) {
            JSCLInteger en;
            int c;
            int n = l1 == null ? 1 : (c = l2 == null ? -1 : -l1.compareTo(l2));
            if (c < 0) {
                en = this.coef[i1];
                ex.literal[--i] = l1;
                ex.coef[i] = en;
                l1 = i1 > 0 ? this.literal[--i1] : null;
                continue;
            }
            if (c > 0) {
                en = expression.coef[i2];
                ex.literal[--i] = l2;
                ex.coef[i] = en;
                l2 = i2 > 0 ? expression.literal[--i2] : null;
                continue;
            }
            en = this.coef[i1].add(expression.coef[i2]);
            if (en.signum() != 0) {
                ex.literal[--i] = l1;
                ex.coef[i] = en;
            }
            l1 = i1 > 0 ? this.literal[--i1] : null;
            l2 = i2 > 0 ? expression.literal[--i2] : null;
        }
        ex.resize(ex.size - i);
        return ex;
    }

    public Generic add(Generic generic) {
        if (generic instanceof Expression) {
            return this.add((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.add(this.valueof(generic));
        }
        return generic.valueof(this).add(generic);
    }

    public Expression subtract(Expression expression) {
        return this.multiplyAndAdd(Literal.valueOf(), JSCLInteger.valueOf(-1L), expression);
    }

    public Generic subtract(Generic generic) {
        if (generic instanceof Expression) {
            return this.subtract((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.subtract(this.valueof(generic));
        }
        return generic.valueof(this).subtract(generic);
    }

    Expression multiplyAndAdd(Literal lit, JSCLInteger integer, Expression expression) {
        Literal l2;
        if (integer.signum() == 0) {
            return this;
        }
        Expression ex = this.newinstance(this.size + expression.size);
        int i = ex.size;
        int i1 = this.size;
        int i2 = expression.size;
        Literal l1 = i1 > 0 ? this.literal[--i1] : null;
        Literal literal = l2 = i2 > 0 ? expression.literal[--i2].multiply(lit) : null;
        while (l1 != null || l2 != null) {
            JSCLInteger en;
            int c;
            int n = l1 == null ? 1 : (c = l2 == null ? -1 : -l1.compareTo(l2));
            if (c < 0) {
                en = this.coef[i1];
                ex.literal[--i] = l1;
                ex.coef[i] = en;
                l1 = i1 > 0 ? this.literal[--i1] : null;
                continue;
            }
            if (c > 0) {
                en = expression.coef[i2].multiply(integer);
                ex.literal[--i] = l2;
                ex.coef[i] = en;
                l2 = i2 > 0 ? expression.literal[--i2].multiply(lit) : null;
                continue;
            }
            en = this.coef[i1].add(expression.coef[i2].multiply(integer));
            if (en.signum() != 0) {
                ex.literal[--i] = l1;
                ex.coef[i] = en;
            }
            l1 = i1 > 0 ? this.literal[--i1] : null;
            l2 = i2 > 0 ? expression.literal[--i2].multiply(lit) : null;
        }
        ex.resize(ex.size - i);
        return ex;
    }

    public Expression multiply(Expression expression) {
        Expression ex = this.newinstance(0);
        for (int i = 0; i < this.size; ++i) {
            ex = ex.multiplyAndAdd(this.literal[i], this.coef[i], expression);
        }
        return ex;
    }

    public Generic multiply(Generic generic) {
        if (generic instanceof Expression) {
            return this.multiply((Expression)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.multiply(this.valueof(generic));
        }
        if (generic instanceof Rational) {
            return this.multiply(this.valueof(generic));
        }
        return generic.multiply(this);
    }

    public Generic divide(Generic generic) throws ArithmeticException {
        Generic[] a = this.divideAndRemainder(generic);
        if (a[1].signum() == 0) {
            return a[0];
        }
        throw new NotDivisibleException();
    }

    public Generic[] divideAndRemainder(Generic generic) throws ArithmeticException {
        if (generic instanceof Expression) {
            Literal l2;
            Expression ex = (Expression)generic;
            Literal l1 = this.literalScm();
            Literal l = l1.gcd(l2 = ex.literalScm());
            Variable[] va = l.variables();
            if (va.length == 0) {
                if (this.signum() == 0 && ex.signum() != 0) {
                    return new Generic[]{this, JSCLInteger.valueOf(0L)};
                }
                try {
                    return this.divideAndRemainder(ex.integerValue());
                }
                catch (NotIntegerException e) {
                    return new Generic[]{JSCLInteger.valueOf(0L), this};
                }
            }
            Polynomial fact = Polynomial.factory(va[0]);
            Polynomial[] p = fact.valueof(this).divideAndRemainder(fact.valueof(ex));
            return new Generic[]{p[0].genericValue(), p[1].genericValue()};
        }
        if (generic instanceof JSCLInteger) {
            try {
                Expression ex = this.newinstance(this.size);
                for (int i = 0; i < this.size; ++i) {
                    ex.literal[i] = this.literal[i];
                    ex.coef[i] = this.coef[i].divide((JSCLInteger)generic);
                }
                return new Generic[]{ex, JSCLInteger.valueOf(0L)};
            }
            catch (NotDivisibleException e) {
                return new Generic[]{JSCLInteger.valueOf(0L), this};
            }
        }
        if (generic instanceof Rational) {
            return this.divideAndRemainder(this.valueof(generic));
        }
        return generic.valueof(this).divideAndRemainder(generic);
    }

    public Generic gcd(Generic generic) {
        if (generic instanceof Expression) {
            Literal l2;
            Expression ex = (Expression)generic;
            Literal l1 = this.literalScm();
            Literal l = l1.gcd(l2 = ex.literalScm());
            Variable[] va = l.variables();
            if (va.length == 0) {
                if (this.signum() == 0) {
                    return ex;
                }
                return this.gcd(ex.gcd());
            }
            Polynomial fact = Polynomial.factory(va[0]);
            return fact.valueof(this).gcd(fact.valueof(ex)).genericValue();
        }
        if (generic instanceof JSCLInteger) {
            if (generic.signum() == 0) {
                return this;
            }
            return this.gcd().gcd(generic);
        }
        if (generic instanceof Rational) {
            return this.gcd(this.valueof(generic));
        }
        return generic.valueof(this).gcd(generic);
    }

    public Generic gcd() {
        JSCLInteger en = JSCLInteger.valueOf(0L);
        for (int i = this.size - 1; i >= 0; --i) {
            en = en.gcd(this.coef[i]);
        }
        return en;
    }

    public Literal literalScm() {
        Literal l = Literal.valueOf();
        for (int i = 0; i < this.size; ++i) {
            l = l.scm(this.literal[i]);
        }
        return l;
    }

    public Generic negate() {
        return this.multiply(JSCLInteger.valueOf(-1L));
    }

    public int signum() {
        return this.size == 0 ? 0 : this.coef[0].signum();
    }

    public int degree() {
        return 0;
    }

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        block10: {
            if (this.isPolynomial(variable)) {
                return ((UnivariatePolynomial)Polynomial.factory(variable).valueof(this)).antiderivative().genericValue();
            }
            try {
                Variable v = this.variableValue();
                try {
                    return v.antiderivative(variable);
                }
                catch (NotIntegrableException e) {
                    Generic[] g;
                    if (v instanceof Frac && (g = ((Frac)v).parameters())[1].isConstant(variable)) {
                        return new Inv(g[1]).evaluate().multiply(g[0].antiderivative(variable));
                    }
                }
            }
            catch (NotVariableException e) {
                Generic[] a = this.sumValue();
                if (a.length > 1) {
                    Generic s = JSCLInteger.valueOf(0L);
                    for (int i = 0; i < a.length; ++i) {
                        s = ((Generic)s).add(a[i].antiderivative(variable));
                    }
                    return s;
                }
                Generic[] p = a[0].productValue();
                Generic s = JSCLInteger.valueOf(1L);
                Generic t = JSCLInteger.valueOf(1L);
                for (int i = 0; i < p.length; ++i) {
                    if (p[i].isConstant(variable)) {
                        s = ((Generic)s).multiply(p[i]);
                        continue;
                    }
                    t = ((Generic)t).multiply(p[i]);
                }
                if (((Generic)s).compareTo(JSCLInteger.valueOf(1L)) == 0) break block10;
                return ((Generic)s).multiply(((Generic)t).antiderivative(variable));
            }
        }
        throw new NotIntegrableException();
    }

    public Generic derivative(Variable variable) {
        Generic s = JSCLInteger.valueOf(0L);
        Literal l = this.literalScm();
        int n = l.size;
        for (int i = 0; i < n; ++i) {
            Variable v = l.variable[i];
            Generic a = ((UnivariatePolynomial)Polynomial.factory(v).valueof(this)).derivative(variable).genericValue();
            s = ((Generic)s).add(a);
        }
        return s;
    }

    public Generic substitute(Variable variable, Generic generic) {
        Map m = this.literalScm().content();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Variable v = (Variable)e.getKey();
            e.setValue(v.substitute(variable, generic));
        }
        return this.substitute(m);
    }

    Generic substitute(Map map) {
        Generic s = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.size; ++i) {
            Literal l = this.literal[i];
            Generic a = this.coef[i];
            int m = l.size;
            for (int j = 0; j < m; ++j) {
                Variable v = l.variable[j];
                int c = l.power[j];
                Generic b = (Generic)map.get(v);
                if (Matrix.product(a, b = b.pow(c))) {
                    throw new ArithmeticException();
                }
                a = ((Generic)a).multiply(b);
            }
            s = ((Generic)s).add(a);
        }
        return s;
    }

    public Generic expand() {
        Map m = this.literalScm().content();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Variable v = (Variable)e.getKey();
            e.setValue(v.expand());
        }
        return this.substitute(m);
    }

    public Generic factorize() {
        Map m = this.literalScm().content();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Variable v = (Variable)e.getKey();
            e.setValue(v.factorize());
        }
        Generic a = this.substitute(m);
        return Factorization.compute(a);
    }

    public Generic elementary() {
        Map m = this.literalScm().content();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Variable v = (Variable)e.getKey();
            e.setValue(v.elementary());
        }
        return this.substitute(m);
    }

    public Generic simplify() {
        return Simplification.compute(this);
    }

    public Generic numeric() {
        try {
            return this.integerValue().numeric();
        }
        catch (NotIntegerException ex) {
            Map m = this.literalScm().content();
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Variable v = (Variable)e.getKey();
                e.setValue(v.numeric());
            }
            return this.substitute(m);
        }
    }

    public Generic valueof(Generic generic) {
        Expression ex = this.newinstance(0);
        ex.init(generic);
        return ex;
    }

    public Generic[] sumValue() {
        Generic[] a = new Generic[this.size];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Expression.valueOf(this.literal[i], this.coef[i]);
        }
        return a;
    }

    public Generic[] productValue() throws NotProductException {
        if (this.size == 0) {
            return new Generic[]{JSCLInteger.valueOf(0L)};
        }
        if (this.size == 1) {
            Literal l = this.literal[0];
            JSCLInteger en = this.coef[0];
            Generic[] p = l.productValue();
            if (en.compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return p;
            }
            Generic[] a = new Generic[p.length + 1];
            for (int i = 0; i < p.length; ++i) {
                a[i + 1] = p[i];
            }
            a[0] = en;
            return a;
        }
        throw new NotProductException();
    }

    public Power powerValue() throws NotPowerException {
        if (this.size == 0) {
            return new Power(JSCLInteger.valueOf(0L), 1);
        }
        if (this.size == 1) {
            Literal l = this.literal[0];
            JSCLInteger en = this.coef[0];
            if (en.compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return l.powerValue();
            }
            if (l.degree() == 0) {
                return en.powerValue();
            }
            throw new NotPowerException();
        }
        throw new NotPowerException();
    }

    public Expression expressionValue() throws NotExpressionException {
        return this;
    }

    public JSCLInteger integerValue() throws NotIntegerException {
        if (this.size == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.size == 1) {
            Literal l = this.literal[0];
            JSCLInteger en = this.coef[0];
            if (l.degree() == 0) {
                return en;
            }
            throw new NotIntegerException();
        }
        throw new NotIntegerException();
    }

    public Variable variableValue() throws NotVariableException {
        if (this.size == 0) {
            throw new NotVariableException();
        }
        if (this.size == 1) {
            Literal l = this.literal[0];
            JSCLInteger en = this.coef[0];
            if (en.compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return l.variableValue();
            }
            throw new NotVariableException();
        }
        throw new NotVariableException();
    }

    public Variable[] variables() {
        return this.literalScm().variables();
    }

    public static Variable[] variables(Generic[] generic) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        for (int i = 0; i < generic.length; ++i) {
            Variable[] va = generic[i].variables();
            for (int j = 0; j < va.length; ++j) {
                Variable v = va[j];
                if (l.contains(v)) continue;
                l.add(v);
            }
        }
        return (Variable[])ArrayUtils.toArray(l, new Variable[l.size()]);
    }

    public boolean isPolynomial(Variable variable) {
        boolean s = true;
        Literal l = this.literalScm();
        int n = l.size;
        for (int i = 0; i < n; ++i) {
            Variable v = l.variable[i];
            s = s && (v.isConstant(variable) || v.isIdentity(variable));
        }
        return s;
    }

    public boolean isConstant(Variable variable) {
        boolean s = true;
        Literal l = this.literalScm();
        int n = l.size;
        for (int i = 0; i < n; ++i) {
            Variable v = l.variable[i];
            s = s && v.isConstant(variable);
        }
        return s;
    }

    public JSCLVector grad(Variable[] variable) {
        Generic[] v = new Generic[variable.length];
        for (int i = 0; i < variable.length; ++i) {
            v[i] = this.derivative(variable[i]);
        }
        return new JSCLVector(v);
    }

    public Generic laplacian(Variable[] variable) {
        return this.grad(variable).divergence(variable);
    }

    public Generic dalembertian(Variable[] variable) {
        Generic a = this.derivative(variable[0]).derivative(variable[0]);
        for (int i = 1; i < 4; ++i) {
            a = a.subtract(this.derivative(variable[i]).derivative(variable[i]));
        }
        return a;
    }

    public int compareTo(Expression expression) {
        Literal l2;
        int i1 = this.size;
        int i2 = expression.size;
        Literal l1 = i1 == 0 ? null : this.literal[--i1];
        Literal literal = l2 = i2 == 0 ? null : expression.literal[--i2];
        while (l1 != null || l2 != null) {
            int c;
            int n = l1 == null ? -1 : (c = l2 == null ? 1 : l1.compareTo(l2));
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            c = this.coef[i1].compareTo(expression.coef[i2]);
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            l1 = i1 == 0 ? null : this.literal[--i1];
            l2 = i2 == 0 ? null : expression.literal[--i2];
        }
        return 0;
    }

    public int compareTo(Generic generic) {
        if (generic instanceof Expression) {
            return this.compareTo((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.compareTo(this.valueof(generic));
        }
        return generic.valueof(this).compareTo(generic);
    }

    public static Expression valueOf(Variable variable) {
        return Expression.valueOf(Literal.valueOf(variable));
    }

    public static Expression valueOf(Literal literal) {
        return Expression.valueOf(literal, JSCLInteger.valueOf(1L));
    }

    public static Expression valueOf(JSCLInteger integer) {
        return Expression.valueOf(Literal.valueOf(), integer);
    }

    public static Expression valueOf(Literal literal, JSCLInteger integer) {
        Expression ex = new Expression();
        ex.init(literal, integer);
        return ex;
    }

    void init(Literal lit, JSCLInteger integer) {
        if (integer.signum() != 0) {
            this.init(1);
            this.literal[0] = lit;
            this.coef[0] = integer;
        } else {
            this.init(0);
        }
    }

    public static Expression valueOf(Rational rational) {
        Expression ex = new Expression();
        ex.init(rational);
        return ex;
    }

    public static Expression valueOf(String str) throws ParseException {
        int[] pos = new int[1];
        Generic a = (Generic)ExpressionParser.parser.parse(str, pos);
        Parser.skipWhitespaces(str, pos);
        if (pos[0] < str.length()) {
            throw new ParseException();
        }
        Expression ex = new Expression();
        ex.init(a);
        return ex;
    }

    void init(Expression expression) {
        this.init(expression.size);
        System.arraycopy(expression.literal, 0, this.literal, 0, this.size);
        System.arraycopy(expression.coef, 0, this.coef, 0, this.size);
    }

    void init(JSCLInteger integer) {
        this.init(Literal.valueOf(), integer);
    }

    void init(Rational rational) {
        try {
            this.init(Literal.valueOf(), rational.integerValue());
        }
        catch (NotIntegerException e) {
            this.init(Literal.valueOf(rational.variableValue()), JSCLInteger.valueOf(1L));
        }
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else if (generic instanceof JSCLInteger) {
            this.init((JSCLInteger)generic);
        } else if (generic instanceof Rational) {
            this.init((Rational)generic);
        } else {
            throw new ArithmeticException();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.signum() == 0) {
            buffer.append("0");
        }
        for (int i = 0; i < this.size; ++i) {
            Literal l = this.literal[i];
            JSCLInteger en = this.coef[i];
            if (en.signum() > 0 && i > 0) {
                buffer.append("+");
            }
            if (l.degree() == 0) {
                buffer.append(en);
                continue;
            }
            if (en.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                if (en.signum() < 0) {
                    buffer.append("-");
                }
            } else {
                buffer.append(en).append("*");
            }
            buffer.append(l);
        }
        return buffer.toString();
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        if (this.signum() == 0) {
            buffer.append("JSCLDouble.valueOf(0)");
        }
        for (int i = 0; i < this.size; ++i) {
            Literal l = this.literal[i];
            JSCLInteger en = this.coef[i];
            if (i > 0) {
                if (en.signum() < 0) {
                    buffer.append(".subtract(");
                    en = (JSCLInteger)en.negate();
                } else {
                    buffer.append(".add(");
                }
            }
            if (l.degree() == 0) {
                buffer.append(en.toJava());
            } else if (en.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                if (en.signum() > 0) {
                    buffer.append(l.toJava());
                } else if (en.signum() < 0) {
                    buffer.append(l.toJava()).append(".negate()");
                }
            } else {
                buffer.append(en.toJava()).append(".multiply(").append(l.toJava()).append(")");
            }
            if (i <= 0) continue;
            buffer.append(")");
        }
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        MathML e1 = element.element("mrow");
        if (this.signum() == 0) {
            MathML e2 = element.element("mn");
            e2.appendChild(element.text("0"));
            e1.appendChild(e2);
        }
        for (int i = 0; i < this.size; ++i) {
            MathML e2;
            Literal l = this.literal[i];
            JSCLInteger en = this.coef[i];
            if (en.signum() > 0 && i > 0) {
                e2 = element.element("mo");
                e2.appendChild(element.text("+"));
                e1.appendChild(e2);
            }
            if (l.degree() == 0) {
                Expression.separateSign(e1, en);
                continue;
            }
            if (en.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                if (en.signum() < 0) {
                    e2 = element.element("mo");
                    e2.appendChild(element.text("-"));
                    e1.appendChild(e2);
                }
            } else {
                Expression.separateSign(e1, en);
            }
            l.toMathML(e1, null);
        }
        element.appendChild(e1);
    }

    public static void separateSign(MathML element, Generic generic) {
        if (generic.signum() < 0) {
            MathML e1 = element.element("mo");
            e1.appendChild(element.text("-"));
            element.appendChild(e1);
            generic.negate().toMathML(element, null);
        } else {
            generic.toMathML(element, null);
        }
    }

    protected Expression newinstance(int n) {
        return new Expression(n);
    }
}

