/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Arithmetic;
import jscl.math.Expression;
import jscl.math.JSCLInteger;
import jscl.math.NotDivisibleException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.mathml.MathML;

public abstract class Generic
implements Arithmetic,
Comparable {
    public abstract Generic add(Generic var1);

    public Generic subtract(Generic generic) {
        return this.add(generic.negate());
    }

    public abstract Generic multiply(Generic var1);

    public boolean multiple(Generic generic) throws ArithmeticException {
        return this.remainder(generic).signum() == 0;
    }

    public abstract Generic divide(Generic var1) throws ArithmeticException;

    public Arithmetic add(Arithmetic arithmetic) {
        return this.add((Generic)arithmetic);
    }

    public Arithmetic subtract(Arithmetic arithmetic) {
        return this.subtract((Generic)arithmetic);
    }

    public Arithmetic multiply(Arithmetic arithmetic) {
        return this.multiply((Generic)arithmetic);
    }

    public Arithmetic divide(Arithmetic arithmetic) throws ArithmeticException {
        return this.divide((Generic)arithmetic);
    }

    public Generic[] divideAndRemainder(Generic generic) throws ArithmeticException {
        try {
            return new Generic[]{this.divide(generic), JSCLInteger.valueOf(0L)};
        }
        catch (NotDivisibleException e) {
            return new Generic[]{JSCLInteger.valueOf(0L), this};
        }
    }

    public Generic remainder(Generic generic) throws ArithmeticException {
        return this.divideAndRemainder(generic)[1];
    }

    public Generic inverse() {
        return JSCLInteger.valueOf(1L).divide(this);
    }

    public abstract Generic gcd(Generic var1);

    public Generic scm(Generic generic) {
        return this.divide(this.gcd(generic)).multiply(generic);
    }

    public abstract Generic gcd();

    public Generic[] gcdAndNormalize() {
        Generic gcd = this.gcd();
        if (gcd.signum() == 0) {
            return new Generic[]{gcd, this};
        }
        if (gcd.signum() != this.signum()) {
            gcd = gcd.negate();
        }
        return new Generic[]{gcd, this.divide(gcd)};
    }

    public Generic normalize() {
        return this.gcdAndNormalize()[1];
    }

    public Generic pow(int exponent) {
        Generic a = JSCLInteger.valueOf(1L);
        for (int i = 0; i < exponent; ++i) {
            a = ((Generic)a).multiply(this);
        }
        return a;
    }

    public Generic abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public abstract Generic negate();

    public abstract int signum();

    public abstract int degree();

    public abstract Generic antiderivative(Variable var1) throws NotIntegrableException;

    public abstract Generic derivative(Variable var1);

    public abstract Generic substitute(Variable var1, Generic var2);

    public abstract Generic expand();

    public abstract Generic factorize();

    public abstract Generic elementary();

    public abstract Generic simplify();

    public abstract Generic numeric();

    public abstract Generic valueof(Generic var1);

    public abstract Generic[] sumValue();

    public abstract Generic[] productValue() throws NotProductException;

    public abstract Power powerValue() throws NotPowerException;

    public abstract Expression expressionValue() throws NotExpressionException;

    public abstract JSCLInteger integerValue() throws NotIntegerException;

    public abstract Variable variableValue() throws NotVariableException;

    public abstract Variable[] variables();

    public abstract boolean isPolynomial(Variable var1);

    public abstract boolean isConstant(Variable var1);

    public boolean isIdentity(Variable variable) {
        try {
            return this.variableValue().isIdentity(variable);
        }
        catch (NotVariableException e) {
            return false;
        }
    }

    public abstract int compareTo(Generic var1);

    public int compareTo(Object o) {
        return this.compareTo((Generic)o);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Generic) {
            return this.compareTo((Generic)obj) == 0;
        }
        return false;
    }

    public abstract String toJava();

    public String toMathML() {
        MathML document = new MathML("math", "-//W3C//DTD MathML 2.0//EN", "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd");
        MathML e = document.element("math");
        this.toMathML(e, null);
        return e.toString();
    }

    public abstract void toMathML(MathML var1, Object var2);
}

