/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Clifford;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Matrix;
import jscl.math.NotDivisibleException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Conjugate;
import jscl.math.function.Frac;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public class JSCLVector
extends Generic {
    protected final Generic[] element;
    protected final int n;

    public JSCLVector(Generic[] element) {
        this.element = element;
        this.n = element.length;
    }

    public Generic[] elements() {
        return this.element;
    }

    public JSCLVector add(JSCLVector vector) {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].add(vector.element[i]);
        }
        return v;
    }

    public Generic add(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.add((JSCLVector)generic);
        }
        return this.add(this.valueof(generic));
    }

    public JSCLVector subtract(JSCLVector vector) {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].subtract(vector.element[i]);
        }
        return v;
    }

    public Generic subtract(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.subtract((JSCLVector)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public Generic multiply(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.scalarProduct((JSCLVector)generic);
        }
        if (generic instanceof Matrix) {
            return ((Matrix)generic).transpose().multiply(this);
        }
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].multiply(generic);
        }
        return v;
    }

    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof JSCLVector) {
            throw new ArithmeticException();
        }
        if (generic instanceof Matrix) {
            return this.multiply(((Matrix)generic).inverse());
        }
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            try {
                v.element[i] = this.element[i].divide(generic);
                continue;
            }
            catch (NotDivisibleException e) {
                v.element[i] = new Frac(this.element[i], generic).evaluate();
            }
        }
        return v;
    }

    public Generic gcd(Generic generic) {
        return null;
    }

    public Generic gcd() {
        return null;
    }

    public Generic negate() {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].negate();
        }
        return v;
    }

    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            int c = this.element[i].signum();
            if (c < 0) {
                return -1;
            }
            if (c <= 0) continue;
            return 1;
        }
        return 0;
    }

    public int degree() {
        return 0;
    }

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].antiderivative(variable);
        }
        return v;
    }

    public Generic derivative(Variable variable) {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].derivative(variable);
        }
        return v;
    }

    public Generic substitute(Variable variable, Generic generic) {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].substitute(variable, generic);
        }
        return v;
    }

    public Generic expand() {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].expand();
        }
        return v;
    }

    public Generic factorize() {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].factorize();
        }
        return v;
    }

    public Generic elementary() {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].elementary();
        }
        return v;
    }

    public Generic simplify() {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].simplify();
        }
        return v;
    }

    public Generic numeric() {
        return new NumericWrapper(this);
    }

    public Generic valueof(Generic generic) {
        if (generic instanceof JSCLVector || generic instanceof Matrix) {
            throw new ArithmeticException();
        }
        JSCLVector v = (JSCLVector)JSCLVector.unity(this.n).multiply(generic);
        return this.newinstance(v.element);
    }

    public Generic[] sumValue() {
        return new Generic[]{this};
    }

    public Generic[] productValue() throws NotProductException {
        return new Generic[]{this};
    }

    public Power powerValue() throws NotPowerException {
        return new Power(this, 1);
    }

    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    public Variable[] variables() {
        return null;
    }

    public boolean isPolynomial(Variable variable) {
        return false;
    }

    public boolean isConstant(Variable variable) {
        return false;
    }

    public Generic magnitude2() {
        return this.scalarProduct(this);
    }

    public Generic scalarProduct(JSCLVector vector) {
        Generic a = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.n; ++i) {
            a = ((Generic)a).add(this.element[i].multiply(vector.element[i]));
        }
        return a;
    }

    public JSCLVector vectorProduct(JSCLVector vector) {
        JSCLVector v = (JSCLVector)this.newinstance();
        Generic[][] m = new Generic[][]{{JSCLInteger.valueOf(0L), this.element[2].negate(), this.element[1]}, {this.element[2], JSCLInteger.valueOf(0L), this.element[0].negate()}, {this.element[1].negate(), this.element[0], JSCLInteger.valueOf(0L)}};
        JSCLVector v2 = (JSCLVector)new Matrix(m).multiply(vector);
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = i < v2.n ? v2.element[i] : JSCLInteger.valueOf(0L);
        }
        return v;
    }

    public JSCLVector complexProduct(JSCLVector vector) {
        return this.product(new Clifford(0, 1).operator(), vector);
    }

    public JSCLVector quaternionProduct(JSCLVector vector) {
        return this.product(new Clifford(0, 2).operator(), vector);
    }

    public JSCLVector geometricProduct(JSCLVector vector, int[] algebra) {
        int[] nArray;
        if (algebra == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = Clifford.log2e(this.n);
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            nArray = algebra;
        }
        return this.product(new Clifford(nArray).operator(), vector);
    }

    JSCLVector product(int[][] product, JSCLVector vector) {
        int i;
        JSCLVector v = (JSCLVector)this.newinstance();
        for (i = 0; i < this.n; ++i) {
            v.element[i] = JSCLInteger.valueOf(0L);
        }
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                Generic a = this.element[i].multiply(vector.element[j]);
                int k = Math.abs(product[i][j]) - 1;
                v.element[k] = v.element[k].add(product[i][j] < 0 ? a.negate() : a);
            }
        }
        return v;
    }

    public Generic divergence(Variable[] variable) {
        Generic a = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.n; ++i) {
            a = ((Generic)a).add(this.element[i].derivative(variable[i]));
        }
        return a;
    }

    public JSCLVector curl(Variable[] variable) {
        JSCLVector v = (JSCLVector)this.newinstance();
        v.element[0] = this.element[2].derivative(variable[1]).subtract(this.element[1].derivative(variable[2]));
        v.element[1] = this.element[0].derivative(variable[2]).subtract(this.element[2].derivative(variable[0]));
        v.element[2] = this.element[1].derivative(variable[0]).subtract(this.element[0].derivative(variable[1]));
        for (int i = 3; i < this.n; ++i) {
            v.element[i] = this.element[i];
        }
        return v;
    }

    public Matrix jacobian(Variable[] variable) {
        Matrix m = new Matrix(new Generic[this.n][variable.length]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < variable.length; ++j) {
                m.element[i][j] = this.element[i].derivative(variable[j]);
            }
        }
        return m;
    }

    public Generic del(Variable[] variable, int[] algebra) {
        int[] nArray;
        if (algebra == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = Clifford.log2e(this.n);
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            nArray = algebra;
        }
        return this.differential(new Clifford(nArray).operator(), variable);
    }

    JSCLVector differential(int[][] product, Variable[] variable) {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = JSCLInteger.valueOf(0L);
        }
        int l = Clifford.log2e(this.n);
        for (int i = 1; i <= l; ++i) {
            for (int j = 0; j < this.n; ++j) {
                Generic a = this.element[j].derivative(variable[i - 1]);
                int k = Math.abs(product[i][j]) - 1;
                v.element[k] = v.element[k].add(product[i][j] < 0 ? a.negate() : a);
            }
        }
        return v;
    }

    public Generic conjugate() {
        JSCLVector v = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = new Conjugate(this.element[i]).evaluate();
        }
        return v;
    }

    public int compareTo(JSCLVector vector) {
        return ArrayComparator.comparator.compare(this.element, vector.element);
    }

    public int compareTo(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.compareTo((JSCLVector)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static JSCLVector unity(int dimension) {
        JSCLVector v = new JSCLVector(new Generic[dimension]);
        for (int i = 0; i < v.n; ++i) {
            v.element[i] = i == 0 ? JSCLInteger.valueOf(1L) : JSCLInteger.valueOf(0L);
        }
        return v;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            buffer.append(this.element[i]).append(i < this.n - 1 ? ", " : "");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new NumericVector(new Numeric[] {");
        for (int i = 0; i < this.n; ++i) {
            buffer.append(this.element[i].toJava()).append(i < this.n - 1 ? ", " : "");
        }
        buffer.append("})");
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    protected void bodyToMathML(MathML e0) {
        MathML e1 = e0.element("mfenced");
        MathML e2 = e0.element("mtable");
        for (int i = 0; i < this.n; ++i) {
            MathML e3 = e0.element("mtr");
            MathML e4 = e0.element("mtd");
            this.element[i].toMathML(e4, null);
            e3.appendChild(e4);
            e2.appendChild(e3);
        }
        e1.appendChild(e2);
        e0.appendChild(e1);
    }

    protected Generic newinstance() {
        return this.newinstance(new Generic[this.n]);
    }

    protected Generic newinstance(Generic[] element) {
        return new JSCLVector(element);
    }
}

