/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Matrix;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Rational;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.math.numeric.NumericMatrix;
import jscl.math.numeric.NumericVector;
import jscl.mathml.MathML;

public final class NumericWrapper
extends Generic {
    final Numeric content;

    public NumericWrapper(JSCLInteger integer) {
        this.content = JSCLDouble.valueOf(integer.content().doubleValue());
    }

    public NumericWrapper(Rational rational) {
        this.content = JSCLDouble.valueOf(rational.numerator().doubleValue() / rational.denominator().doubleValue());
    }

    public NumericWrapper(JSCLVector vector) {
        Numeric[] v = new Numeric[vector.n];
        for (int i = 0; i < vector.n; ++i) {
            v[i] = ((NumericWrapper)vector.element[i].numeric()).content();
        }
        this.content = new NumericVector(v);
    }

    public NumericWrapper(Matrix matrix) {
        Numeric[][] m = new Numeric[matrix.n][matrix.p];
        for (int i = 0; i < matrix.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                m[i][j] = ((NumericWrapper)matrix.element[i][j].numeric()).content();
            }
        }
        this.content = new NumericMatrix(m);
    }

    public NumericWrapper(Constant constant) {
        if (constant.compareTo(new Constant("pi")) == 0) {
            this.content = JSCLDouble.valueOf(Math.PI);
        } else if (constant.compareTo(new Constant("infin")) == 0) {
            this.content = JSCLDouble.valueOf(Double.POSITIVE_INFINITY);
        } else {
            throw new ArithmeticException();
        }
    }

    public NumericWrapper(Numeric numeric) {
        this.content = numeric;
    }

    public Numeric content() {
        return this.content;
    }

    public NumericWrapper add(NumericWrapper wrapper) {
        return new NumericWrapper(this.content.add(wrapper.content));
    }

    public Generic add(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.add((NumericWrapper)generic);
        }
        return this.add(this.valueof(generic));
    }

    public NumericWrapper subtract(NumericWrapper wrapper) {
        return new NumericWrapper(this.content.subtract(wrapper.content));
    }

    public Generic subtract(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.subtract((NumericWrapper)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public NumericWrapper multiply(NumericWrapper wrapper) {
        return new NumericWrapper(this.content.multiply(wrapper.content));
    }

    public Generic multiply(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.multiply((NumericWrapper)generic);
        }
        return this.multiply(this.valueof(generic));
    }

    public NumericWrapper divide(NumericWrapper wrapper) throws ArithmeticException {
        return new NumericWrapper(this.content.divide(wrapper.content));
    }

    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof NumericWrapper) {
            return this.divide((NumericWrapper)generic);
        }
        return this.divide(this.valueof(generic));
    }

    public Generic gcd(Generic generic) {
        return null;
    }

    public Generic gcd() {
        return null;
    }

    public Generic abs() {
        return new NumericWrapper(this.content.abs());
    }

    public Generic negate() {
        return new NumericWrapper(this.content.negate());
    }

    public int signum() {
        return this.content.signum();
    }

    public int degree() {
        return 0;
    }

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    public Generic derivative(Variable variable) {
        return null;
    }

    public Generic substitute(Variable variable, Generic generic) {
        return null;
    }

    public Generic expand() {
        return null;
    }

    public Generic factorize() {
        return null;
    }

    public Generic elementary() {
        return null;
    }

    public Generic simplify() {
        return null;
    }

    public Generic numeric() {
        return this;
    }

    public NumericWrapper valueof(NumericWrapper wrapper) {
        return new NumericWrapper(this.content.valueof(wrapper.content));
    }

    public Generic valueof(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.valueof((NumericWrapper)generic);
        }
        if (generic instanceof JSCLInteger) {
            return new NumericWrapper((JSCLInteger)generic);
        }
        throw new ArithmeticException();
    }

    public Generic[] sumValue() {
        return null;
    }

    public Generic[] productValue() throws NotProductException {
        return null;
    }

    public Power powerValue() throws NotPowerException {
        return null;
    }

    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    public Variable[] variables() {
        return new Variable[0];
    }

    public boolean isPolynomial(Variable variable) {
        return true;
    }

    public boolean isConstant(Variable variable) {
        return true;
    }

    public Generic sgn() {
        return new NumericWrapper(this.content.sgn());
    }

    public Generic log() {
        return new NumericWrapper(this.content.log());
    }

    public Generic exp() {
        return new NumericWrapper(this.content.exp());
    }

    public Generic pow(Generic generic) {
        return new NumericWrapper(this.content.pow(((NumericWrapper)generic).content));
    }

    public Generic sqrt() {
        return new NumericWrapper(this.content.sqrt());
    }

    public Generic nthrt(int n) {
        return new NumericWrapper(this.content.nthrt(n));
    }

    public static Generic root(int subscript, Generic[] parameter) {
        Numeric[] param = new Numeric[parameter.length];
        for (int i = 0; i < param.length; ++i) {
            param[i] = ((NumericWrapper)parameter[i]).content;
        }
        return new NumericWrapper(Numeric.root(subscript, param));
    }

    public Generic conjugate() {
        return new NumericWrapper(this.content.conjugate());
    }

    public Generic acos() {
        return new NumericWrapper(this.content.acos());
    }

    public Generic asin() {
        return new NumericWrapper(this.content.asin());
    }

    public Generic atan() {
        return new NumericWrapper(this.content.atan());
    }

    public Generic acot() {
        return new NumericWrapper(this.content.acot());
    }

    public Generic cos() {
        return new NumericWrapper(this.content.cos());
    }

    public Generic sin() {
        return new NumericWrapper(this.content.sin());
    }

    public Generic tan() {
        return new NumericWrapper(this.content.tan());
    }

    public Generic cot() {
        return new NumericWrapper(this.content.cot());
    }

    public Generic acosh() {
        return new NumericWrapper(this.content.acosh());
    }

    public Generic asinh() {
        return new NumericWrapper(this.content.asinh());
    }

    public Generic atanh() {
        return new NumericWrapper(this.content.atanh());
    }

    public Generic acoth() {
        return new NumericWrapper(this.content.acoth());
    }

    public Generic cosh() {
        return new NumericWrapper(this.content.cosh());
    }

    public Generic sinh() {
        return new NumericWrapper(this.content.sinh());
    }

    public Generic tanh() {
        return new NumericWrapper(this.content.tanh());
    }

    public Generic coth() {
        return new NumericWrapper(this.content.coth());
    }

    public int compareTo(NumericWrapper wrapper) {
        return this.content.compareTo(wrapper.content);
    }

    public int compareTo(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.compareTo((NumericWrapper)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public String toString() {
        return this.content.toString();
    }

    public String toJava() {
        return "JSCLDouble.valueOf(" + new Double(((JSCLDouble)this.content).doubleValue()) + ")";
    }

    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("mn");
        e1.appendChild(element.text(String.valueOf(new Double(((JSCLDouble)this.content).doubleValue()))));
        element.appendChild(e1);
    }

    protected Generic newinstance() {
        return null;
    }
}

