/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.VariableComparator;
import jscl.mathml.MathML;
import jscl.text.ParseException;

public abstract class Variable
implements Comparable {
    public static final Comparator comparator = VariableComparator.comparator;
    protected String name;
    static final Map special = new HashMap();

    public Variable(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public abstract Generic antiderivative(Variable var1) throws NotIntegrableException;

    public abstract Generic derivative(Variable var1);

    public abstract Generic substitute(Variable var1, Generic var2);

    public abstract Generic expand();

    public abstract Generic factorize();

    public abstract Generic elementary();

    public abstract Generic simplify();

    public abstract Generic numeric();

    public Expression expressionValue() {
        return Expression.valueOf(this);
    }

    public abstract boolean isConstant(Variable var1);

    public boolean isIdentity(Variable variable) {
        return this.compareTo(variable) == 0;
    }

    public abstract int compareTo(Variable var1);

    public int compareTo(Object o) {
        return this.compareTo((Variable)o);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            return this.compareTo((Variable)obj) == 0;
        }
        return false;
    }

    public static Variable valueOf(String str) throws ParseException, NotVariableException {
        return Expression.valueOf(str).variableValue();
    }

    public String toString() {
        return this.name;
    }

    public String toJava() {
        return this.name;
    }

    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.nameToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.nameToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    protected void nameToMathML(MathML element) {
        MathML e1 = element.element("mi");
        e1.appendChild(element.text(special.containsKey(this.name) ? (String)special.get(this.name) : this.name));
        element.appendChild(e1);
    }

    protected abstract Variable newinstance();

    static {
        special.put("Alpha", "\u0391");
        special.put("Beta", "\u0392");
        special.put("Gamma", "\u0393");
        special.put("Delta", "\u0394");
        special.put("Epsilon", "\u0395");
        special.put("Zeta", "\u0396");
        special.put("Eta", "\u0397");
        special.put("Theta", "\u0398");
        special.put("Iota", "\u0399");
        special.put("Kappa", "\u039a");
        special.put("Lambda", "\u039b");
        special.put("Mu", "\u039c");
        special.put("Nu", "\u039d");
        special.put("Xi", "\u039e");
        special.put("Pi", "\u03a0");
        special.put("Rho", "\u03a1");
        special.put("Sigma", "\u03a3");
        special.put("Tau", "\u03a4");
        special.put("Upsilon", "\u03a5");
        special.put("Phi", "\u03a6");
        special.put("Chi", "\u03a7");
        special.put("Psi", "\u03a8");
        special.put("Omega", "\u03a9");
        special.put("alpha", "\u03b1");
        special.put("beta", "\u03b2");
        special.put("gamma", "\u03b3");
        special.put("delta", "\u03b4");
        special.put("epsilon", "\u03b5");
        special.put("zeta", "\u03b6");
        special.put("eta", "\u03b7");
        special.put("theta", "\u03b8");
        special.put("iota", "\u03b9");
        special.put("kappa", "\u03ba");
        special.put("lambda", "\u03bb");
        special.put("mu", "\u03bc");
        special.put("nu", "\u03bd");
        special.put("xi", "\u03be");
        special.put("pi", "\u03c0");
        special.put("rho", "\u03c1");
        special.put("sigma", "\u03c3");
        special.put("tau", "\u03c4");
        special.put("upsilon", "\u03c5");
        special.put("phi", "\u03c6");
        special.put("chi", "\u03c7");
        special.put("psi", "\u03c8");
        special.put("omega", "\u03c9");
        special.put("infin", "\u221e");
        special.put("nabla", "\u2207");
        special.put("aleph", "\u2135");
        special.put("hbar", "\u210f");
        special.put("hamilt", "\u210b");
        special.put("lagran", "\u2112");
        special.put("square", "\u25a1");
    }
}

